;********************************
;*                              *
;*   ETT CO.,LTD.               *
;*   PROJECT P34007             *
;*   DATE 11/5/1992             *
;*   BOARD CP-JR180 TEST        *
;*         (ROM ET-DEBUG180)    *
;*         (ROM PROGRAM 27C64)  *
;*         LCD 16116H           *
;*   by    KOBKIT T.            *
;*                              *
;********************************
;
                .ORG H'0
;
                .EQU PORTA,40H
                .EQU PORTB,41H
                .EQU PORTC,42H
                .EQU CONTROL,43H
                .EQU PWDT,0C0H
                .EQU NUMDATA0,14              ; NUMBER DATA 0
                .EQU TSOUND,800H              ; TIME FEQ SOUND
                .EQU FEG,0E0H                  ; FEG SOUND
                .EQU FEGX,40H
;---               .EQU ASCI,0FFD5H              ; INT VEC ASCI
                .EQU SYSCAL,10H
;
                .ORG 0H

                XOR  A                        ;POWER ON
                DI
STR_1:          NOP
                NOP
                DEC  A
                JR   NZ,STR_1
                JP   INIT

                .ORG 4EH                      ;VECTOR INT
                .DRW  INTKEY
                .DB   0,0
;
INIT:           LD HL,8000H
INIT1:          DEC HL
                LD  A,H
                OR  L
                JR  NZ,INIT1

                LD SP,9FF0H                  ;STACK

                LD A,88H                      ; Initialize 8255
                OUT (CONTROL),A
                NOP
                LD A,88H                      ; Initialize 8255
                OUT (CONTROL),A

                LD A,0DH                      ; Set serial#0 to 300 baud
                OUT0 (2),A

                LD A,02H                      ; Set serial#1 to 9600 baud
                OUT0 (3),A

                LD A,60H                      ; Set 7n1 for Serial#0
                OUT0 (0),A

                LD A,64H                      ; Set 8n1 for Serail#1
                OUT0 (1),A

;---                LD DE,INTKEY                  ; LOAD INT VECT
;---                LD (ASCI),DE
                CALL  CLSRXBUF
                CALL  SOUNDX
                CALL  INITLCD
                CALL  LCDSTG
                .DB   "READ-RIT",00
                LD    C,40H
                CALL  GOTOLCD
                CALL  LCDSTG
                .DB   "E (THAI)",00
                CALL  L_DELAY
                CALL  L_DELAY
;
                LD    C,0
                CALL  GOTOLCD
                CALL  LCDSTG
                .DB   "PROGRAM ",00
                LD    C,40H
                CALL  GOTOLCD
                CALL  LCDSTG
                .DB   "( HGL ) ",00
                CALL  L_DELAY
                CALL  L_DELAY
                CALL  L_DELAY
;
SPEC_NO:        CALL  INITLCD
                CALL  LCDSTG
                .DB "SPEC NO?",00
;
                LD    C,41H
                CALL  IN4
                CALL  KEY4ASC
                CALL  L_DELAY
                CALL  SOUNDX
                CALL  L_DELAY
                CALL  L_DELAY
 ;=====                               HEAD NUMBER
                LD    C,0
                CALL  GOTOLCD
                CALL  LCDSTG
                .DB  "HEAD NO?",00
KEYHEAD:        LD    C,41H
                CALL  GOTOLCD
                CALL  LCDSTG
                .DB  "        ",00
                LD    C,41H
                CALL  GOTOLCD
                LD    HL,COUNT
                CALL KEYIN
                LD   C,A
                CALL WBYTELCD
                LD   HL,COUNT+1
                CALL KEYIN
                LD   C,A
                CALL WBYTELCD
                LD   A,(COUNT)
                CP   '0'
                JP   NZ,HEADN1
                LD   A,(COUNT+1)
                CP   '0'
                JP   Z,KEYHEAD

HEADN1:         CALL L_DELAY
                CALL SOUNDX
                CALL L_DELAY
;
LOOPMAIN:       LD    C,0
                CALL  GOTOLCD
                CALL  LCDSTG
                .DB  "        ",00
                LD    C,40H
                CALL  GOTOLCD
                CALL  LCDSTG
                .DB  "        ",00
                LD    C,0
                CALL  GOTOLCD
                CALL  LCDSTG
                .DB  "H#   SP#",00
                LD    C,41H
                CALL  GOTOLCD
                LD    HL,KEYINBUF     ;SPECNO.
                LD    B,4

HEADN2:         LD    A,(HL)
                LD    D,A
                CALL  WRBYTE
                INC   HL
                DJNZ  HEADN2

                CALL  GOTOLCD
                LD    C,02H
                CALL  GOTOLCD

                LD   C,0                      ;HEAD START=00
                CALL DSPCLCD

                LD    C,47H
                CALL  GOTOLCD

                LD    HL,COUNT
                CALL  ATOH1
                LD    A,E
                LD    (COUNBYTE),A            ;COUNTER DATA HEX
                LD    (SHOCOUN),A
;
                LD A,08H                      ; ENABLE INTERRUPT FOR SERIAL#0
                OUT0 (4H),A
;
                LD A,0
                LD I,A
                LD A,40H                      ;VECTOR AT 40H
                OUT0 (33H),A
                LD   A,0
                LD   (NUMRX0),A
                IN0  A,(00H)
                RES  3,A
                OUT0  (00H),A
                IN0  A,(08H)
;
                XOR  A
                LD   (COUNX),A          ;CLEAR HEAD COUN= COUNTBYTE
                LD   HL,DATA0
                LD   (ADDRBUF),HL
;
INRX0:          EI
;
LOOP:           LD   A,(NUMRX0)
LOOP1:          CP   NUMDATA0                 ;END DATA IN 0
                JP   Z,LOOPHE
                CALL WDT
                JP   LOOP

LOOPHE:         LD   A,(SHOCOUN)
                SUB  1
                DAA
                LD   (SHOCOUN),A
                LD   C,2H
                CALL GOTOLCD
                LD   A,(COUNX)      ;SHOW HEAD 00-XX (INC NO.)
                LD   C,A
                CALL DSPCLCD
                LD   C,47H
                CALL GOTOLCD

                LD   A,(COUNX)
                ADD  A,1
                DAA
                LD   (COUNX),A
                LD   B,A
                LD   A,(COUNBYTE)
                CP   B
                JP   Z,SEND
                LD   HL,(ADDRBUF)
                LD   DE,NUMDATA0
                ADD  HL,DE
                LD   (ADDRBUF),HL
                LD   A,0
                LD   (NUMRX0),A
;
                JP   LOOP
;
SEND:           CALL SOUNDX
                LD   C,0
                CALL GOTOLCD
                CALL LCDSTG
                .DB  "= SENDIN",00
                LD   C,40H
                CALL GOTOLCD
                CALL LCDSTG
                .DB  "G DATA =",00
                LD   HL,DATA0
                LD   (ADDRBUF),HL
                XOR  A
                LD   (COUNX),A
                DI
                LD   A,80H
                OUT  (PORTB),A

LOOPSEND:       LD   A,'*'           ; SEND * TO SPECIFIED START
                OUT0 (7H),A
                CALL DELAY
;
                LD   B,4            ; SPEC NO 4 DIGAND A OR B
                LD   HL,KEYINBUF    ; SEND SPECNO.
SEND_SPEC:      LD   A,(HL)
                OUT0 (7H),A
                CALL DELAY
                INC  HL
                DEC  B
                JP   NZ, SEND_SPEC

                LD   A,','           ; SEND , TO START HEAD
                OUT0 (7H),A
                CALL DELAY
;
                LD   A,(COUNBYTE)    ;COUNTER DATA HEX
                CALL ASCHEX
                LD   A,D
                OUT0 (7H),A
                CALL DELAY
                LD   A,E
                OUT0 (7H),A
                CALL DELAY
;
                LD   A,','                      ; SEND , TO START HEAD
                OUT0 (7H),A
                CALL DELAY
;
                LD   A,(COUNBYTE)
                LD   (SHOCOUN),A
                LD   B,NUMDATA0                 ; SEND DATA 0
                LD   HL,(ADDRBUF)               ; SEND DATA VALUE
SEND_DATA:      LD   A,(HL)
                CP   0AH                        ;CR,LF NOT SEND DATA
                JP   Z,CRLF
                CP   0DH
                JP   Z,CRLF
                OUT0 (7H),A
CRLF:           CALL DELAY
                CALL WDT
                INC  HL
                DEC  B
                JP   NZ, SEND_DATA
                CALL DELAY
                LD   A,','
                OUT0 (7H),A
                CALL DELAY
;
                LD   A,(SHOCOUN)
                SUB  1
                DAA
                LD   (SHOCOUN),A
                CP   1
                JP   Z,ENDSEND

                LD   HL,(ADDRBUF)
                LD   DE,NUMDATA0
                ADD  HL,DE
                LD   (ADDRBUF),HL
                LD   A,0
                LD   (NUMRX0),A
                LD   B,NUMDATA0                 ; SEND DATA 0
                LD   HL,(ADDRBUF)               ; SEND DATA VALUE
;
                JP   SEND_DATA
;
ENDSEND:        LD   B,NUMDATA0                 ; SEND DATA 0
ENDS1:          LD   A,(HL)
                CP   0AH                        ;CR,LF NOT SEND DATA
                JP   Z,ENDCRLF
                CP   0DH
                JP   Z,ENDCRLF
                OUT0 (7H),A

ENDCRLF:        CALL DELAY
                CALL WDT
                INC  HL
                DEC  B
                JP   NZ,ENDS1
                CALL DELAY

                LD   A,0DH         ;SEND CR
                OUT0 (7H),A
                CALL DELAY

                LD   A,0AH         ;SEND LF
                OUT0 (7H),A
                CALL DELAY

                LD   A,0
                LD   (NUMRX0),A
                IN0  A,(00H)
                RES  3,A
                OUT0  (00H),A
                IN0  A,(08H)
                CALL DELAY
;
                LD   A,00H
                OUT  (PORTB),A
                JP   LOOPMAIN
;
INTKEY:         DI
                PUSH DE
                PUSH BC
                PUSH HL
                PUSH AF
;
INTKEY1:        LD   HL,(ADDRBUF)
                LD   A,(NUMRX0)
                LD   E,A
                LD   D,0
                ADD  HL,DE
                IN0  A,(8H)
                PUSH AF
                LD   (HL),A
                LD   HL,NUMRX0
                INC  (HL)
                LD   C,47H
                CALL GOTOLCD

                POP  AF
                LD   C,A
                CALL WBYTELCD

INTKEY2:        POP  AF
                POP  HL
                POP  BC
                POP  DE
                EI
                RETI
;
DELAY:   PUSH BC
         PUSH AF
         LD   B,00H
DELAYX:  DEC  B
         NOP
         NOP
         NOP
         NOP
         NOP
         JP   NZ,DELAYX
         CALL WDT
         POP  AF
         POP  BC
         RET
;
L_DELAY: PUSH BC
         PUSH AF
         LD   B,30H
LDELAYX: CALL WDT
         LD   A,0
LDE2:    DEC  A
         NOP
         NOP
         JP   NZ,LDE2
         DEC  B
         JP   NZ,LDELAYX
         POP  AF
         POP  BC
         RET
;
;***********************
; CONVER HEX TO ASCII 4 DIG
;  KEY4 TO KEYINBUF
;
KEY4ASC: LD   A,(KEY4)
         CALL ASCH1
         LD   A,E
         LD   (KEYINBUF),A
         LD   A,(KEY4+1)
         CALL ASCH1
         LD   A,E
         LD   (KEYINBUF+1),A
         LD   A,(KEY4+2)
         CALL ASCH1
         LD   A,E
         LD   (KEYINBUF+2),A
         RET
;
;________________________________
;
; I/O LCD PORT
;
         .EQU    PDATA,80H
         .EQU    PSING,82H
         .EQU    PREAD,84H
;
;******************************
;*   TEST LCD                 *
;*   16 CHARACTERS * 1 LINE   *
;****************++************
;
TAB161:  .DB "*TEST CP-Z84C11*"
WRP:     LD   A,00H
         CALL GOTO
         CALL WRLINE
         LD   A,40H
         CALL GOTO
         CALL WRLINE
         RET
;
GOTO:    SET  7,A
         OUT  (PDATA),A
         CALL  READ
         RET
;
READ:    IN   A,(PREAD)
         BIT  7,A
         CALL WDT
         JP   NZ,READ
         RET

WRLINE:  LD   B,8
TEST11:  LD   A,(HL)
         LD   D,A
         CALL WRBYTE
         INC HL
         DEC  B
         JP   NZ,TEST11
         RET
;
;***********************
;      INITIAL LCD     *
;***********************
;
INITLCD:  LD   A,00111000B    ;function set  38H
                              ;DL=1 8 bit,N=1 1/16 duty,F=0 5x7
          OUT  (PDATA),A
          CALL DELAY1
          CALL DELAY1        ;DELAY > 4.1 ms
          LD  A,00001111B    ;display on/off control
                              ;D=1 off,C=1 cursor on,B=1 blink
          OUT  (PDATA),A
          CALL DELAY1

          LD   A,00000110B    ;entry mode set
                              ;I/D=1 increment,S=0 right
          OUT  (PDATA),A
          CALL DELAY1

CLSLCD:   LD   A,00000001B    ;clear all display
          OUT  (PDATA),A
          CALL READ
          RET
;
;***** WRITE BYTE SUB ****
;
WRBYTE:  LD  A,D
         OUT (PSING),A
         CALL READ
         RET
;
;***** READY SUB *****
;
DELAY1:  PUSH BC
         PUSH AF
         LD   B,80H
DELAY12: DEC  B
         JP   NZ,DELAY12
         CALL WDT
         POP  AF
         POP  BC
         RET
;
;*********************
GOTOLCD: LD   A,C
         CALL GOTO
         RET
;*********************
WBYTELCD:  LD    D,C
           CALL  WRBYTE
           RET
;*********************
LCDSTG:     POP   HL
LCDSTG1:    LD    C,(HL)
            INC   HL
            XOR   A
            CP    C
            JP    Z,LCDSTG2
            CALL  WBYTELCD
            JP    LCDSTG1
LCDSTG2:    PUSH  HL
            RET
;*********************
DSPCLCD:    LD    A,C
            CALL  ASCHEX
            PUSH  DE
            LD    C,D
            CALL  WBYTELCD
            POP   DE
            LD    C,E
            CALL  WBYTELCD
            RET
;*********************
DSPDELCD:   LD    C,D
            PUSH  DE
            CALL  DSPCLCD
            POP   DE
            LD    C,E
            CALL  DSPCLCD
            RET
;
;***********************
;  BINARY ACC TO ASCII *
;***********************
;input   = A
;output  = DE (ascii)
;reg     = ADE
;
ASCHEX:  PUSH AF
         RRCA
         RRCA
         RRCA
         RRCA
         CALL ASCH1
         LD   D,A
         POP  AF
;
ASCH1:   AND  0FH
         ADD  A,90H
         DAA
         ADC  A,40H
         DAA
         LD   E,A
         RET
;
KEYIN:   PUSH HL
         CALL SCAN
         CALL SOUND
         POP  HL
;
         CP   02H
         JP   Z,KEY0
         CP   0EH
         JP   Z,KEY1
         CP   0DH
         JP   Z,KEY2
         CP   0CH
         JP   Z,KEY3
         CP   0AH
         JP   Z,KEY_4
         CP   09H
         JP   Z,KEY5
         CP   08H
         JP   Z,KEY6
         CP   06H
         JP   Z,KEY7
         CP   05H
         JP   Z,KEY8
         CP   04H
         JP   Z,KEY9
         JP   KEYIN
;
KEY0:    LD   A,30H
         LD   (HL),A
         INC   HL
         RET
KEY1:    LD   A,31H
         LD   (HL),A
         INC   HL
         RET
KEY2:    LD   A,32H
         LD   (HL),A
         INC   HL
         RET
KEY3:    LD   A,33H
         LD   (HL),A
         INC   HL
         RET
KEY_4:   LD   A,34H
         LD   (HL),A
         INC   HL
         RET
KEY5:    LD   A,35H
         LD   (HL),A
         INC   HL
         RET
KEY6:    LD   A,36H
         LD   (HL),A
         INC   HL
         RET
KEY7:    LD   A,37H
         LD   (HL),A
         INC   HL
         RET
KEY8:    LD   A,38H
         LD   (HL),A
         INC   HL
         RET
KEY9:    LD   A,39H
         LD   (HL),A
         INC   HL
         RET
;

;************************
;                       *ABCDEHL
;    SCAN SUBROUTINE    *B'H'L'
;                       *STOREX
;************************
;
         .EQU   PD,42H     ;IN 4 BIT ,OUT 4 BIT KEYBOARD
;
SCAN:    LD   B,4
         LD   C,B
         LD   E,11111110B
;
SCAN_1:  CALL SCANS
         LD   HL,SYSFAG
         IN   A,(PD)
         AND  0F0H
         CP   0F0H
         JP   NZ,SCAN_3
;
         DEC  C
         JP   NZ,SCAN_2
         RES  0,(HL)
SCAN_2:
         RLC  E
         DEC  B
         JP   NZ,SCAN_1
;
         CALL WDT
         JP   SCAN
;
; press key
;
SCAN_3:  BIT  0,(HL)
         JP   NZ,SCAN_2
         OR   B
         PUSH HL
         PUSH BC
         LD   HL,KEYTAB+15
         LD   B,15
         CALL PACKT1
         POP  BC
         POP  HL
         LD   D,A
         LD   (SCANIN),A
         SET  0,(HL)
;
         RET
;
KEYTAB:  .DB   0E1H,0E2H,0E3H,0E4H
         .DB   0D1H,0D2H,0D3H,0D4H
         .DB   0B1H,0B2H,0B3H,0B4H
         .DB   71H,72H,73H,74H

;************************
;                       *
;   SCAND SUBROUTINE    *
;                       *
;************************
;
SCANK:   LD   B,4
         LD   C,B
         LD   E,11111110B
;
SCANK1:  CALL SCANS
         LD   HL,SYSFAG
         IN   A,(PD)
         AND  0F0H
         CP   0F0H
         JP   NZ,SCANK3
;
         DEC  C
         JP   NZ,SCANK2
         RES  0,(HL)
SCANK2:  CALL WDT
         RLC  E
         DEC  B
         JP   NZ,SCANK1
;
         RET
;
SCANK3:  OR   B
         PUSH HL
         PUSH BC
         LD   HL,KEYTAB+15
         LD   B,15
         CALL PACKT1
         POP  BC
         POP  HL
         LD   D,A
         LD   (SCANIN),A
         RET                 ;exit
;
SCANS:   LD   A,E
         OUT  (PD),A
         XOR  A              ;DELAY
SCANS1:  NOP
         NOP
         DEC  A
         JP  NZ,SCANS1
         CALL WDT
         RET
;
PACKT1:  CP   (HL)
         JP   Z,PACKT12
         DEC  HL
         DEC  B
         JP   NZ,PACKT1
PACKT12: LD   A,B
         RET
;
;**************************
;
SOUND:   PUSH AF
         LD   HL,FEG     ;FEG SOUND
         OUT0 (14H),L
         OUT0 (15H),H
         OUT0 (16H),L
         OUT0 (17H),H
         LD   A,06H
         OUT0 (10H),A
         LD   A,80H
         OUT  (PORTB),A
         CALL DELAYS
         LD   A,00H
         OUT  (PORTB),A
         IN0  A,(10H)
         AND  0FBH
         OUT0 (10H),A
         POP  AF
         RET
;
SOUNDX:  PUSH AF
         LD   HL,FEGX     ;FEG SOUND
         OUT0 (14H),L
         OUT0 (15H),H
         OUT0 (16H),L
         OUT0 (17H),H
         LD   A,06H
         OUT0 (10H),A
         LD   A,80H
         OUT  (PORTB),A
         CALL DELAYS
         LD   A,00H
         OUT  (PORTB),A
         IN0  A,(10H)
         AND  0FBH
         OUT0 (10H),A
         POP  AF
         RET
;
;
DELAYS:  PUSH HL
         LD   HL,TSOUND
DELAYS1: CALL WDT
         DEC  HL
         LD   A,L
         OR   H
         JP   NZ,DELAYS1
         POP  HL
         RET
;
;*********************
; SUB  IN 4
; INPUT    C =GOTO DISPLAY
; OUTPUT   KEY4 = 4 BYTE
;          DE   = 2 BYTE
; - KEY 4*3 -
;
IN4:     LD  A,0
         LD  (SAVEA),A
         LD  (KEY4+0),A      ;CLEAR BUF
         LD  (KEY4+1),A
         LD  (KEY4+2),A
         LD  A,C
         LD  (LCDPOS),A         ;SAVE C
         CALL GOTOLCD
;
IN4R:    CALL SCAN
         CALL SOUND
         LD  (SCANIN),A

         LD  A,(SAVEA)
         CP  3
         JP  Z,KEY4DIG

         LD   A,(SCANIN)
         CP   01H        ;KEY A KEYCODE=01H
         JP   Z,IN4R
         CP   00H        ;KEY B KEYCODE=00H
         JP   Z,IN4R
;
         LD  A,(SCANIN)
         LD  B,0         ;CONVER KEY POSITION 0-9 TO BCD 0-9
         LD  HL,TABKEY
IN421:   LD  D,(HL)
         CP  D
         JP  Z,IN43
         INC B
         INC HL
         JP  IN421
;
IN43:    LD  A,B        ;KEY
         LD  (KEYBUF),A ;0-9

         LD  A,(SAVEA)
         CP  3
         JP  NZ,IN44
;
KEY4DIG: LD  A,(SCANIN)
         CP  01H
         JP  Z,KEYA
         CP  00H
         JP  Z,KEYB
         JP  NOTAB
;
KEYA:    LD  C,'A'
         CALL WBYTELCD
         LD  C,' '
         CALL WBYTELCD
         LD  C,' '
         CALL WBYTELCD
         LD   A,'A'
         LD   (KEYAB),A
         RET
;
KEYB:    LD  C,'B'
         CALL WBYTELCD
         LD  C,' '
         CALL WBYTELCD
         LD  C,' '
         CALL WBYTELCD
         LD   A,'B'
         LD   (KEYAB),A
         RET

NOTAB:   LD  A,(SCANIN)
         LD  B,0         ;CONVER KEY POSITION 0-9 TO BCD 0-9
         LD  HL,TABKEY
NOTAB1:  LD  D,(HL)
         CP  D
         JP  Z,NOTAB2
         INC B
         INC HL
         JP  NOTAB1
;
NOTAB2:  LD  A,B        ;KEY
         LD  (KEYBUF),A ;0-9

         LD  A,(SAVEA)
         LD  BC,0
         LD  HL,KEY4
         LD  C,A
         ADD  HL,BC
         LD  A,(KEYBUF)
         LD  (HL),A
;
         LD  A,(LCDPOS)
         LD  C,A
         LD  A,(SAVEA)
         ADD A,C
         LD  C,A
         CALL GOTOLCD
         LD  A,(SAVEA)     ;INC LCDPOSITION +
         INC A
         LD  (SAVEA),A
         LD  A,(KEYBUF)
         ADD A,30H
         LD  C,A
         CALL WBYTELCD
         LD  C,' '
         CALL WBYTELCD
         LD  C,' '
         CALL WBYTELCD
         LD   A,(KEYBUF)
         ADD  A,30H
         LD   (KEYAB),A
         RET
;
         LD  A,(LCDPOS)
         LD  C,A
         CALL GOTOLCD
         CALL LCDSTG
         .DB  "    ",00
         LD  A,0          ;CLEAR LCD POSITION +
         LD  (SAVEA),A
         LD  A,(LCDPOS)
         LD  C,A
         CALL GOTOLCD
         LD  A,0
         LD  HL,KEY4
         LD  (HL),A   ;0   ;CLEAR KEY4 1-4
         INC HL
         LD  (HL),A   ;1
         INC HL
         LD  (HL),A   ;2
         JP  IN4R
;
IN44:    LD  A,(SAVEA)
         LD  BC,0
         LD  HL,KEY4
         LD  C,A
         ADD  HL,BC
         LD  A,(KEYBUF)
         LD  (HL),A
;
         LD  A,(LCDPOS)
         LD  C,A
         LD  A,(SAVEA)
         ADD A,C
         LD  C,A
         CALL GOTOLCD
         LD  A,(SAVEA)     ;INC LCDPOSITION +
         INC A
         LD  (SAVEA),A
         LD  A,(KEYBUF)
         ADD A,30H
         LD  C,A
         CALL WBYTELCD
         JP  IN4R
;
IN42:    LD  A,(SAVEA)
         CP  0
         JP  Z,IN4R
         DEC A
         LD  (SAVEA),A
         LD  C,A
         LD  A,(LCDPOS)
         ADD A,C
         LD  C,A
         CALL GOTOLCD
;
         LD  A,(SAVEA)
         LD  BC,0
         LD  HL,KEY4
         LD  C,A
         ADD HL,BC
         LD  A,0
         LD  (HL),A
;
         LD  C,' '
         CALL WBYTELCD
         LD  A,(SAVEA)
         LD  C,A
         LD  A,(LCDPOS)
         ADD A,C
         LD  C,A
         CALL GOTOLCD
;
         JP  IN4R
;
IN41:
         RET
;
TABKEY:  .DB  02H,0EH,0DH,0CH,0AH    ;0 1 2 3 4
         .DB  09H,08H,06H,05H,04H    ;5 6 7 8 9
;
;
;***********************
;   ASCII TO HEX IN DE *
;***********************
;input   (HL)
;output  DE,flag carry
;reg     ADEHL
;
ATOH2:   PUSH BC
         LD   B,4            ;set 2 byte
         JR   ATOHX
;
ATOH1:   PUSH BC             ;set 1 byte
         LD   B,2
ATOHX:    LD   DE,0           ;clear result
ATOHD:   LD   A,(HL)         ;get data
         CALL HEX
         JR   C,ATOHE        ;Yes,no hex
         EX   DE,HL          ;Save hl for rotate
         ADD  HL,HL
         ADD  HL,HL
         ADD  HL,HL
         ADD  HL,HL
         OR   L
         LD   L,A
         EX   DE,HL          ;Binary to de
         INC  HL             ;Next ascii
         DJNZ ATOHD          ;Ascii 4 byte ?
         OR   A              ;Clear carry flag
ATOHE:   POP  BC
         RET
;
;******************************
;* SUB SYSTEM FOR SYSTEM CALL *
;******************************

; ** check hex 0-F **
; A (hex low nibble),flag c=1 (error)
; reg     A

HEX:     CP   '0'
         JP   C,ERRHEX
         CP   '9'+1
         JP   C,HEX0
         CP   'A'
         JP   C,ERRHEX
         CP   'F'+1
         JP   NC,ERRHEX
         SUB  7
HEX0:    SUB  '0'
         OR   A
         RET
;
ERRHEX:
         RET


;***********************
;      HEX TO ASCII    *
;***********************
;  input   C
;  output  DE
;  reg     ACDE
;
HTOA:    LD   A,C
         PUSH AF
         RRCA
         RRCA
         RRCA
         RRCA
         CALL HTOA1
         LD   D,A
         POP  AF
;
HTOA1:   AND  0FH
         ADD  A,90H
         DAA
         ADC  A,40H
         DAA
         LD   E,A
         RET
;
;******** SUB OUT WDT *******
;
WDT:     OUT    (PWDT),A
         NOP
         OUT    (PWDT),A
         RET
;
;******** CLEAR RX BUFFER *****
;
CLSRXBUF: XOR   A
          LD    HL,DATA0
          LD    (HL),A
          LD    DE,DATA0+1
          LD    BC,100*NUMDATA0
          LDIR
          RET
;
ETT:      .DB  "ETT CO.,LTD. COPYLIGHT  1992 HGL.ASM"

         .ORG   8000H

DATA0:    .RS   100*NUMDATA0            ; NUMBER DATA 0
;
NUMRX0:   .RS   10
;
KEYINBUF: .RS   3
KEYAB:    .RS   1
;
SYSFAG:   .RS   1
SCANIN:   .RS   1
KEYBUF:   .RS   1
LCDPOS:   .RS   1
SAVEA:    .RS   1


KEY4:     .RS   5
COUNT:    .RS   2
COUNBYTE: .RS   1
COUNX:    .RS   1
ADDRBUF:  .RS   2
SHOCOUN:  .RS   1

         .END
