;***************************
;     ET-DEBUGGER AT180    *
;     PROGRAM START        *
;     ASM   Z180ASM        *
;     ETT CO.,LTD.         *
;***************************
;
        .EQU  ORIGIN,0000H
        .ORG  ORIGIN
;
;*** ASCI ***
        .EQU   FR1,0DBH
        .EQU   FR2,0B0H
        .EQU   CNTLA0,0
        .EQU   CNTLA1,1
        .EQU   CNTLB0,2
        .EQU   CNTLB1,3
        .EQU   STAT0,4
        .EQU   STAT1,5
        .EQU   TDR0,6
        .EQU   TDR1,7
        .EQU   RDR0,8
        .EQU   RDR1,9
;
;*** CSI/O ***

        .EQU   CNTR,0AH
        .EQU   TRDR,0BH
;
;*** TIMER ***

        .EQU   TMDR0L,0CH
        .EQU   TMDR0H,0DH
        .EQU   RLDR0L,0EH
        .EQU   RLDR0H,0FH
        .EQU   TCR,10H
        .EQU   TMDR1L,14H
        .EQU   TMDR1H,15H
        .EQU   RLDR1L,16H
        .EQU   RLDR1H,17H
;
;*** OTHER ***

        .EQU   FRC,18H
;
;*** DMA ***

        .EQU   SAR0L,20H
        .EQU   SAR0H,21H
        .EQU   SAR0B,22H
        .EQU   DAR0L,23H
        .EQU   DAR0H,24H
        .EQU   DAR0B,25H
        .EQU   BCR0L,26H
        .EQU   BCR0H,27H
        .EQU   MAR1L,28H
        .EQU   MAR1H,29H
        .EQU   MAR1B,2AH
        .EQU   IAR1L,2BH
        .EQU   IAR1H,2CH
        .EQU   BCR1L,2EH
        .EQU   BCR1H,2FH
        .EQU   DSTAT,30H
        .EQU   DMODE,31H
        .EQU   DCNTL,32H
;
;*** INT ***

        .EQU   IL,33H
        .EQU   ITC,34H
;
;*** REFRESH ***

        .EQU   RCR,36H
;
;*** MMU ***

        .EQU   CBR,38H
        .EQU   BBR,39H
        .EQU   CBAR,3AH
;
;*** I/O ***

        .EQU   OMCR,3EH
        .EQU   ICR,3FH
;
;       END    I/O MAP REG 80180
 
        .EQU   TRUN,93H
        .EQU   MONS,3FFFH
        .EQU   RSTN,0CFH
        .EQU   CODE,0A3H
        .EQU   USRAM,8000H
        .EQU   LF,0AH            ;line feed
        .EQU   CR,0DH            ;Cairrer return
        .EQU   BS,08H            ;back space
        .EQU   BEL,07H            ;bell
        .EQU   EOF,1AH            ;End of file
        .EQU   ESC,1BH
        .EQU   CNTLX,18H
        .EQU   CONS,13H
        .EQU   PRMT,3EH
        .EQU   SPACE,20H
        .EQU   BLANK,20H
        .EQU   DECADR,2DH
        .EQU   CNTL,0CH      ;PAGE UP
        .EQU   TROM,96H
        .EQU   BBAUD,0EFFEH
        .EQU   AUTOP1,0F1H
;
        .EQU   MAX8,9000H
        .EQU   MAX32,0F000H
        .EQU   RAM4,0E000H
;
;***********************
;    POWER UP DELAY    *
;***********************
;
START:   XOR  A              ;Delay
START1:  DEC  A
         NOP
         JR   NZ,START1
         JP   INIT
;
;***********************
;   RESTART 08H BREAK  *
;***********************
;
         JP   BREAK
         NOP
         NOP
         NOP
         NOP
         NOP
;
;***********************
;  RESTART 10H SYSCAL  *
;***********************
;
        CP    80H
        RET   C            ;IF A<80H
        CP    0FFH
        RET   NC           ;IF A=>0FF
        JR    MSYSCAL
;
;***********************
; RESTART 18H REG MODE *
;***********************
;
        JP    BREAKR
        NOP
        NOP
        NOP
        NOP
        NOP
;
;***********************
;       RESTART 20H    *
;***********************
;
         PUSH HL
         LD   HL,(RST20H)
         JP   TRST
         NOP
;
;***********************
;       RESTART 28H    *
;***********************
;
         .DB  0H,90H
         NOP
         NOP
         NOP
         NOP
         NOP
         NOP

;         PUSH HL
;         LD   HL,(RST28H)
;         JP   TRST
;         NOP
;
;***********************
;       RESTART 30H    *
;***********************
;
         PUSH HL
         LD   HL,(RST30H)
         JP   TRST
         NOP
;
;***********************
;       INT   38H      *
;***********************
;
         PUSH HL
         LD   HL,(RST38H)
         JP   INT0
         NOP
;
         .ORG  40H
;
;*** Vecter interrup system ***
;______________________________

;***********************
;       VECTOR INT     *
;***********************
;
IVEC:     .DRW IJR1
          .DRW IJR2
          .DRW IJR3
          .DRW IJR4
          .DRW IJR5
          .DRW IJR6
          .DRW IJR7
          .DRW IJR8
          .DRW IJR9       ;ASCI1
IVECE:
;____________________________
;
           .ORG 66H
;
;***********************
;        NMI 66H       *
;***********************
;
         PUSH HL
         LD   HL,(RST66H)
         JP   TRST
         NOP
         NOP
         NOP
;
          .ORG  70H
;
;*** Vecter interrup system ***
;          for user
;____________________________

IJR1:    JR    INT1
IJR2:    JR    INT2
IJR3:    JR    PRT0
IJR4:    JR    PRT1
IJR5:    JR    DMA0
IJR6:    JR    DMA1
IJR7:    JR    CSIO
IJR8:    JR    ASCI0
IJR9:    JR    SER1
;____________________________

;***********************
;      SYSTEM CALL     *
;***********************
;
MSYSCAL:  PUSH HL
         PUSH AF
         PUSH BC
         SUB  80H
         LD   B,A
         LD   C,2
         LD   HL,CALTAB
         CALL TABLE
         LD   C,(HL)
         INC  HL
         LD   B,(HL)
         PUSH BC
         POP  HL
         POP  BC
         POP  AF
         EX   (SP),HL
         RET

;
;
;***********************
;      INTERRUPT 1     *
;***********************
;
INT1:   DI
        PUSH HL
        PUSH DE
        LD   HL,(BUFINT)
        LD   E,0
        LD   D,0FDH          ;BIT 1
        JP   TINT

;
;***********************
;     INTERRUPT 2      *
;***********************
;
INT2:   DI
        PUSH HL
        PUSH DE
        LD   HL,(BUFINT+2)
        LD   E,1
        LD   D,0FBH          ;BIT 2
        JP   TINT
;
;***********************
;    TIMER CHANEL 0    *
;***********************
;
PRT0:   DI
        PUSH HL
        PUSH DE
        LD   HL,(BUFINT+4)
        LD   E,2             ;Table name & I/O
        LD   D,0EFH          ;BIT 6 MASK
        JP   TINT
;
;***********************
;    TIMER CHANEL 1    *
;***********************
;
PRT1:   DI
        PUSH HL
        PUSH DE
        LD   HL,(BUFINT+6)
        LD   E,3             ;Table name & I/O
        LD   D,0DFH          ;BIT 7 MASK
        JP   TINT
;
;***********************
;     DMA CHANEL 0     *
;***********************
;
DMA0:   DI
        PUSH HL
        PUSH DE
        LD   HL,(BUFINT+8)
        LD   E,4
        LD   D,0FBH          ;BIT 2
        JP   TINT
;
;***********************
;     DMA CHANEL 1     *
;***********************
;
DMA1:   DI
        PUSH HL
        PUSH DE
        LD   HL,(BUFINT+10)
        LD   E,5
        LD   D,0F7H          ;BIT 3
        JP   TINT
;
;***********************
;     CLOCK SERIAL     *
;***********************
;
CSIO:   DI
        PUSH HL
        PUSH DE
        LD   HL,(BUFINT+12)
        LD   E,6
        LD   D,0BFH          ;BIT 6
        JP   TINT
;
;***********************
;     ASCI CHANEL 0    *
;***********************
;
ASCI0:  DI
        PUSH HL
        PUSH DE
        LD   HL,(BUFINT+14)
        LD   E,7
        LD   D,0F6H          ;BIT 3,0
        JP   TINT
;
SER1:   JP   COMIN

;***********************
;      INTERRUPT 0     *
;***********************
;
INT0:   PUSH DE
        LD   E,8
        LD   D,0FEH          ;BIT 0
        JP   TINT

;***********************
;    INITIAL SYSTEM    *
;***********************
;
INIT:    LD   HL,0A000H       ;DELAY
INIT1:   DEC  HL
         LD   A,H
         OR   L
         JR   NZ,INIT1
;
         LD   BC,PCCSYS        ;INIT PRINTER
         LD   A,CONTSYS
         OUT  (C),A
         LD   A,0FFH
         DEC  BC
         DEC  BC
         DEC  BC
         OUT  (C),A          ;A
;
;*** CHECK TRAP/INT ***
;
         IN0  A,(ITC)
         LD   E,A
         BIT  7,A
         JR   Z,INIT2
         RES  7,A
         OUT0 (ITC),A
         POP  HL             ;Address error
         RL   E
         RL   E
         LD   A,0
         ADC  A,1
         LD   E,A
         LD   D,0
         OR   A
         SBC  HL,DE
         EX   DE,HL
         LD   B,L
         CALL CRLFD
         CALL MSGPRT
         .DB  "TRAP/INT ADDRESS  ",BEL,0
         CALL TXDE
         CALL MSGPRT
         .DB  "FROM OP-CODE ",0
         LD    A,B
         INC   A
         CALL TXACC
         CALL MSGPRT
         .DB  " BYTE",CR,LF,0
;
;*** GET MEMORY MAP ***

INIT2:   LD   A,0F8H         ;
         OUT0 (CBAR),A       ;MONITOR 0-7FFF NOT REMOVE
         LD   A,8H
         OUT0 (BBR),A        ;BANK 18000H CAN REMOVE
         OUT0 (CBR),A        ;STACK 1F000H NOT REMOVE
         LD   SP,SYSTK       ;SYSTEM STACK
;
;*** SET INTERRUPT VECTOR ***

         LD   A,0
         LD   I,A            ;VECTOR HIGH
         LD   A,40H          ;VECTOR LOW
         OUT0 (IL),A
         IM   1              ;FOR INT0
         LD   A,8            ;int asci chanel 1
         OUT0 (STAT1),A
         LD   A,64H          ;TX,RX,8BIT,1STOP
         OUT0 (CNTLA1),A
         LD   A,21H          ;9600  AT X'TAL 18.432 MHz
         OUT0 (CNTLB1),A
;
;*** SET INITIAL INTERNAL I/O ***

         LD   A,40H
         OUT0 (OMCR),A       ;SAME Z80
         LD   A,83H
         OUT0 (RCR),A        ;ENABLE REFRESH
         IN0  A,(DCNTL)
         AND  9FH
         OUT0 (DCNTL),A      ;MEM 1 WIAT STATE
;
;*** CHECK AUTO RUN PAGE #1 ***

         IN0  A,(AUTOP1)
         BIT  1,A
         JP   NZ,INIT21

         LD   A,0
         OUT0 (BBR),A
         LD   A,(0EFFFH)
         CP   CODE
         JR   Z,INIT20

         CALL MSGPRT
         .DB  0CH,CR,LF,"AUTORUN ADDRESS 08000H ACTIVE",CR,LF
         .DB  "by jumper J3=ON but no have code run at 0EFFFH = A3",CR,LF,0
         JP   INIT21


INIT20:  CALL MSGPRT
         .DB  0CH,CR,LF,"AUTORUN ADDRESS 08000H ACTIVE",CR,LF
         .DB  "jumper J3 = ON cannot run",CR,LF
         .DB  "  ---  DEBUG AT-180 ---",CR,LF,0
         LD   A,(BBAUD)
         CALL FILBAUD
         OUT0 (CNTLB1),A
         LD   SP,STACK
         JP   8000H


;*** CHECK AUTO RUN ***

INIT21:  LD   BC,800H
INIT3:   LD   E,C
         LD   D,8
         MLT  DE
         OUT0 (BBR),E
;
         LD   A,(0EFFFH)
         CP   CODE
         JR   NZ,INIT30
         LD   A,C
         CP   0
         JR   NZ,INIT4
INIT30:  INC  C
         DJNZ INIT3          ;CHECK 8 PAGE
         JR   INIT5          ;NO AUTO RUN
;
INIT4:
         INC  C              ;YES AUTO RUN
         LD   E,C
         LD   A,0F8H
         OUT0 (CBAR),A
         LD   A,8H           ;STACK
         OUT0 (CBR),A

         LD   A,E
         CP   1
         JP   Z,INIT5        ;PAGE 1 NO CHECK LOOP
         LD   (BPAGE),A

         SUB  1
         LD   E,A
         LD   D,8
         MLT  DE
INT40:   OUT0 (BBR),E
         LD   A,64H
         OUT0 (CNTLA1),A
         LD   A,(BBAUD)
         CALL FILBAUD
         OUT0 (CNTLB1),A
         LD   DE,INIT31      ;DELAY 3 SEC
         CALL CLOCK
         LD   E,0
         LD   A,TRUN
         LD   (ERUN),A
         EI
INIT41:  LD   A,E         ;AUTO RUN OK
         CP   3
         JR   NZ,INIT41
         NOP
         LD   SP,STACK       ;FOR USER
         JP   8000H
;
; *** delay 3 sec ***

INIT31:  INC  E            ;for exit auto run
         LD   A,3
         CP   E
         EI
         RET  NZ
         CALL CLRINT
         EI
         RET

;*** SET SERIAL CHANEL 1 ***
;
INIT5:   LD   A,8H
         OUT0 (BBR),A
         CALL MSGPRT
         .DB  CR,LF,"Z180",CR,LF,0
;
;*** CHECK AUTO BAUD RATE ***
;
INIT6:   CALL CONIN        ;CHECK ENTER
         CP   0
         JR   Z,INIT6
         LD   C,0
;
         LD   B,21H        ;9600
         AND  7FH
         CP   0DH
         JP   Z,INIT7
;
         LD   B,20H        ;19200
         CP   72H
         JP   Z,INIT7
;
         LD   B,22H        ;4800
         CP   66H
         JR   Z,INIT7
;

         LD   A,64H
         OUT0 (CNTLA1),A
         LD   A,29H          ;SET BAUD RATE 2400
         OUT0 (CNTLB1),A
         LD   C,0
;
INIT65:  CALL CONIN
         CP   0
         JR   Z,INIT65
;
         LD   B,23H
         AND  7FH
         CP   43H
         JR   Z,INIT7
;
         LD   B,2AH          ;1200
         LD   C,1
         CP   66H
         JR   Z,INIT7

         LD   B,26H          ;300
         LD   C,0
;
INIT7:   LD   A,C
         OR   A
         JR   Z,INIT71
INIT70:  IN0  A,(STAT1)
         BIT  7,A
         JR   Z,INIT70
         IN0  A,(RDR1)

INIT71:  LD   A,64H          ;CHANEL 1 BAUD RATE COMPLETE
         OUT0 (CNTLA1),A
         OUT0 (CNTLB1),B
         LD   A,B            ;SAVE BAUD RATE
         LD   (BAUD),A
;
;*** DISPLAY TITLE ***

REBACK:  EI
         LD   A,CNTL
         CALL CONOUT
         CALL MSGPRT
         .DB   CR,LF,CR,LF
         .DB   FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1
         .DB   FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1
         .DB   FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1
         .DB   FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,CR,LF
         .DB   FR1,"                                       ",FR1,FR2,CR,LF
         .DB   FR1,"  ET-DEBUGGER AT180             V2.0   ",FR1,FR2,CR,LF
         .DB   FR1,"                                       ",FR1,FR2,CR,LF
         .DB   FR1,"  Copyright (C) 1992  By ETT CO.,LTD.  ",FR1,FR2,CR,LF
         .DB   FR1,"_______________________________________",FR1,FR2,CR,LF
         .DB   FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1
         .DB   FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1
         .DB   FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1
         .DB   FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR1,FR2,CR,LF
         .DB   "  ",FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2
         .DB   FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2
         .DB   FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2
         .DB   FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,FR2,CR,LF
;
;
         .DB  "--------   help manu key  ( ? )   --------",CR,LF,BEL,0
;
         LD   HL,0
         LD   (BASCI1),HL
         LD   A,(PWCODE)     ;check power code
         CP   CODE
         JP   Z,BACK
;
;*  MAIN PROGRAM ET-DEBUGGER AT180  *
;   ______________________________
;  |                              |
;  |    MAIN PROGRAM              |
;  |______________________________|
;
;***********************
;        RAM AREA      *
;***********************
;
         .ORG   0FE80H
NSTACK:  .RS    32
STACK:   .RS    32
SYSTK:
R_PC:     .RS    2
R_SP:     .RS    2
R_IX:     .RS    2
R_IY:     .RS    2
R_AF:     .RS    2
R_BC:     .RS    2
R_DE:     .RS    2
R_HL:     .RS    2
R_IFF:    .RS    1
LENGTH:   .RS    1
FINBUF:   .RS    9
CHNBUF:   .RS    9
BRKFLG:   .RS    1
BUFR:     .RS    3
BUFIN:    .RS    1
BRKBUF:   .RS    54
STEP1:    .RS    4
STEP2:    .RS    4
STPCNT:   .RS    2
STPSAVE:  .RS    2
NSTPCT:   .RS    2
GETADR:   .RS    2
DMPADR:   .RS    2
DMPEND:   .RS    2
;
CLSTK:    .RS    6           ;CALCULATE BUFFER
CLBUF:    .RS    6
;
SEABUF:   .RS    8           ;ASM & DASM BUF
SEAMEM:   .RS    2
SEAFND:   .RS    2
SEACNT:   .RS    1

ASMCOM:   .RS    8
ASMBUF:   .RS    3
ASMOPC:   .RS    4
ASMDAT:   .RS    2
ASMDATD:  .RS    1

MONINX:   .RS    1
MONDAT:   .RS    2

FILWRK:   .RS    6
CALNMC:   .RS    1
CALADR:   .RS    2
COMBUF:   .RS    80
BUFRET:   .RS    1
SYSFAG:   .RS    1
CHSUM:    .RS    1           ;FOR UP LOAD
RST66H:   .RS    2
RST20H:   .RS    2
RST28H:   .RS    2
RST30H:   .RS    2
RST38H:   .RS    2
BUFINT:   .RS    16
BCHAR:    .RS    1
COMB:     .RS    2
BAUD:     .RS    1
CKSUM:    .RS    1           ;CHECK SUM
BACKUP:   .RS    1           ;BACK UP
CSTEP:    .RS    1
ERUN:     .RS    1
BPAGE:    .RS    1
BCALL:    .RS    2
BTIME:    .RS    4
USCLK:    .RS    2
CBUF:     .RS    6
BASCI1:   .RS    2
PWCODE:   .RS    1
WORK_SIZ:
;
           .END
