;      **************************************
;      *   SOFTWARE FOR CP-AT180            *
;      *   EXAMPLE PROGRAM                  *
;      *   SYSCAL  CALL  WDT                *
;      **************************************
;
         .ORG  8000H
;
; I/O CONTROL REGISTER ADDRESS
; I/O LCD PORT
;
         .EQU PA,80H
         .EQU PB,81H
         .EQU PC,82H
         .EQU PCC,83H
;
         .EQU RXBYTE,81H
         .EQU TXBYTE,82H
         .EQU DSPC,83H
;
         .EQU TXSTG,85H
;
         .EQU BYTE,97H
;
         .EQU INITLCD,0A0H
         .EQU GOTOLCD,0A1H
         .EQU WBYTELCD,0A2H
         .EQU DSPCLCD,0A3H
         .EQU DSPDELCD,0A4H
         .EQU LCDSTG,0A5H
         .EQU CLSLCD,0A6H
;
         .EQU INTRTC,0A9H
         .EQU GETCK,0AAH
         .EQU SETCK,0ABH
;
         .EQU WDT,0ACH
;
         .EQU ICHNG,0ADH
;
         .EQU INTRTC42,0AEH
         .EQU GETCK42,0AFH
         .EQU SETCK42,0B0H
;
         .EQU SYSCAL,10H
;
TESTWDT: LD   A,TXSTG
         RST  SYSCAL
         .DB   "  TEST WATCH DOG TIMER ",0AH,0DH
         .DB   "         JUMPER JWD",0AH,0DH,00
         LD   B,20
TWDT:    PUSH BC
         LD   A,TXSTG
         RST  SYSCAL
         .DB   "=== NOW  TEST WATCH DOG ===",0AH,0DH,00
         CALL DELAY
         POP  BC
         DJNZ TWDT
         LD   A,TXSTG
         RST  SYSCAL
         .DB   "STOP PROGRAM CALL WATCH DOG SYSTEM RESET",0AH,0DH,00
         LD   A,80H
         RST  SYSCAL
;
DELAY:   LD   HL,1000H
DEL1:    DEC  HL
         LD   A,WDT
         RST  SYSCAL
         LD   A,L
         OR   H
         JP   NZ,DEL1
         RET
        .END
