;      **************************************
;      *   SOFTWARE FOR CP-AT180            *
;      *   EXAMPLE PROGRAM                  *
;      *   SYSCAL  CALL  RS232 & RTC        *
;      **************************************
;
         .ORG  8000H
;
; I/O CONTROL REGISTER ADDRESS
; I/O LCD PORT
;
         .EQU PA,80H
         .EQU PB,81H
         .EQU PC,82H
         .EQU PCC,83H
;
         .EQU RXBYTE,81H
         .EQU TXBYTE,82H
         .EQU DSPC,83H
;
         .EQU TXSTG,85H
;
         .EQU BYTE,97H
;
         .EQU INITLCD,0A0H
         .EQU GOTOLCD,0A1H
         .EQU WBYTELCD,0A2H
         .EQU DSPCLCD,0A3H
         .EQU DSPDELCD,0A4H
         .EQU LCDSTG,0A5H
         .EQU CLSLCD,0A6H
;
         .EQU INTRTC,0A9H
         .EQU GETCK,0AAH
         .EQU SETCK,0ABH
;
         .EQU WDT,0ACH
;
         .EQU ICHNG,0ADH
;
         .EQU INTRTC42,0AEH
         .EQU GETCK42,0AFH
         .EQU SETCK42,0B0H
;
         .EQU SYSCAL,10H
;
START:   LD   A,INTRTC42
         RST  SYSCAL
SETCLOCK:LD   A,TXSTG
         RST  SYSCAL
         .DB   "==== TEST RTC 6242 SET START  31/12/97 23:59:55 ====",0AH,0DH,00

         LD   D,55H          ;D=SEC
         LD   C,59H          ;C=MIN
         LD   B,23H          ;B=HOUR
         LD   L,31H
         LD   H,12H
         LD   E,97H
         LD   A,SETCK42
         RST  SYSCAL
;
READ:    LD   A,TXSTG
         RST  SYSCAL
         .DB   "--> ",00
         LD   A,GETCK42
         RST  SYSCAL

         PUSH HL
         LD   C,L
         LD   A,DSPC
         RST  SYSCAL
         LD   C,'/'
         LD   A,TXBYTE
         RST  SYSCAL
         POP  HL
         LD   C,H
         LD   A,DSPC
         RST  SYSCAL
         LD   C,'/'
         LD   A,TXBYTE
         RST  SYSCAL

         LD   A,GETCK42
         RST  SYSCAL
         LD   C,E
         LD   A,DSPC
         RST  SYSCAL
         LD   C,' '
         LD   A,TXBYTE
         RST  SYSCAL

         LD   A,GETCK42
         RST  SYSCAL
         PUSH DE
         PUSH BC
         LD   C,B
         LD   A,DSPC
         RST  SYSCAL
         LD   C,':'
         LD   A,TXBYTE
         RST  SYSCAL
         POP  BC
         LD   A,DSPC
         RST  SYSCAL
         LD   C,':'
         LD   A,TXBYTE
         RST  SYSCAL
         POP  DE
         LD   C,D
         LD   A,DSPC
         RST  SYSCAL
         LD   A,TXSTG
         RST  SYSCAL
         .DB   0AH,0DH,00
;
READ1:   LD   A,GETCK42
         RST  SYSCAL
         LD   A,D
READ2:   EX   AF,AF'
         LD   B,0
READ3:   DJNZ READ3
         LD   A,GETCK42
         RST  SYSCAL
         EX   AF,AF'
         CP   D
         JP   Z,READ2
;
         JP   READ
;
         .END
























































































































































         END

        END





