;      **************************************
;      *   SOFTWARE FOR CP-AT180            *
;      *   EXAMPLE PROGRAM                  *
;      *   TEST  Z80CTC   CH1 INT  RST 38H  *
;      **************************************
;
         .ORG  8000H
;
; I/O CONTROL REGISTER ADDRESS
; I/O LCD PORT
;
         .EQU PA,80H
         .EQU PB,81H
         .EQU PC,82H
         .EQU PCC,83H
;
         .EQU RXBYTE,81H
         .EQU TXBYTE,82H
         .EQU DSPC,83H
;
         .EQU TXSTG,85H
;
         .EQU BYTE,97H
;
         .EQU INITLCD,0A0H
         .EQU GOTOLCD,0A1H
         .EQU WBYTELCD,0A2H
         .EQU DSPCLCD,0A3H
         .EQU DSPDELCD,0A4H
         .EQU LCDSTG,0A5H
         .EQU CLSLCD,0A6H
;
         .EQU INTRTC,0A9H
         .EQU GETCK,0AAH
         .EQU SETCK,0ABH
;
         .EQU WDT,0ACH
;
         .EQU ICHNG,0ADH
;
         .EQU INTRTC42,0AEH
         .EQU GETCK42,0AFH
         .EQU SETCK42,0B0H
;
         .EQU SYSCAL,10H
;
         .EQU CONCTC0,80H
         .EQU CONCTC1,81H
         .EQU CONCTC2,82H
         .EQU CONCTC3,83H
;

         .EQU INT38,0FFC5H
;


START:     LD  A,TXSTG
           RST 10H
           .DB  "TEST Z80 CTC INT & SYSTEMS HALT ",0AH,0DH,00
           IM 1
           LD  HL,INT
           LD  (INT38),HL
           LD  A,0
           OUT (0F0H),A
           LD  A,0A7H
           OUT (CONCTC0),A       ;LOAD CONTROL
           LD  A,0FFH
           OUT (CONCTC0),A       ;LOAD TIMER CONSTANT
           LD  A,10H
           OUT (CONCTC0),A
           EI
;
START1:    NOP
           HALT
           NOP
           JP START1
;
INT:       DI
           LD  HL,0
LOOP:      DEC HL
           LD  A,L
           OR  H
           JP  NZ,LOOP
;
           IN  A,(0F0H)
           CP  20H
           JP  Z,INT1
           LD  A,20H
           OUT (0F0H),A
           JP  INT2
INT1:      LD  A,18H
           OUT (0F0H),A
INT2:      EI
           RETI

