;      **************************************
;      *   SOFTWARE FOR CP-AT180            *
;      *   EXAMPLE PROGRAM                  *
;      *   SYSCAL  CALL  TEST LCD           *
;      **************************************

         .ORG  8000H
;
; I/O CONTROL REGISTER ADDRESS
; I/O LCD PORT
;
         .EQU PA,80H
         .EQU PB,81H
         .EQU PC,82H
         .EQU PCC,83H
;
         .EQU RXBYTE,81H
         .EQU TXBYTE,82H
         .EQU DSPC,83H
;
         .EQU TXSTG,85H
;
         .EQU BYTE,97H
;
         .EQU INITLCD,0A0H
         .EQU GOTOLCD,0A1H
         .EQU WBYTELCD,0A2H
         .EQU DSPCLCD,0A3H
         .EQU DSPDELCD,0A4H
         .EQU LCDSTG,0A5H
         .EQU CLSLCD,0A6H
;
         .EQU INTRTC,0A9H
         .EQU GETCK,0AAH
         .EQU SETCK,0ABH
;
         .EQU WDT,0ACH
;
         .EQU ICHNG,0ADH
;
         .EQU INTRTC42,0AEH
         .EQU GETCK42,0AFH
         .EQU SETCK42,0B0H
;
         .EQU SYSCAL,10H
;

;
TLCD1:   LD   A,INITLCD
         RST  SYSCAL
         LD   A,LCDSTG
         RST  SYSCAL
         .DB   "TEST LCD",0
         LD   A,GOTOLCD
         LD   C,40H
         RST  SYSCAL
         LD   A,LCDSTG
         RST  SYSCAL
         .DB   " 16116H ",0
         CALL DELAYL
         LD   A,CLSLCD
         RST  SYSCAL
         LD   E,30H
         LD   D,50H

TLCD2:   PUSH DE
         LD   A,CLSLCD
         RST  SYSCAL
         LD   D,80H
TLCD21:  PUSH DE
         LD   A,WBYTELCD
         LD   C,E
         RST  SYSCAL
         POP  DE
         DEC  D
         JP   NZ,TLCD21
         LD   B,2
         CALL DELAYS
         POP  DE
         INC  E
         DEC  D
         JP   NZ,TLCD2
         JP   TLCD2
;
DELAYL:  LD   B,20
DELAYS:  LD   HL,0
DELAY1:  DEC  HL
         LD   A,L
         OR   H
         JP   NZ,DELAY1
         DJNZ DELAYS
         RET
;
         .END
























































































































































         END

        END





