;      **************************************
;      *   SOFTWARE FOR CP-AT180            *
;      *   EXAMPLE PROGRAM                  *
;      *   TEST DIPSW 4 & JUMPER  J3        *
;      **************************************
;
         .ORG  8000H
;
; I/O CONTROL REGISTER ADDRESS
; I/O LCD PORT
;
         .EQU PA,80H
         .EQU PB,81H
         .EQU PC,82H
         .EQU PCC,83H
;
         .EQU RXBYTE,81H
         .EQU TXBYTE,82H
         .EQU DSPC,83H
;
         .EQU TXSTG,85H
;
         .EQU BYTE,97H
;
         .EQU INITLCD,0A0H
         .EQU GOTOLCD,0A1H
         .EQU WBYTELCD,0A2H
         .EQU DSPCLCD,0A3H
         .EQU DSPDELCD,0A4H
         .EQU LCDSTG,0A5H
         .EQU CLSLCD,0A6H
;
         .EQU INTRTC,0A9H
         .EQU GETCK,0AAH
         .EQU SETCK,0ABH
;
         .EQU WDT,0ACH
;
         .EQU ICHNG,0ADH
;
         .EQU INTRTC42,0AEH
         .EQU GETCK42,0AFH
         .EQU SETCK42,0B0H
;
         .EQU SYSCAL,10H
;
         .EQU PBSYS,0F1H
         .EQU PCCSYS,80F3H
;

START:   LD   A,TXSTG
         RST  SYSCAL
         .DB   "==== TEST DIPSW 4 & JUMPER J3 ====",0AH,0DH,00
;
LOOP:    LD   A,TXSTG
         RST  SYSCAL
         .DB   "DIP SW = ",0
         LD   A,9BH
         LD   BC,PCCSYS
         OUT  (C),A
         LD   BC,PBSYS
         IN   A,(C)
         BIT  4,A
         CALL TESTBIT
         BIT  5,A
         CALL TESTBIT
         BIT  6,A
         CALL TESTBIT
         BIT  7,A
         CALL TESTBIT
         PUSH AF
         LD   A,TXSTG
         RST  SYSCAL
         .DB   "   J3 = ",0
         POP  AF
         BIT  1,A
         CALL TESTBIT
         LD   A,TXSTG
         RST  SYSCAL
         .DB   0AH,0DH,0
;
TEST1:   LD   BC,PBSYS
         IN   A,(C)
         AND  11110010B
TEST2:   EX   AF,AF'
         LD   B,0
TEST3:   NOP
         DJNZ TEST3
         LD   BC,PBSYS
         IN   A,(C)
         AND  11110010B
         LD   B,A
         EX   AF,AF'
         CP   B
         JP   Z,TEST2
;
         JP   LOOP

TESTBIT: PUSH AF
         JP   NZ,BIT1
         LD   A,TXSTG
         RST  SYSCAL
         .DB   " ON ",0
         JP   BIT11
BIT1:    LD   A,TXSTG
         RST  SYSCAL
         .DB   " OFF",0
BIT11:   POP  AF
         RET
         .END
























































































































































         END

        END





