;      **************************************
;      *   SOFTWARE FOR CP-AT180            *
;      *   EXAMPLE PROGRAM                  *
;      *   SYSCAL  CALL  RS232 & RTC        *
;      **************************************
;
         .ORG  8000H
;
; I/O CONTROL REGISTER ADDRESS
; I/O LCD PORT
;
         .EQU PA,80H
         .EQU PB,81H
         .EQU PC,82H
         .EQU PCC,83H
;
         .EQU RXBYTE,81H
         .EQU TXBYTE,82H
         .EQU DSPC,83H
;
         .EQU TXSTG,85H
;
         .EQU BYTE,97H
;
         .EQU INITLCD,0A0H
         .EQU GOTOLCD,0A1H
         .EQU WBYTELCD,0A2H
         .EQU DSPCLCD,0A3H
         .EQU DSPDELCD,0A4H
         .EQU LCDSTG,0A5H
         .EQU CLSLCD,0A6H
;
         .EQU INTRTC,0A9H
         .EQU GETCK,0AAH
         .EQU SETCK,0ABH
;
         .EQU WDT,0ACH
;
         .EQU ICHNG,0ADH
;
         .EQU INTRTC42,0AEH
         .EQU GETCK42,0AFH
         .EQU SETCK42,0B0H
;
         .EQU SYSCAL,10H
;
START:   LD   A,INTRTC
         RST  SYSCAL
SETCLOCK:LD   A,TXSTG
         RST  SYSCAL
         .DB   "==== TEST RTC SET START 00:00:00 ====",0AH,0DH,00
         LD   D,0          ;D=SEC
         LD   BC,0         ;B=HOUR ,C=MIN
         LD   A,SETCK
         RST  SYSCAL
;
READ:    LD   A,TXSTG
         RST  SYSCAL
         .DB   "--> ",00
         LD   A,GETCK
         RST  SYSCAL
         PUSH DE
         PUSH BC
         LD   C,B
         LD   A,DSPC
         RST  SYSCAL
         LD   C,':'
         LD   A,TXBYTE
         RST  SYSCAL
         POP  BC
         LD   A,DSPC
         RST  SYSCAL
         LD   C,':'
         LD   A,TXBYTE
         RST  SYSCAL
         POP  DE
         LD   C,D
         LD   A,DSPC
         RST  SYSCAL
         LD   A,TXSTG
         RST  SYSCAL
         .DB   0AH,0DH,00
;
READ1:   LD   A,GETCK
         RST  SYSCAL
         LD   A,D
READ2:   EX   AF,AF'
         LD   B,0
READ3:   DJNZ READ3
         LD   A,GETCK
         RST  SYSCAL
         EX   AF,AF'
         CP   D
         JP   Z,READ2
;
         JP   READ

;
         .END
























































































































































         END

        END





