;      **************************************
;      *   SOFTWARE FOR CP-AT180            *
;      *   EXAMPLE PROGRAM                  *
;      *   SYSCAL  CALL  LCD16116H & RTC    *
;      **************************************
;
         .ORG  8000H
;
; I/O CONTROL REGISTER ADDRESS
; I/O LCD PORT
;
         .EQU PA,80H
         .EQU PB,81H
         .EQU PC,82H
         .EQU PCC,83H
;
         .EQU RXBYTE,81H
         .EQU TXBYTE,82H
         .EQU DSPC,83H
;
         .EQU TXSTG,85H
;
         .EQU BYTE,97H
;
         .EQU INITLCD,0A0H
         .EQU GOTOLCD,0A1H
         .EQU WBYTELCD,0A2H
         .EQU DSPCLCD,0A3H
         .EQU DSPDELCD,0A4H
         .EQU LCDSTG,0A5H
         .EQU CLSLCD,0A6H
;
         .EQU INTRTC,0A9H
         .EQU GETCK,0AAH
         .EQU SETCK,0ABH
;
         .EQU WDT,0ACH
;
         .EQU ICHNG,0ADH
;
         .EQU INTRTC42,0AEH
         .EQU GETCK42,0AFH
         .EQU SETCK42,0B0H
;
         .EQU SYSCAL,10H
;
START:   LD   A,INITLCD
         RST  SYSCAL
         LD   A,INTRTC
         RST  SYSCAL
S1:      LD   A,GETCK
         RST  SYSCAL
         PUSH DE
         PUSH BC
         LD   C,B
         LD   A,DSPCLCD
         RST  SYSCAL
         LD   C,':'
         LD   A,WBYTELCD
         RST  SYSCAL
         POP  BC
         LD   A,DSPCLCD
         RST  SYSCAL
         LD   C,':'
         LD   A,WBYTELCD
         RST  SYSCAL
         POP  DE
         LD   C,D
         LD   A,DSPCLCD
         RST  SYSCAL
         LD   C,':'
         LD   A,WBYTELCD
         RST  SYSCAL
         CALL DELAY
         LD   A,GOTOLCD
         LD   C,0
         RST  SYSCAL
         JP   S1
;
DELAY:   LD   HL,8000H
DEL1:    DEC  HL
         LD   A,L
         OR   H
         JP   NZ,DEL1
         RET
         .END
























































































































































         END

        END





