           ;***********************************
           ;* This example program is showed  *
           ;* how to control LCD module.      *
           ;***********************************
           ;
           ORG 2200H

COMMAND    EQU     0E0C0H    ; Read-Write Register
READBUSY   EQU     0E0C1H    ; Read BF(Busy Flag) and address
WRITEDATA  EQU     0E0C2H    ; Write character
READDATA   EQU     0E0E3H    ; Read Data from DD ram

START:     LCALL   INIT
STR2:      MOV     R0,#20
           MOV     DPTR,#TAB1
STR1:      MOVX    A,@DPTR
           LCALL   WRITE
           INC     DPTR
           DJNZ    R0,STR1
           MOV     A,#0C0H        ;New line
           MOV     DPTR,#COMMAND
           MOVX    @DPTR,A
           LCALL   WAITBF         ;Wait busy flag

           MOV     R0,#20
           MOV     DPTR,#TAB2
STR3:      MOVX    A,@DPTR
           LCALL   WRITE
           INC     DPTR
           DJNZ    R0,STR3
           SJMP    $          ; Dynamic stop

; *** Write ASCII to LCD ***

WRITE:     PUSH    DPL
           PUSH    DPH
           MOV     DPTR,#WRITEDATA
           MOVX    @DPTR,A
           LCALL   WAITBF     ;Wait LCD module ready
           POP     DPH
           POP     DPL
           RET

; *** Wait for ready
; *** by mean of check busy flag ***

WAITBF:    PUSH    DPL
           PUSH    DPH
           MOV     DPTR,#READBUSY
RDY1:      MOVX    A,@DPTR
           JB      ACC.7,RDY1     ;Busy Flag
           POP     DPH
           POP     DPL
           RET

INIT:      PUSH    DPL
           PUSH    DPH
           MOV     DPTR,#COMMAND
           MOV     A,#38H         ;8bit, 2 line, 5x7 dot
           MOVX    @DPTR,A
           LCALL   WAITBF
           MOV     A,#0FH
           MOVX    @DPTR,A
           LCALL   WAITBF
           MOV     A,#6           ;increment cursor
           MOVX    @DPTR,A
           LCALL   WAITBF
           MOV     A,#1           ;clear and home
           MOVX    @DPTR,A
           LCALL   WAITBF
           POP     DPH
           POP     DPL
           RET
TAB1:      DB  "    PC-SB31. &      "
TAB2:      DB  "ET-DEBUGGER-31 V1.0 "
           END
