;----------------------------------------------------------------
; RTCMON demonstration program
;
; This is a simple program that blinks the RTC31 LED
; Download this using RTCMON's HR command
;  -- notice that the origin is 2200h... this is required!

BLINKBIT      EQU       P3.4                ; visible output

;----------------------------------------------------------------
; Required program origin for use with RTCMON

              ORG       2200h


;----------------------------------------------------------------
; Set up some default values
; You can change these using DEBUG31 to see what happens to
;  the blink times

              MOV       R0,#50              ; ON time
              MOV       R1,#100             ; OFF time
              MOV       R2,#0FFh            ; ripple value


;----------------------------------------------------------------
; The main loop picks the count out of Internal RAM & spins on it

Blinker       EQU       $

;--- show something interesting on P1

              MOV       A,R2
              MOV       P1,A
              RL        A
              ANL       A,#0FEh
              JNZ       P1OK
              MOV       A,#0FFh             ; reset on zero
P1OK:         MOV       R2,A

;--- blink the LED

              MOV       A,R0                ; pick up ON time
              CLR       BLINKBIT
              CALL      Delay

              MOV       A,R1                ; pick off OFF time
              SETB      BLINKBIT
              CALL      Delay


              SJMP      Blinker

;----------------------------------------------------------------
; Delay for about 1 ms times the contents of A
; This depends on an 11.059 MHz crystal...
; 460 x 1.09 us is about 1 ms
; The ORG 2230 allow a little room at the end of the main loop
;  so a breakpoint on the SJMP doesn't collide with the start of
;  the Delay code...

              ORG       2230H

Delay:

              PUSH      B                   ; save bystander

              MOV       B,#0                ; 256 loops
inner1:       DJNZ      B,inner1            ; 2.17 us/loop

              MOV       B,#204              ; 256 loops
inner2:       DJNZ      B,inner2            ; 2.17 us/loop

              POP       B                   ; restore bystander

              DJNZ      ACC,delay           ; repeat ACC times

              RET

;----
; Required by assembler

              END
