' -----[ Title ]--------------------------------------------------------------
'
' File...... STAMPMSG.BAS
' Purpose... Scolling LCD message display
' Author.... Jon Williams
' Started... July 25, 1994
' Updated... August 23, 1994


' -----[ Program Description ]------------------------------------------------
'
' This program displays a scrolling message on a small LCD display.  This 
' program is a simpler Stamp version of Scott Edwards' Micro-Messenger pro-
' ject as presented in the September '94 issue of Popular Electronics.
'
' This version will not allow you to program the display locally.  Rather, a
' default message can be stored for automatic display.  Once a message is 
' downloaded it will not be lost as it is stored in the Stamps' EEPROM.  If 
' there is a message in memory, it can be overwritten by connecting a serial
' cable before powering up, then sending the Stamp a new message.
'
' How it works: On initialization the LCD is cleared (filled with spaces) and
' the DD (display data) RAM address is set to 0.  Since we want the message 
' to scroll onto the display, we place the first character at DD RAM address
' 16 (this is the first position off the display).  By shifting the display
' 16 times the message appears.  At the end of this loop, the first character
' of the message is at the left-most position of the LCD.  By shifting the 
' display nChars more times, the message is pushed off.  We then go into
' low power mode to save the battery and to rest a bit between messages.
'
' The companion program for downloading message strings is called 
' DLOADMSG.BAS.  It is written in QBasic.  If you modify either program, be
' sure there is enough EEPROM space for your message.  Assuming your LCD has
' 80 bytes of character memory and 16 are used as a leader pad, you can have
' a message of 64 characters.  If your LCD is wider, the message will have to
' be shorter.  You can use STMPSIZE.EXE to examine your EEPROM after any
' program modifications.  The program as written has 75 bytes available for
' a default or downloaded message.
'
' For additional information on Stamp/LCD interfacing see LCDDEMOS.ZIP in
' the Files section of the Parallax BBS.  STMPSIZE.EXE is also available on
' the BBS in STMPSIZ2.ZIP.  If you cannot locate these files, please contact
' me through CompuServe (73110,3272).
'
'
' Connections:
'
' LCD        (Function)         Stamp
' ---------------------         -----
' pin 1         Vss             gnd
' pin 2         Vdd             +5
' pin 3         Vo              gnd
' pin 4         RS              pin 4
' pin 5         R/W             gnd
' pin 6         E               pin 5
' pin 7         DB0             gnd
' pin 8         DB1             gnd
' pin 9         DB2             gnd
' pin 10        DB3             gnd
' pin 11        DB4             pin 0
' pin 12        DB5             pin 1
' pin 13        DB6             pin 2
' pin 14        DB7             pin 4
'
'
' Reprogram line: Connect Pin7 to Vcc (+5) with a 47K pullup.
'
' Serial input: Limit current into this pin with 22K series resistor.

				     
' -----[ Revision History ]---------------------------------------------------
'
' 07-25-94 : Version 1.0
' 08-23-94 : Version 1.1 - Autodetect of serial line connection

' -----[ Constants ]----------------------------------------------------------
'
SYMBOL  S_In    = 7                     ' Serial line input from PC
SYMBOL  PgmLin  = Pin7                  ' auto-detect line for new msg
SYMBOL  E       = 5                     ' LCD enable pin (1 = enabled)
SYMBOL  RS      = 4                     ' Register Select (0 = instruction)

SYMBOL  LCDwdth = 16                    ' width of LCD (in chars)
SYMBOL  Delay   = 175                   ' delay time between characters

SYMBOL  ClrLCD  = $01                   ' clear the LCD
SYMBOL  CrsrHm  = $02                   ' move cursor to home position
SYMBOL  DispLf  = $18                   ' shift displayed characters left


' -----[ Variables ]----------------------------------------------------------
'
SYMBOL  outp    = B0                    ' output workspace
SYMBOL  char    = B1                    ' char sent to LCD
SYMBOL  nChars  = B2                    ' number of chars in message
SYMBOL  index   = B3                    ' loop counter


' -----[ Initialization ]-----------------------------------------------------
'
Setup:  BSAVE                           ' save EEPROM image file
	EEPROM (16)                     ' length of message (0 if none)
	EEPROM ("THE BASIC STAMP!")     ' put default message here

Init:   Pins = %00000000                ' all outputs off
	Dirs = %00111111                ' define pin directions
	PAUSE 20                        ' let the LCD settle

' initialize the LCD (Hitatchi HD44780 controller) 
'
LCDini: Pins = %00000011                ' 8-bit mode
	PULSOUT E, 1
	PAUSE 5
	PULSOUT E, 1
	PULSOUT E, 1
	Pins = %00000010                ' 4-bit mode
	PULSOUT E, 1
	char = %00001100                ' display on, cursor off, blink off
	GOSUB WrLCD
	char = %00000110                ' inc cursor, no disp shift
	GOSUB WrLCD
	char = %00000001                ' clear LCD
	GOSUB WrLCD
	HIGH RS                         ' LCD to character mode


' -----[ Main Code ]----------------------------------------------------------
'
Start:  READ 0, nChars                  ' get message length from EEPROM
	IF nChars = 0 THEN GetMsg       ' if no message, wait for one from pc

ChkBtn: IF PgmLin = 1 THEN PutMsg       ' check for serial line connection
	
GetMsg: SERIN S_in, N2400, nChars       ' get display length
	WRITE 0, nChars                 ' save length to EEPROM
	FOR index = 1 TO nChars         ' get message chars
	  SERIN S_in, N2400, char
	  WRITE index, char             ' save the message in EEPROM
	NEXT index
	
PutMsg: char = %10000000 | LCDwdth      ' move to first position off display
	GOSUB LCDcmd
	
	FOR index = 1 TO nChars         ' write message to LCD
	  READ index, char
	  GOSUB WrLCD
	NEXT index

Show:   char = CrsrHm                   ' home (to show the leading blanks)
	GOSUB LCDcmd

	char = DispLf
	FOR index = 1 TO LCDwdth        ' reveal message
	  GOSUB LCDcmd
	  PAUSE Delay
	NEXT index
	
	FOR index = 1 TO nchars         ' push message off display
	  GOSUB LCDcmd
	  PAUSE Delay
	NEXT index

	Pins = %10000000		' all outputs off
	NAP 5
	GOTO Show                       ' repeat the process


' -----[ Subroutines ]--------------------------------------------------------
'
LCDcmd: LOW RS                          ' send command byte to LCD
	GOSUB WrLCD
	HIGH RS
	RETURN

WrLCD:  Pins = Pins & %00010000         ' E = high, data bus clear
	outp = char / 16                ' get high nibble
	Pins = Pins | outp              ' output the nibble
	PULSOUT E, 1                    ' strobe the Enable line
	Pins = Pins & %00010000
	outp = char & %00001111         ' get low nibble
	Pins = Pins | outp
	PULSOUT E, 1
	RETURN
