'
'  NODETEMP.BAS
'
'    This is a twist on the programs DIGITMPF and STMPTERM by Jon Williams.
'  Connect your stamp to the serial line on your pc, start up a terminal
'  program, send out the 'id' of the stamp hanging on the line, and 
'  finally the function letter representing what you want that controller
'  to do.  I haven't tried this with multiple controllers on the same line
'  yet, only have one right now, a situation soon to change.
'    I've avoided useing GOSUB's , they seem to soak up the stamp's memory.
'  



SYMBOL  co0     = 162                   ' thermister conversion constants
SYMBOL  co1top  = 255
SYMBOL  co1btm  = 2125
SYMBOL  co2bt1  = 25
SYMBOL  co2top  = 3
SYMBOL  co2btm  = 50
SYMBOL  degsym  = 223                   ' degrees symbol
SYMBOL  s_in    = 7                     ' serial input line
SYMBOL  s_out   = 6                     ' serial output line
SYMBOL  temp_in = 5                     ' thermistor connection pin

'
' variables
'
SYMBOL  char    = b0			                   
SYMBOL  index   = b1                    ' loop index
SYMBOL  temp    = w1                    ' temperature reading
SYMBOL  work1   = w2
SYMBOL  work2   = w3
SYMBOL  work3   = w4



MAIN: 
	'
	'---["stamp1" is the id of this controller]------------------------
	'
	serin s_in, n2400, ("stamp1"), char  
	if char = "A" then TEMP_FUNC
	if char = "B" then B_FUNC
	if char = "C" then C_FUNC
	goto ERROR


TEMP_FUNC:
	'
	'---[read the thermisistor]----------------------------------------
	'
	pot temp_in, 46, temp           ' read the thermistor
	work1 = temp * temp / co2bt1 * co2top / co2btm
	temp = temp * co1top / co1btm + temp
	temp = co0 + work1 - temp
	'
	'---[send text and the temperature converted to ASCII]-------------
	'
	serout s_out, n2400, (10,13,"T=")
	work1 = temp                    ' save temperature
	work2 = 100                     ' initial divisor
	for index = 1 to 3              ' show temp with 3 digits
	  char = work1 / work2 + 48     ' get digit; convert to ASCII
	  serout s_out, n2400, (char)
	  work1 = work1 // work2        ' get remainder
	  work2 = work2 / 10            ' get new divisor
	next index
	serout s_out, n2400, (degsym,"F",10,13)
	
	goto MAIN
'
'---[and your own goodies to the rest]------------------------------------
'

B_FUNC:
	serout s_out, n2400, (10,13,"B_FUNCTION",10,13)
	goto MAIN

C_FUNC: 
	serout s_out, n2400, (10,13,"C_FUNCTION",10,13)
	goto MAIN

ERROR:
	serout s_out, n2400, (10,13,"UNKNOWN COMMAND",10,13)
	goto MAIN





