'ANY COMMENTS by Phone or FAX to shorten this soft are very welcome.
'Many thanks for all help.


' ***********************************************************************
' * OS56 BETA RELEASE Not fully tested.                                 *
' * (c) Herve GALMICHE 12 rue des Arandes F-21000 DIJON FRANCE          *
' * Phone : + 33 80573579 or + 33 88679799 Fax: + 33 88679799 *         *
' * This is an small operating system in PBASIC for BASIC STAMP         *
' *                                                                     *
' * A serial T2400,8,N link may be done between two STAMPS chips.       *
' * This one "MASTER" is called like an OS by the "Slave" via the link  *
' ***********************************************************************

'BSAVE

' MASTER chip .

' Receive slave requests, acts then returns string.
' Both dialog serial 8N1 2400 on one bi-directional line RTX.

' Syntax: 
' Slave -> Master: Request_byte,Parameter_Byte,4 variables.
' Master acts following Request_byte and if needed Parameter_Byte.
' Master -> Slave: Return_byte,Parameter_Byte,4 variables.
' In all directions Parameter_Byte value depends on Request/Return and
' variables are treated depending on Request and Parameter Bytes...

' Bits Syntax of:

' Request_Byte:
  Between 0 and 5. Otherwise no treatment is done and Return_Byte=$FF.

' 00            Resets_Slave then returns same parameter and variables.
'               Return the same number of sended bytes.

' 01            Save Request_Byte Paramter and 4 variables sended.
'               Master resets. THEN RESET SLAVE !!! to bank 0
'               Master re-run recall its registers and send them back.

' 02            Save Slave registers (= 4 variables) to page 0..3 = Parameter.

' 03            Recall Slave registers (=4 variables)from page 0..3 = Parameter.

' 04            switch to bank precised by x (today 8 banks available)
'               onto Pins0,Pins1,Pins2 and also send Pins3,Pins4.
		Then reset_Slave and send back its pre-saved bytes.

' 05            return MASTER PARAMETERS:
		$05,release 1.0 ($10),CRC16 of Program_MASTER,
		0,0,Pins4..Pins0 of MASTER, EEPROM(255) of MASTER.


'Hardware Symbols:

SYMBOL  RTX          =  7
SYMBOL  Reset_Master =  6
SYMBOL  Reset_Slave  =  5

'Software Symbols:

' HERE WE GO

Dirs = %10111111        ' RTX inputs
			' Reset_Master off ,Reset_Slave on
			' Bank 0 for slave
Pins = %00000000        ' Reset pins ready to act as outputs.

DEBUG "RESTART"
HIGH Slave_Reset
LOW Slave_Reset

B7 = $10                ' Restore Master CPU registers.
Goto Restore0

Main:
Input RTX
SERIN RTX,T2400,B0,B1,B2,B3,B4,B5 ' Waits order
Low RTX
'debug #$B0,#$B1,#$B2,#$B3,#$B4,#$B5

B7 = B1 MAX 3
B7 = B7 * 4

Branch B0,(Res_Slave,Res_Master,Save,Recal,Change_Bank,Params)
B0=$FF
goto Send

Res_Slave:
' Debug "RS"
		HIGH Slave_Reset
		LOW  Slave_Reset
		Goto Send
Res_Master:
'Debug "RM"
		B7 = $10                ' Save parameters before reset
		Gosub Store0
		LOW  Master_Reset                  ' RESET MASTER
Save:
		Gosub Store1
		Goto Send
Change_Bank:
debug "bk",$b1
		B11 = B1 & %00011111
		Pins = %01100000 | B11
		LOW Slave_Reset
		Goto Send
Params:
'Debug "Param"
		READ 255,B5             ' Program beginning
		W1 = 0                  ' Clear CRC16
		For B1 = B5 to 255      ' Compute CRC16 for program zone
			READ B1,B4      ' for each byte value in B4
			W1 = W1 + B4    ' will be added to W1=CRC16.
		Next B1
		B4 = B11                ' Bank and Pins3,Pins4.
		B1 = $10                ' Program release 1.0
		Goto Send

Store0:         B8 = 6
		goto Store_Loop

Store1:         B8 = 4 
Store_Loop:     B8 = B8 - 1
		Lookup B8,(B5,B4,B3,B2,B1,B0),B9
		Write B7,B9
		B7 = B7 + 1
		Branch B8,(Exit)
		Goto Store_Loop
Exit:           Return

Restore0:       
		READ B7,B0
		B7 = B7 + 1
		READ B7,B1
		B7 = B7 + 1
Recal:
Restore1:       READ B7,B2
		B7 = B7 + 1
		READ B7,B3
		B7 = B7 + 1
		READ B7,B4
		B7 = B7 + 1
		READ B7,B5
		B7 = B7 + 1

Send:
	Input RTX
Slave_Busy::
	Branch Pin7,(Slave_Busy)
	Serout RTX,T2400,(B0,B1,B2,B3,B4,B5)
	Low RTX
'debug #$B0,#$B1,#$B2,#$B3,#$B4,#$B5
	goto main
