'electronic combination lock                              Jim Steinman
'                                                         Mar 11/95

'This program implements a combination lock that I used for a garage
'door opener. The stamp reads keypresses from a surplus telephone keypad 
'and checks that the correct key is pressed and not too much time expires 
'between subsequent keypresses. If a wrong number is entered, the user is
'penalized with a 10 second lockout, during which the keyboard is ignored.
'When the lockout time is up, you simply start over from the beginning.
'Wrong keys are counted and if more than three occur, then someone is 
'clearly trying to "break in" and a 10 minute lockout is initiated. The
'wrong key counter can only be cleared by entering the correct combination.
'Key debounce is taken care of inherently because the program waits for 
'each key to be released before scanning for another and the instruction
'execution time gives the right amount of delay.
'Comments are welcome



'keyboard wiring     stamp pin3 connects to row11 2 3
'                      "   pin4   "      "  row2-4 5 6
'                      "   pin5   "      "  row3-7 8 9
'                      "   pin0   "    " column1        
'                      "   pin1   "    " column2      
'                      "   pin2   "    " column3    
'columns 1,2,& 3 are also tied to ground with 10 k resistors
'star, zero, and pound keys are ignored                                  


'register usage                 pin usage
'w0 b0-keyboard read            pin0-keyboard column input     
'   b1-1st number               pin1-keyboard column input
'w1 b2-2nd number               pin2-keyboard column input
'   b3-3rd number               pin3-keyboard row output
'w2 b4-4th number               pin4-keyboard row output
'   b5-lookup result            pin5-keyboard row output
'w3 b6-main loop                pin6-output-led1-red-indicator
'   b7-wrong key counter        pin7-output-led2-grn-actuator
'w4 b8-expiry and lockout counter 
'   b9-  "     "             -once  everything is working, led1 can be
'w5 b10-scan loop             omitted (it is only there for diagnostics 
'   b11-spare                 and troubleshooting) and led2 can be
'w6 b12-stack                 replaced with a relay or something          
'   b13- "                    suitable to activate your equipment


'this is the combination-use your own here
b1=9      'number for 1st keypress   
b2=9      'number for 2nd keypress  
b3=9      'number for 3rd keypress 
b4=9      'number for 4th keypress 


init:  dirs=%11111000               'set up pins
       b7=0                         'zero wrong key counter

'----------main loop----------------------------------------------

start: for b6=0 to 3                'get each of the 4 key presses in turn
         w4=0                        'zero expire counter
looplo:  gosub scan                  'read keys
         if b0<>0 then looplo        'loop till no key is pressed-you must
                                     'release a key before pressing another
loophi:                              'loop till a key is pressed or till    
                                     'time is expired-unless in first pass
         if b6=0 then fetchkey       'in first pass so go ahead
         w4=w4 + 1                   'increment counter
         if w4>500 then start        'time is expired-exit and start over
                                     '500 counts is about 3 secs
fetchkey: gosub scan                  'read keys
          if b0=0 then loophi          'loop till key is pressed

          lookup b6,(b1,b2,b3,b4),b5   'check what key is pressed
          if b0<>b5 then lockout       'wrong key pressed so lockout

          pulsout 6,3000     'correct key pressed-flash led1-30 mS pulse 
       next b6               'get remaining key presses


                            'okay this is it-we've got the combination
      b7=0                  'clear the wrong key counter
      high 7                'turn on led2
      pause 500             '----activate your equipment here---
      low 7                 'turn off led2
      
      goto start     


'--------end of main loop-----------------------------------------

                                 'returns with 0 in b0 if no key is
scan: for b10=3 to 5             'pressed or the value of the key
      high b10                   'put each row high in turn 
      b0=pins & %00000111        'read columns and mask unused bits
      low b10       
      if b0>0 then gotkey        'a key has been pressed so jump ahead
      next b10
      return                     'no key was pressed so exit

gotkey:if b0<>4 then skip        'b0 will contain 1,2 or 4
       b0=3                      'change this to 1,2 or 3
skip:  b10=b10-3*3               'convert to numeric value of key
       b0=b0+b10
       return                    'return with value in b0


                                 '10 second lockout
lockout:b7=b7+1                  'increment wrong key counter
       if b7>3 then longlock     'only 3 wrong keys are allowed
       for w4=1 to 100            
       toggle 6                   'blink led1
       pause 100
       next w4
       goto start



longlock:for w4=1 to 6000         '10 minute lockout-too many wrong keys
         toggle 6                 'blink led1
         pause 100
         next w4
         goto start

