' -----[ Title ]-----------------------------------------------------------
'
' File....... LCD-1620.BAS
' Purpose.... Stamp-based digital thermometer 
' Author..... Jon Williams 
' Internet... jonwms@aol.com
' Started.... 4 April 1995
' Updated.... 5 April 1995


' -----[ Program Description ]---------------------------------------------
'
' This a Stamp-based digital thermometer using a Dallas DS1620 and 16-
' character LCD.
'
' Range: 0-125C, 32-255F
'
' NOTE: The Dallas DS1620 can measure negative temperatures but there is
'       note enough code space in this program to do the conversions.  See
'       my program DS1620EZ.BAS for conversion strategies.
'
' If you prefere output in Celsius, change the following:
' - change the TMode constant value to "C"
' - comment-out the ShowF line
' - remove fist comment marker from the ShowC line
'
' Connections:
' --------------------------------------
' Stamp.0 --> LCD.DB4, <-> DS1620.1 (DQ)  (shared by LCD and DS1620)
' Stamp.1 --> LCD.DB5
' Stamp.2 --> LCD.DB6
' Stamp.3 --> LCD.DB7
' Stamp.4 --> LCD.RS
' Stamp.5 --> LCD.E
' Stamp.6 --> DS1620.2 (CLK/CONV\)  
' Stamp.7 --> DS1620.3 (RST\)


' -----[ Revision History ]------------------------------------------------
'
' 5 April 1995 : Version 1 tested and working


' -----[ Constants ]-------------------------------------------------------
'

'  I/O pins
'
SYMBOL  RST     = 7                     ' DS1620 Reset input
SYMBOL  CLK     = 6                     ' DS1620 Clock input
SYMBOL  E       = 5                     ' LCD enable pin (1 = enabled)
SYMBOL  RS      = 4                     ' LCD Reg Select (0 = instruction)
SYMBOL  DQPin   = 0                     ' DS1620 data I/O
SYMBOL  DQ      = Pin0                  ' needs to match DQPin definition

SYMBOL  DegSym  = 223                   ' degrees symbol
SYMBOL  TMode   = "F"                   ' temperature mode

' DS1620 commands
'
SYMBOL  TEMPR   = $AA                   ' Read temperature
SYMBOL  THW     = $01                   ' Write TH (high temp register)
SYMBOL  TLW     = $02                   ' Write TL (low temp register)
SYMBOL  THR     = $A1                   ' Read TH
SYMBOL  TLR     = $A2                   ' Read TL
SYMBOL  START   = $EE                   ' Start temperature conversion
SYMBOL  STOP    = $22                   ' Stop temperature conversion
SYMBOL  CFGW    = $0C                   ' Write configuration register
SYMBOL  CFGR    = $AC                   ' Read configuration register


' -----[ Variables ]-------------------------------------------------------
'
SYMBOL  cmdByte = B0                    ' command sent to DS1620
SYMBOL  loTmpC  = B0                    ' lo byte of temperature
SYMBOL  hiTmpC  = B1                    ' high byte (sign) of temperature
SYMBOL  tempC   = W0                    ' temperature (needs 9 bits)
SYMBOL  tempF   = B2                    ' temperature in Fahrenheit
SYMBOL  shift   = B3                    ' shift/loop counter
SYMBOL  outp    = B4                    ' LCD output workspace
SYMBOL  char    = B5                    ' char sent to LCD
SYMBOL  tOut    = B6                    ' temperature to display


' -----[ Initialization ]--------------------------------------------------
'
	EEPROM 0,("TEMP IS    ",DegSym," (",TMode,")")

Init:   Dirs = %11111111                ' all pins are outputs
	Pins = %00000000                ' clear I/O pins

	' initialize the DS1620
	'
	HIGH RST                        ' alert the DS1620
	cmdByte = CFGW                  ' prepare to write config
	GOSUB CmdOut  
	cmdByte = %00000010             ' use with CPU; free run mode
	GOSUB CmdOut
	LOW RST
	PAUSE 10                        ' wait 10 ms for EEPROM write
	HIGH RST                        ' alert the DS1620
	cmdByte = START
	GOSUB CmdOut                    ' start continuous conversion
	LOW RST                         ' end DS1620 commo

	' initialize the LCD
	'
	Pins = %00000011                ' 8-bit mode
	PULSOUT E, 1
	PAUSE 5
	PULSOUT E, 1
	PULSOUT E, 1
	Pins = %00000010                ' 4-bit mode
	PULSOUT E, 1
	char = %00001100                ' display on, cursor off
	GOSUB WrLCD
	char = %00000110                ' inc cursor, no disp shift
	GOSUB WrLCD
	char = %00000001                ' clear LCD
	GOSUB WrLCD
	HIGH RS                         ' LCD to character mode

	FOR shift = 0 TO 15             ' put "TEMP IS..." in LCD
	  READ shift, char
	  GOSUB WrLCD
	NEXT shift


' -----[ Main Code ]-------------------------------------------------------
'
Main:   HIGH RST                        ' alert the DS1620
	cmdByte = TEMPR                 ' prep for temperature read
	GOSUB CmdOut
	GOSUB TempIn                    ' get temp from the DS1620
	LOW RST                         ' end DS1620 commo

ShowF:  tOut = loTmpC * 9 + 325 / 10    ' convert to F with rounding
ShowC:  ' tOut = loTmpC / 2 + Bit0      ' round up Celsius value
ShowT:  Dirs = %11111111                ' reset I/O pins to outputs
	char = $88                      ' move to 8 position in LCD
	LOW RS
	GOSUB WrLCD
	HIGH RS
	char = tOut / 100 + 48          ' convert 100's to ASCII
	GOSUB WrLCD
	tOut = tOut // 100
	char = tOut / 10 + 48           ' convert 10's to ASCII
	GOSUB WrLCD
	char = tOut // 10 + 48          ' convert 1's to ASCII
	GOSUB WrLCD

P1250:  PAUSE 1250                      ' pause for 1.25 seconds
	GOTO Main                       ' do it again


' -----[ Subroutines ]-----------------------------------------------------
'

' Send command to DS1620
' 8-bit command is sent LSB -> MSB
'
CmdOut: OUTPUT DQPin                    ' make DQ an output
	HIGH CLK
	FOR shift = 1 TO 8              ' shift eight bits
	  DQ = Bit0                     ' get LSB of cmdByte
	  PULSOUT CLK, 10               ' clock out the bit
	  cmdByte = cmdByte / 2         ' shift cmd for next bit
	NEXT shift
	RETURN


' Retrieve temperature from DS1620
' Data comes in LSB -> MSB in 9 bits
' - 1 bit for sign
' - 8 bits for temp (in 2's compliment format if negative)
'
TempIn: INPUT DQPin                     ' make DQ an input
	HIGH CLK
	FOR shift = 1 TO 9
	  tempC = tempC / 2             ' shift temp bits
	  LOW CLK
	  Bit8 = DQ                     ' get data bit
	  HIGH CLK
	NEXT shift
	RETURN


' send byte to the LCD display
'
WrLCD:  Pins = Pins & %11010000         ' save 7, 6 and RS; data bus clear
	outp = char / 16                ' get high nibble
	Pins = Pins | outp              ' output the nibble
	PULSOUT E, 1                    ' strobe the Enable line
	Pins = Pins & %11010000
	outp = char & %00001111         ' get low nibble
	Pins = Pins | outp
	PULSOUT E, 1
	RETURN
                                                                               