' Program HUMID.BAS
' The Stamp interfaces to an inexpensive temperature/humidity 
' sensor kit. Data from the sensors is displayed on the host 
' PC using the debug command. This program does not include 
' routines for calibration or conversion, presenting instead
' raw timing data from the sensors. 

Symbol	temp = w4	' Temperature
Symbol	RH = w5		' Humidity

' The main program loop reads the sensors and displays 
' the data on the PC screen until the user presses a 
' key. Remember that even when the debug screen is not
' displayed, the Stamp is still active. Disconnect it 
'  to conserve battery power. 

Loop: 
input 0:input 2: output 3
low 2: low 3
let temp = 500			' Start temp at a reasonable value. 

ReadTemp:
	output 1: low 1
	pause 1			' Discharge the capacitor.
	input 1			' Get ready for input. 
	pulsout 2,temp		' Charge the cap through temp sensor.
	if pin1 = 1 then ReadRH	' If it's charged, we're done. 
	let temp = temp + 1	' Else try again with wider pulse.
	goto ReadTemp

ReadRH:
	high 3			' Turn on the 555 timer
	pause 500		' and let it stabilize. 
	pulsin 0,1,RH		' Read the pulse width.
	low 3			' Kill the timer. 
	debug temp		' Display the results. 
	debug RH
	goto Loop		' Do it all again. 






