' PROGRAM: DS1620.BAS
' January 15, 1995
' Richard Juengel
' BASIC Stamp program that uses the Dallas DS1620 digital temperature
' sensor / thermostat and reads it via 3 wire interface. RS-232 output
' is used to send temperature to monitor or PC
' Temperature high/low thermostat registers not used in this example. 
' Connect stamp p0 to DS1620 pin 3, p1 to pin 2, p2 to pin1.

'SYMBOLS---------------------------------------------------

Symbol  CS      = 0     'Chip select/reset to p0
Symbol  CLK     = 1     'Clock to p1
Symbol  DQ      = pin2  'Data I/O to p2
Symbol  S_out   = 6     'Serial RS232 output to p6
'
Symbol  i       = b0    'Index counter
Symbol  outreg  = b1    '
Symbol  ormask  = b2    '
Symbol  andmask = b3    'Working registers
Symbol  data    = b4    '
Symbol  temp    = b5    '
Symbol  newdata = b6    '

'Command bytes (not all used- for reference only)
Symbol  TH      = $01   'Write Temp high register
Symbol  TL      = $02   'Write Temp low register
Symbol  CFG     = $0C   'Write Config register
Symbol  STP     = $22   'Stop conversion
Symbol  THR     = $A1   'Read contents of TH register
Symbol  TLR     = $A2   'Read contents of TL register
Symbol  TR      = $AA   'Read contents of temp. register
Symbol  CF      = $AC   'Read contents of config. register
Symbol  SC      = $EE   'Start conversion

	
setup:  let pins = 0            'Pins lo (reset chip). 
	let dirs = %11111111    'S_out, CLK, CS outputs. 

	
'INIT DS1620--SEND WRITE CONFIG REG. COMMAND-----------------

init:   high CLK                'Init clock
	pause 1
	high CS                 'Select chip
	let outreg = CFG        'Load command for config reg.
	for i = 1 to 8          'Length of command
	let DQ = outreg         'Output to pin 2
	pulsout CLK,10          'Clock pulse, 10 us 
	let outreg = outreg/2   'Shift right
	next i                  'Do until done

'LOAD CONFIG. REG. WITH CPU, CONTINUOUS XMT MODE------------
	let outreg = %00000010  'CPU mode, continious
	for i = 1 to 8          'Loop counter
	let DQ = outreg         'Output to pin 2
	pulsout CLK,10          '10 us clock pulse
	let outreg = outreg/2   'Shift right
	next i                  'Do until done
	low CS                  'Reset chip
	pause   5               'delay time to write EE

'SEND START CONVERSION COMMAND------------------------------
	high CS                 'Select chip again
	let outreg = SC         'Start conversion command
	for i = 1 to 8          'Loop counter
	let DQ = outreg         'Output to pin 2
	pulsout CLK,10          'clock
	let outreg = outreg/2   'Shift right
	next i                  'Do until done
	low CS                  'Reset chip

'MAIN LOOP---------------------------------------
loop:   gosub conv              'Get the temp. data.
	gosub flip              'Put bits in MSB first order
out:    serout S_out,N2400,(32,#data,32,248,70,13) 'Send data, CR.
	debug data ," F"
	pause 2000              'Wait 2 seconds
	goto loop               'Do it forever. 

'GET TEMPERATURE REGISTER SUBROUTINE-------------------------------------

conv:   high  CLK               'Put clock line in starting state. 
	high CS                 'Select ADC.
	let outreg = TR         'Send $AA command to send temp. reg. 
	for i = 1 to 8          'Eight data bits.
	let DQ = outreg         'Send bit
	pulsout CLK, 10         '10 us clock pulse.     
	let outreg = outreg/2   'shift right 
	next i                  'Do it again.

'NOW CLOCK OUT THE TEMP. REGISTER-----------------------------------------
	input 2                 'Now make 2 an input
	let data = 0            'Clear data
	for i = 1 to  8         'Eight data bits plus sign
	let data = data * 2     'Shift left
	low CLK                 'Clock pulse start
	let data = data + DQ    'Put bit in LSB of data
	high CLK                'End clock pulse
	next i                  'Do until done
	output 2                'Back to being an output
	low CS                  'Deselect ADC when done.
	return

'FLIP TEMP. REGISTER SUBROUTINE---------------------------

flip:   let ormask = 1          'Ormask char
	let newdata = 0         'Clear old data
	let andmask = 128       'And mask char
	for i = 1 to 8          'Loop counter
	let temp = data & andmask 'And temp with 128
	if temp > 0 then do_nxt 'Got a 1?
cont:   andmask = andmask / 2   'Shift right
	ormask = ormask * 2     'Shift left
	next i                  'Loop counter

'CONVERT DATA TO DEGREES F
	let data = newdata      'Transfer from temp reg.
	let data = data / 2     'Get output from 1/2 bit/Deg. to 1 bit/deg
	let data = 9*data/5+32  'Convert to F (remove this line for C )
	return                  'Finished..return
do_nxt: newdata=newdata | ormask  'Or with 1
	goto cont               'Do until all 8 bits done
