' -----[ Title ]--------------------------------------------------------------
'
' File...... DLOADMSG.BAS
' Purpose... To download a string to Stamp message display
' Author.... Jon Williams (blatantly copied from Scott Edwards)
' Started... July 25, 1994
' Updated... July 26, 1994


' -----[ Program Description ]------------------------------------------------
'
' QBASIC program for downloading a message to the Stamp scrolling message
' display.  This is a modified version of the program presented by Scott
' Edwards for sending a message to his Micro-Messenger project (see Popular
' Electronics, September 1994, pp 31-36).
'
' This program reads your message (up to 50 characters) then sends each
' character to the Stamp.  The program inserts a pause between characters
' to give the Stamp a chance to catch them.


' -----[ Revision History ]---------------------------------------------------
'
' 07-25-94 : Version 1

' -----[ Constants ]----------------------------------------------------------
'


' -----[ Variables ]----------------------------------------------------------
'
DIM msg AS STRING
DEFINT A-Z


' -----[ Initialization ]-----------------------------------------------------
'
Init:   OPEN "COM1:2400,N,8,1,CD0,CS0,DS0,OP0,RS" FOR OUTPUT AS #1

       
' -----[ Main Code ]----------------------------------------------------------
'
Main:   CLS
        PRINT "Stamp Message Downloader"
        PRINT
        PRINT "Enter message to for display   (50 characters max)"
        PRINT
        PRINT ".........1.........2.........3.........4.........5"
        LINE INPUT ""; msg$
        L = LEN(msg$)
        IF L > 50 THEN msg$ = LEFT$(msg$, 50): L = 50
        '
        ' send length of message (as one byte)
        '
        PRINT #1, CHR$(L)
        GOSUB Delay
        '
        ' send message, one character at a time
        '
        FOR X = 1 TO LEN(msg$)
          PRINT #1, MID$(msg$, X, 1)
          GOSUB Delay
        NEXT X
        PRINT
        PRINT "Message sent. . ."
        PRINT
        CLOSE
        SYSTEM


' -----[ Subroutines ]--------------------------------------------------------
'
Delay:  FOR Y = 1 TO 2000               ' delay for 486-25 (AST)
        NEXT Y
        RETURN

