' DIGITMPF.BAS: BASIC Stamp Digital Thermometer
' 
'          Ŀ
' Diplays:  TEMP IS xxxF   on a 1x16 LCD display
'           
'
' Jon Williams
' Riverside, CA
'
' See DIGITEMP.TXT for documentation

 
' -----[ SYMBOLS ] --------------------------------------------------------
'
SYMBOL  E       = 5                     ' LCD enable pin (1 = enabled)
SYMBOL  RS      = 4                     ' Register Select (0 = instruction)
SYMBOL  co0     = 162                   ' thermister conversion constants
SYMBOL  co1top  = 255
SYMBOL  co1btm  = 2125
SYMBOL  co2bt1  = 25
SYMBOL  co2top  = 3
SYMBOL  co2btm  = 50
SYMBOL  degsym  = 223                   ' degrees symbol
'
' variables
'
SYMBOL  outp    = b0                    ' output workspace
SYMBOL  char    = b1                    ' char sent to LCD
SYMBOL  index   = b2                    ' loop index
SYMBOL  digit   = b3                    ' diplay digit
SYMBOL  temp    = w2                    ' temperature reading
SYMBOL  work1   = w3
SYMBOL  work2   = w4
SYMBOL  work3   = w5
SYMBOL  stack   = w6                    ' DON'T USE!...


' -----[ Here we go... ]---------------------------------------------------
'
Begin:  pins = %00000000
	dirs = %00111111
	pause 200                       ' let the LCD settle


' -----[ Initialize the LCD (Hitatchi HD44780 controller) ]----------------
'
Init:   pins = %00000011                ' 8-bit mode
	pulsout E, 1
	pause 5
	pulsout E, 1
	pause 5
	pulsout E, 1
	pause 5
	pins = %00000010                ' 4-bit mode
	pulsout E, 1
	pulsout E, 1
	pulsout E, 1
	char = %00001100                ' display on, cursor off
	gosub WrLCD
	char = %00000110                ' inc cursor, no disp shift
	gosub WrLCD
	char = %00000001                ' clear lcd
	gosub WrLCD
	high RS                         ' LCD to character mode


' -----[ Main program ]----------------------------------------------------
'
GetTmp: pot 7, 46, temp                 ' read the thermistor

	work1 = temp * temp / co2bt1 * co2top / co2btm
	temp = temp * co1top / co1btm + temp
	temp = co0 + work1 - temp

	
' -----[ Show the temperature ]--------------------------------------------
'
Show:   gosub HmCrsr                    ' move cursor to position 0
	for index = 0 TO 8              ' put label in LCD
	  lookup index, (" TEMP IS "), char
	  gosub WrLCD 
	next index
	gosub A_Out                     ' show the temperature in F
	char = degsym                   ' output degrees symbol
	gosub WrLCD
	char = "F"
	gosub WrLCD
	pause 1000                      ' wait between readings 
	goto GetTmp                     ' get a new reading


' -----[ Convert temp to ASCII and display ]-------------------------------
'
A_Out:  work1 = temp                    ' save temperature
	work2 = 100                     ' initial divisor
	for index = 1 to 3              ' show temp with 3 digits
	  char = work1 / work2 + 48     ' get digit; convert to ASCII
	  gosub WrLCD
	  work1 = work1 // work2        ' get remainder
	  work2 = work2 / 10            ' get new divisor
	next index
	return


' -----[ Clear the LCD ]---------------------------------------------------
'
' This routine has been commented out to make room for other code.
'
' ClrLCD: low RS                          
'         char = 1
'         gosub WrLCD
'         high RS
'         return


' -----[ Home the LCD cursor ]---------------------------------------------
'
HmCrsr: low RS
	char = 2
	gosub WrLCD
	high RS
	return


' -----[ Write ASCII char to LCD ]-----------------------------------------
'
WrLCD:  pins = pins & %00010000         ' E = High, data bus clear
	outp = char / 16                ' get high nibble
	pins = pins | outp              ' output the nibble
	pulsout E, 1                    ' strobe the Enable line
	pins = pins & %00010000
	outp = char & %00001111         ' get low nibble
	pins = pins | outp
	pulsout E, 1
	return
