' Program for use with MAXIM MAX186DCPP chip.
' It's an 8 channel 12-bit Serial ADC.  (I got a free
' sample!  Else a single unit costs $17.48 in the latest
' Digi-Key catalog.)

' This program shows how a STAMP can access any channel.
' Pins 0-4 are required.  Pins 5,6,7 are unused for now.
' But they could be used for serial communication to other
' STAMPS or computers, or for extra options, devices, etc.


' May 1, 1995
' Mark R. Whitney
' 921 Denton Blvd. #1503
' Ft. Walton Beach, FL  32547
'
' email:  whitneym@uy1.eglin.af.mil


' MAX186 control bits (configuration byte) for this program...
' 1      XXX         1          1              10
' flag,  channel #,  unipolar,  single-ended,  internal clock


'	MAX186 pin layout & connections for this program...
'
'	20	Vdd (used BS1-1C 5V regulated output)
'	1-8	CH0-CH7
'
' Test circuit had 10K & 4.7K resistors in series from Vdd to
' CH0, then 10K resistors hooked between CH0-CH1, CH1-CH2,
' CH2-CH3, CH3-CH4, CH4-GROUND to give some test voltages.
' CH5 & CH6 were grounded.  CH7 was hooked to output of voltage
' divider made with a 10K resistor to Vdd and a photocell
' connected to ground.  (Any construction method should be
' fine, i.e. my breadboard & "spaghetti" wiring worked great.
' But supply bypass caps are always a good idea.)
'
'	9	Vss (negative supply--grounded)
'	10	SHDN (active-low shutdown input--tied to Vdd)
'	11	VREF (conversion reference--no connection)
'	12	REFADJ (reference tweaker--through 0.01 uF cap to ground)
'	13	AGND (analog ground--grounded)
'	14	DGND (digital ground--grounded)
'	15	DOUT (AD conversion serial output--pin4 of STAMP)
'	16	SSTRB (conversion status--pin3 of STAMP)
'	17	DIN (command serial input--pin1 of STAMP)
'	18	CS (active-low select--pin0 of STAMP)
'	19	SCLK (serial clock line--pin2 of STAMP)



symbol CS=0		' O-pin0 is MAX186 chip select line
symbol DIN=pin1		' O-pin1 is MAX186 serial data input
symbol SCLK=2		' O-pin2 is MAX186 serial clock input
symbol SSTRB=pin3	' I-pin3 receives MAX186 conversion status flag
symbol DOUT=pin4	' I-pin4 receives MAX186 serial data

symbol CONFIG=%10001110	' default configuration byte for MAX186

MAIN:

dirs=%00000111

high CS				' let stuff idle for a while
low SCLK			' SCLK must start out low
pause 100			' so "pulsout" will work later...

for b3=0 to 7			' test all channels
	gosub SR_MAX186
	debug w0
next
b3=7
for b4=0 to 20			' test photocell channel for a while...
	gosub SR_MAX186
	debug w0
next
end


'****************************************************************
' SR_MAX186 returns an AD conversion from channel 0-7 of
' the MAX186DCPP chip.  b3 specifies the channel.  w0 returns
' the result (0-4096 mV).  b0,b1, & b2 are work variables.
'****************************************************************

SR_MAX186:
	b0=CONFIG		' default control byte
	b1=b3
	bit6=bit8		' decode address
	bit5=bit10		' this is peculiar to single-ended mode
	bit4=bit9
	low CS
	for b2=1 to 8		' serial output of config. byte to MAX186
		DIN=bit7
		b0=b0*2		' shift config. byte left
		pulsout SCLK,1
	next

				' sending config byte starts conversion
	w0=0			' clear junk from w0
				' conversion has already begun...
				' wait for MAX186 to finish conversion...

' NOTE:  A fixed delay here, long enough for a worst case conversion,
'        might eliminate the need to check SSTRB.  This could save an
'        I/O line for something else.  (Just an idea.)

	WAIT_FOR_CONV:
		if SSTRB=0 then WAIT_FOR_CONV

	for b2=1 to 12		' clock out 12 bit result to w0
		bit0=DOUT
		w0=w0*2		' shift left to make room for next bit
		pulsout SCLK,1
	next
	high CS
	return

' NOTE:  Permanently grounding CS on the MAX186 might save another
'        I/O line.  (Just another idea.)

