
'***** ET-BASIC STAMP V2.0  with RTC DS1202 ****
'
'       B14      RTC ADDRESS
'       B15      RTC DATA
'       CALL     RTCSET   WRITE DATA TO RTC
'       CALL     RTCGET   READ DATA FORM RTC
'
' Note : All values are stored in BCD. Print as Hex to Display.

Symbol  S7 = 7                                  ' Serial Output Channel

        B14=$07 : B15=$00 :CALL RTCSET   'DATA WRITE PROTECT 00H=OFF 80H=ON

        B14=$00 : B15=$45 :CALL RTCSET   'DATA TO SEC
        B14=$01 : B15=$59 :CALL RTCSET   'DATA TO MIN
        B14=$02 : B15=$23 :CALL RTCSET   'DATA TO HR
        B14=$03 : B15=$31 :CALL RTCSET   'DATA TO DATE
        B14=$04 : B15=$12 :CALL RTCSET   'DATA TO MONTH
        B14=$06 : B15=$97 :CALL RTCSET   'DATA TO YEAR

        B14=$07 : B15=$80 :CALL RTCSET   'DATA WRITE PROTECT 00H=OFF 80H=ON


Loop:   B14=$00 : CALL RTCGET
        B19=B15           'SEC
        B14=$01 : CALL RTCGET
        B20=B15           'MIN
        B14=$02 : CALL RTCGET
        B21=B15           'HR

        B14=$03 : CALL RTCGET
        B17=B15           'DATE
        B14=$04 : CALL RTCGET
        B16=B15           'MONTH
        B14=$06 : CALL RTCGET
        B10=B15           'YEAR

        B13="/" : B11=B17 : GOSUB P2
                  B11=B16 : GOSUB P02
        B13=" " : B11=B10 : GOSUB P02

        B13=":" : B11=B19 : GOSUB P2
                  B11=B20 : GOSUB P02
        B13=13  : B11=B21 : GOSUB P02
        Pause 250                               ' Visual Delay
        Goto Loop                               ' Continue Forever

P2:     IF B11 >=10 THEN P02: B12=" ":GOSUB PC:GOTO P1
P02:    B12 = B11 / 16 + "0" : Gosub PC
P1:     B12 = B11 & $0F + "0" : Gosub PC
        B12=B13
PC:     Serout S7,T2400,(B12)
        Return

ASM
;**********************************************
; Real Time Clock I/O (RTC DS1202)
;**********************************************
; _RTCSet : Write Time/Date to Real Time Clock
;           B14      RTC ADDRESS
;           B15      RTC DATA WRITE
;  DS1202   RA0 = CLK
;           RA1 = I/O
;           RA2 = /RST(CS)
;
_RTCSet    MOVLW    10H         ;SET OUTPUT PORT
           TRIS     PORTA
           MOVLW    04H         ;RTS=1 ,CLK=0
           MOVWF    PORTA
           BCF      STATUS,C    ;CLEAR CARRY FLAG
           RLF      _B14        ;ROTATE LEFT
           BSF      _B14.7      ;SET COMMAND
           BCF      _B14.6      ;RAM ACCRESS
           BCF      _B14.0      ;WRITE COMMAND
           BCF      STATUS,C
           MOVLW    8
           MOVWF    T0
W_RTC1     BCF      PORTA.0     ;SET CLK=0
           RRF      _B14        ;ROTATE RIGHT BIT
           MOVB     PORTA.1,C   ;CARRY=I/O
           BSF      PORTA.0     ;SET CLK=1
           DJNZ     T0,W_RTC1
;
           MOVLW    8
           MOVWF    T0
           BCF      STATUS,C
W_RTC2     BCF      PORTA.0     ;SET CLK=0
           RRF      _B15        ;ROTATE RIGHT BIT
           MOVB     PORTA.1,C   ;CARRY=I/O
           BSF      PORTA.0     ;SET CLK=1
           DJNZ     T0,W_RTC2

           MOVLW    00H
           MOVWF    PORTA
           GOTO     DONE
;
;************************************************
; _RTCGET : READ Time/Date to Real Time Clock
;           B14      RTC ADDRESS
;           B15      RTC DATA READ
;  DS1202   RA0 = CLK
;           RA1 = I/O
;           RA2 = /RST(CS)
;
_RTCGET    MOVLW    10H         ;SET OUTPUT PORT
           TRIS     PORTA
           MOVLW    04H         ;RTS=1 ,CLK=0
           MOVWF    PORTA

           BCF      STATUS,C    ;CLEAR CARRY FLAG
           RLF      _B14        ;ROTATE LEFT
           BSF      _B14.7      ;SET COMMAND
           BCF      _B14.6      ;RAM ACCRESS
           BSF      _B14.0      ;READ COMMAND
           BCF      STATUS,C
           MOVLW    8H
           MOVWF    T0
RD_RTC1    BCF      PORTA.0     ;SET CLK=0
           RRF      _B14        ;ROTATE RIGHT BIT
           MOVB     PORTA.1,C    ;CARRY=I/O
           BSF      PORTA.0     ;SET CLK=1
           DJNZ     T0,RD_RTC1
;
           MOVLW    12H         ;SET BIT 1 =INPUT
           TRIS     PORTA
           MOVLW    8
           MOVWF    T0
           MOVLW    4
           MOVWF    PORTA
;
RD_RTC2    BCF     PORTA.0     ;SET CLK=0
           MOVB    C,PORTA.1   ;INPUT PA BIT1
           RRF     _B15        ;ROTATE RIGHT BIT
           BSF     PORTA.0     ;SET CLK=1
           DJNZ    T0,RD_RTC2

           MOVLW    00H
           MOVWF    PORTA
           GOTO     DONE
;
ENDASM

