;***************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y   *   
;*                                                                         *
;* Number		:AVR                                               *
;* File Name		:"adc.asm"                                         *
;* Title		:read analog to digital                            *
;* Date                 :6/1/42                                            *
;* Version              :1.0                                               *
;* Support telephone	:712 1120-1 (ETT)                                  *
;* Support fax		:3917216 (ETT)                                     * 
;* Support www          :www.etteam.com,www.ett.co.th                      * 
;* Target MCU		:AT90S8535/AT90LS8535                              *
;*                                                                         *  
;***************************************************************************
;
.include "8535def.inc"

            .org   $000 
            rjmp  RESET		;Reset Handle

;****************************************************************************
;*
;* Test/Example Program
;*
;****************************************************************************
;
.def	    temp  = r19
;


RESET:      ldi     temp,low(RAMEND)
            out     SPL,temp          ;init Stack Pointer Low     

            ldi     temp,high(RAMEND)
            out     SPL+1,temp        ;init Stack Pointer High


            cli                        ;clear golbal interrupt
            cbi     UCR,RXCIE          ;clesr rx interrupt
            cbi     UCR,TXCIE          ;clesr tx interrupt
            cbi     UCR,UDRIE          ;clesr data empty interrupt
            cbi     UCR,CHR9           ;send 8 data 
                
            ldi     r17,51
            out     UBRR,r17           ;baud 9600 at 8MHz Xtal 
  
            sbi     UCR,TXEN           ;set pin tx as serial TX 
       

;****************************************
;*                                      *
;*           LCD  CONTROL               *
;*                                      * 
;****************************************
LCD:         rcall   delay 
             rcall   delay       

             ldi     r29,0xff
             out     DDRC,r29
             ldi     r29,0xff
             out     PORTC,r29
                
             rcall   init_lcd          ;init LCD

             ldi     r21,0x00
             rcall   goto_lcd
             ldi     r21,0x45          ;E
             rcall   wr_lcd 
             ldi     r21,0x54          ;T
             rcall   wr_lcd
             ldi     r21,0x2d          ;-
             rcall   wr_lcd   
             ldi     r21,0x41          ;A 
             rcall   wr_lcd
             ldi     r21,0x56          ;V  
             rcall   wr_lcd
             ldi     r21,0x52          ;R
             rcall   wr_lcd      
             rcall   sendch
             ret                        

goto_lcd:    sbr     r21,0x80
             rcall   wr_ins  
             ret


init_lcd:    cbi     PORTC,1                                 
             ldi     r21,0x33             ;set DL = 1 3-time
             rcall   wr_ins
             ldi     r21,0x32             ;clear DL = 0;1-time
             rcall   wr_ins
             ldi     r21,0x28             ;Function set
             rcall   wr_ins               ;DL = 0 4 bit,N = 1 2 line        
             ldi     r21,0x0c
             rcall   wr_ins
             ldi     r21,0x06              
             rcall   wr_ins 
             ldi     r21,0x01
             rcall   wr_ins 
             ret


;***********************************************
;*           write instruction LCD             *
;*   input : r21                               *
;***********************************************
wr_ins:      cbi     PORTC,1              ;clear RS_LCD    
             mov     r22,r21        
             andi    r21,0xf0
             in      r16,PORTC
             andi    r16,0x0f
             or      r16,r21                             
             out     PORTC,r16            ;send high byte             
             rcall   en_lcd
             swap    r22
             andi    r22,0xf0
             in      r16,PORTC
             andi    r16,0x0f     
             or      r16,r22
             out     PORTC,r16            ;send low byte 
             rcall   en_lcd
             ret           
  
;**********************************************
;*                                            *                                             
;*                                            *
;**********************************************
wr_lcd:      sbi     PORTC,1
             mov     r22,r21
             in      r16,PORTC
             andi    r16,0x0f
             andi    r21,0xf0
             or      r16,r21
             out     portc,r16     
             rcall   en_lcd 
             swap    r22
             in      r16,PORTC
             andi    r16,0x0f
             andi    r22,0xf0
             or      r16,r22
             out     PORTC,r16  
             rcall   en_lcd 
             ret

;*********************************************
;*                                
;*
;*********************************************  
en_lcd:      cbi     PORTC,0          
             rcall   busy
             sbi     PORTC,0 
             ret

;********************************************
;*
;*
;********************************************
busy:        ldi    r25,0x10
busy2:       ldi    r26,0xff
busy1:       dec    r26
             brne   busy1
             dec    r25 
             brne   busy2
             ret              


;*******************************************
;*                  delay 
;*                
;*******************************************
delay:       ldi    r28,0xff
delay2:      ldi    r29,0xff
delay1:      dec    r29
             brne   delay1
             dec    r28
             brne   delay2  
             ret         

            ldi     r17,0x00           ;set porta as Hi impledance
            out     DDRA,r17            
            out     PORTA,r17   
            cbi     ADCSR,ADFR         ;select single conversion     
             
            rcall   sendch
xx:         rjmp    xx           


;***************************************************
;*           program  read data for    ADC         *  
;***************************************************
ATOD:       in      r21,ADCL           ;read low byte
            in      r22,ADCH           ;read high byte
            mov     r23,r21 
                               
            andi    r22,0x03           ;detect 3 bit low of ADCH 
            ldi     ZH,high(HEXTBL*2)  ;get high of pointer 
            ldi     ZL,low(HEXTBL*2)   ;get low of pointer  
            add     r30,r22          
            ldi     r22,0
            adc     r31,r22          
            lpm                        ;get data from program memory 
            mov     r20,r0             ;put data to rs232
            rcall   TX232

            swap    r21                
            andi    r21,0x0F           ;detect 4 bit high of ADCL 
            ldi     ZH,high(HEXTBL*2)  ;get high of pointer
            ldi     ZL,low(HEXTBL*2)   ;get low of pointer  
            add     r30,r21
            ldi     r21,0
            adc     r31,r21          
            lpm                        ;get data from program memory
            mov     r20,r0             ;put data to rs232
            rcall   TX232
                         
            andi    r23,0x0F           ;detect 4 bit low of ADCL
            ldi     ZH,high(HEXTBL*2)  ;get high of pointer
            ldi     ZL,low(HEXTBL*2)   ;get low of pointer  
            add     r30,r23
            ldi     r23,0
            adc     r31,r23          
            lpm                        ;get data from program memory
            mov     r20,r0             ;put data to rs232              
            rcall   TX232
            ret

;***************************************
;*    subrutine for show adc on pc     *
;***************************************
sendch:     ldi     r20,0x0c
            rcall   TX232  
            ldi     r16,64    
            ldi     ZH,high(CH0*2)
            ldi     ZL,low(CH0*2)  
send1:      lpm     
            adiw    ZL,1
            mov     r20,r0
            rcall   TX232
            dec     r16
            brne    send1    
            ldi     r20,0x0a
            rcall   TX232
            ldi     r20,0x0d
            rcall   TX232
send3:      ldi     r18,8
            ldi     r17,0x00           ;start  chanl 0 ADC
send2:      out     ADMUX,r17
            sbi     ADCSR,ADEN         ;enable ADC
            sbi     ADCSR,ADSC         ;start conversion  
send4:      sbis    ADCSR,ADIF
            rjmp    send4                    
            rcall   ATOD             
            ldi     r20,0x20
            rcall   TX232
            rcall   TX232
            rcall   TX232
            rcall   TX232
            rcall   TX232   
            inc     r17  
            dec     r18     
            brne    send2 
            ldi     r20,0x0d
            rcall   TX232
            rcall   p72io 
            rjmp    send3 
            ret    

p72io:      ldi     r17,0xff          ;set port b,c,d as output
            out     DDRB,r17
            out     DDRC,r17
            out     DDRD,r17
           

loop1:      ldi     r17,0b10101010
            out     PORTB,r17
            out     PORTC,r17
            out     PORTD,r17 
            rcall   delayx  
            rcall   delayx
            ldi     r17,0b01010101  
            out     PORTB,r17
            out     PORTC,r17
            out     PORTD,r17  
            rcall   delayx  
            rcall   delayx
            ret   

;*************************         
;*     delay program     *  
;*************************   
delayx:    ldi     r22,0x04
dly1:      ldi     r23,0x0ff
dly2:      ldi     r24,0x0ff
dly3:      dec     r24
           brne    dly3  
           dec     r23
           brne    dly2   
           dec     r22
           brne    dly1
           ret   
                  


  
    
TX232:      sbis    USR,UDRE           ;wait until UDRE = 1
            rjmp    TX232 
            out     UDR,r20            ;send data to serial  
            ret 
            
RX232:      sbis    USR,RXC            ;wait until have data in buffer
            rjmp    RX232
            in      r20,UDR            ;read data from buffer
            rcall   TX232  
            ret 
        
.CSEG
HEXTBL:    .db     0x30,0X31           ;table for convert hex to ascii
           .db     0X32,0X33
           .db     0X34,0X35
           .db     0X36,0X37
           .db     0X38,0X39
           .db     0X41,0X42
           .db     0X43,0X44
           .db     0X45,0X46
               

.CSEG
CH0:       .db     0x43,0x48,0x30,0x20,0x20,0x20,0x20,0x20
           .db     0x43,0x48,0x31,0x20,0x20,0x20,0x20,0x20
           .db     0x43,0x48,0x32,0x20,0x20,0x20,0x20,0x20
           .db     0x43,0x48,0x33,0x20,0x20,0x20,0x20,0x20
           .db     0x43,0x48,0x34,0x20,0x20,0x20,0x20,0x20
           .db     0x43,0x48,0x35,0x20,0x20,0x20,0x20,0x20
           .db     0x43,0x48,0x36,0x20,0x20,0x20,0x20,0x20
           .db     0X43,0x48,0x37,0x20,0x20,0x20,0x20,0x20        



            