;***************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y   *   
;*                                                                      
;* Number		:AVR
;* File Name		:"p72io.asm"
;* Title		:read analog to digital
;* Date                 :6/1/42
;* Version              :1.0
;* Support telephone	:712 1120-1 (ETT)
;* Support fax		:3917216 (ETT)
;* Support www          :www.etteam.com,www.ett.co.th
;* Target MCU		:AT90S8535/AT90LS8535
;*
;***************************************************************************
;
.include "8535def.inc"

	    .org   $0000 
             rjmp  RESET		;Reset Handle

;****************************************************************************
;*
;* Test/Example Program
;*
;****************************************************************************
;
.def	    temp  = r19
;

RESET:      ldi     temp,low(RAMEND)
            out     SPL,temp          ;init Stack Pointer Low     

            ldi     temp,high(RAMEND)
            out     SPL+1,temp        ;init Stack Pointer High


            cli                       ;clear golbal interrupt             
            ldi     r17,0xff          ;set port b,c,d as output
            out     DDRB,r17
            out     DDRC,r17
            out     DDRD,r17
           

loop1:      ldi     r17,0b10101010
            out     PORTB,r17
            out     PORTC,r17
            out     PORTD,r17 
            rcall   delay  
            rcall   delay
            rcall   delay
            ldi     r17,0b01010101  
            out     PORTB,r17
            out     PORTC,r17
            out     PORTD,r17  
            rcall   delay  
            rcall   delay
            rcall   delay 
            rjmp    loop1   

;*************************         
;*     delay program     *  
;*************************   
delay:     ldi     r22,0x04
dly1:      ldi     r23,0x0ff
dly2:      ldi     r24,0x0ff
dly3:      dec     r24
           brne    dly3  
           dec     r23
           brne    dly2   
           dec     r22
           brne    dly1
           ret   
                  

                   