;***************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y   *   
;*                                                                      
;* Number		:AVR
;* File Name		:"adc.asm"
;* Title		:read analog to digital
;* Date                 :6/1/42
;* Version              :1.0
;* Support telephone	:712 1120-1 (ETT)
;* Support fax		:3917216 (ETT)
;* Support www          :www.etteam.com,www.ett.co.th
;* Target MCU		:AT90S8535/AT90LS8535
;*
;***************************************************************************
;
.include "8535def.inc"

            .org   $000 
            rjmp  RESET		;Reset Handle

;****************************************************************************
;*
;* Test/Example Program
;*
;****************************************************************************
;
.def	    temp  = r19
;

RESET:      ldi     temp,low(RAMEND)
            out     SPL,temp          ;init Stack Pointer Low     

            ldi     temp,high(RAMEND)
            out     SPL+1,temp        ;init Stack Pointer High


;****************************************
;*                                      *
;*           LCD  CONTROL               *
;*                                      * 
;****************************************
LCD:         rcall   delay 
             rcall   delay       

             ldi     r29,0xff
             out     DDRC,r29
             ldi     r29,0xff
             out     PORTC,r29
                
             rcall   init_lcd          ;init LCD

             ldi     r21,0x00
             rcall   goto_lcd
             ldi     r21,0x45          ;E
             rcall   wr_lcd 
             ldi     r21,0x54          ;T
             rcall   wr_lcd
             ldi     r21,0x2d          ;-
             rcall   wr_lcd   
             ldi     r21,0x41          ;A 
             rcall   wr_lcd
             ldi     r21,0x56          ;V  
             rcall   wr_lcd
             ldi     r21,0x52          ;R
             rcall   wr_lcd      
xx:          rjmp    xx                         

goto_lcd:    sbr     r21,0x80
             rcall   wr_ins  
             ret


init_lcd:    cbi     PORTC,1                                 
             ldi     r21,0x33             ;set DL = 1 3-time
             rcall   wr_ins
             ldi     r21,0x32             ;clear DL = 0;1-time
             rcall   wr_ins
             ldi     r21,0x28             ;Function set
             rcall   wr_ins               ;DL = 0 4 bit,N = 1 2 line        
             ldi     r21,0x0c
             rcall   wr_ins
             ldi     r21,0x06              
             rcall   wr_ins 
             ldi     r21,0x01
             rcall   wr_ins 
             ret


;***********************************************
;*           write instruction LCD             *
;*   input : r21                               *
;***********************************************
wr_ins:      cbi     PORTC,1              ;clear RS_LCD    
             mov     r22,r21        
             andi    r21,0xf0
             in      r16,PORTC
             andi    r16,0x0f
             or      r16,r21                             
             out     PORTC,r16            ;send high byte             
             rcall   en_lcd
             swap    r22
             andi    r22,0xf0
             in      r16,PORTC
             andi    r16,0x0f     
             or      r16,r22
             out     PORTC,r16            ;send low byte 
             rcall   en_lcd
             ret           
  
;**********************************************
;*                                            *                                             
;*                                            *
;**********************************************
wr_lcd:      sbi     PORTC,1
             mov     r22,r21
             in      r16,PORTC
             andi    r16,0x0f
             andi    r21,0xf0
             or      r16,r21
             out     portc,r16     
             rcall   en_lcd 
             swap    r22
             in      r16,PORTC
             andi    r16,0x0f
             andi    r22,0xf0
             or      r16,r22
             out     PORTC,r16  
             rcall   en_lcd 
             ret

;*********************************************
;*                                
;*
;*********************************************  
en_lcd:      cbi     PORTC,0          
             rcall   busy
             sbi     PORTC,0 
             ret

;********************************************
;*
;*
;********************************************
busy:        ldi    r25,0x10
busy2:       ldi    r26,0xff
busy1:       dec    r26
             brne   busy1
             dec    r25 
             brne   busy2
             ret              


;*******************************************
;*                  delay 
;*                
;*******************************************
delay:       ldi    r28,0xff
delay2:      ldi    r29,0xff
delay1:      dec    r29
             brne   delay1
             dec    r28
             brne   delay2  
             ret          




            