;***************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y
;* 
;* Number		:AVR
;* File Name		:"ADC3.asm"
;* Title		:READ ADC chanel 3 to RS232
;* Date                 :2/3/42
;* Version              :1.0
;* Support telephone	:712 1120-1 (ETT)
;* Support fax		:3917216 (ETT)
;* Support www          :www.etteam.com,www.ett.co.th
;* Target MCU		:AT90S8535/AT90LS8535
;*
;***************************************************************************
;
.include "8535def.inc"

	    .org   $000 
             rjmp  RESET	        ;Reset Handle

            .org   $00E                 ;interrupt vector for ADC                  
             rjmp  ATOD 

;****************************************************************************
;*
;* Test/Example Program
;*
;****************************************************************************
;
.def	    temp  = r19   
;

RESET:      ldi     temp,low(RAMEND)
            out     SPL,temp           ;init Stack Pointer Low     

            ldi     temp,high(RAMEND)
            out     SPL+1,temp         ;init Stack Pointer High

            sei                        ;clear golbal interrupt
            cbi     UCR,RXCIE          ;clesr rx interrupt
            cbi     UCR,TXCIE          ;clesr tx interrupt
            cbi     UCR,UDRIE          ;clesr data empty interrupt
            cbi     UCR,CHR9           ;send 8 data 

            ldi     r17,51
            out     UBRR,r17           ;baud 9600 at 8MHz Xtal 
  
            sbi     UCR,TXEN           ;set pin tx as serial TX 
       
            ldi     r17,0x00           ;set porta as Hi impledance
            out     DDRA,r17            
            out     PORTA,r17   

            ldi     r17,0x02           ;set chanl 3 ADC
            out     ADMUX,r17

            ldi     r17,0b00011000     ;set sampling rate
            out     ADCSR,r17 
  
            sbi     ADCSR,ADEN         ;enable ADC

adcloop1:   sbi     ADCSR,ADSC         ;start conversion 
            rjmp    adcloop1
  
;***************************************************
;*   program for interrupt service routine  ADC    *  
;***************************************************
ATOD:       in      r21,ADCL           ;read low byte
            in      r22,ADCH           ;read high byte
            mov     r23,r21 
                               
            andi    r22,0x03           ;detect 3 bit low of ADCH 
            ldi     ZH,high(HEXTBL*2)  ;get high of pointer 
            ldi     ZL,low(HEXTBL*2)   ;get low of pointer  
            add     r30,r22          
            ldi     r22,0
            adc     r31,r22          
            lpm                        ;get data from program memory 
            mov     r20,r0             ;put data to rs232
            rcall   TX232

            swap    r21                
            andi    r21,0x0F           ;detect 4 bit high of ADCL 
            ldi     ZH,high(HEXTBL*2)  ;get high of pointer
            ldi     ZL,low(HEXTBL*2)   ;get low of pointer  
            add     r30,r21
            ldi     r21,0
            adc     r31,r21          
            lpm                        ;get data from program memory
            mov     r20,r0             ;put data to rs232
            rcall   TX232
                         
            andi    r23,0x0F           ;detect 4 bit low of ADCL
            ldi     ZH,high(HEXTBL*2)  ;get high of pointer
            ldi     ZL,low(HEXTBL*2)   ;get low of pointer  
            add     r30,r23
            ldi     r23,0
            adc     r31,r23          
            lpm                        ;get data from program memory
            mov     r20,r0             ;put data to rs232              
            rcall   TX232
           
            ldi     r20,0x0A           ;send 0AH to rs232
            rcall   TX232
            ldi     r20,0x0D           ;send 0DH to rs232
            rcall   TX232
            reti

  
    
TX232:      sbis    USR,UDRE           ;wait until UDRE = 1
            rjmp    TX232 
            out     UDR,r20            ;send data to serial  
            ret 
            
RX232:      sbis    USR,RXC            ;wait until have data in buffer
            rjmp    RX232
            in      r20,UDR            ;read data from buffer
            rcall   TX232  
            ret 
        
CSEG:
HEXTBL:    .db     0x30,0X31           ;table for convert hex to ascii
           .db     0X32,0X33
           .db     0X34,0X35
           .db     0X36,0X37
           .db     0X38,0X39
           .db     0X41,0X42
           .db     0X43,0X44
           .db     0X45,0X46
               
                            