;***************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y
;* 
;* Number		:AVR
;* File Name		:"timer0.asm"
;* Title		:rs232 echo
;* Date                 :6/1/42
;* Version              :1.0
;* Support telephone	:712 1120-1 (ETT)
;* Support fax		:3917216 (ETT)
;* Support www          :www.etteam.com,www.ett.co.th
;* Target MCU		:AT90S8535/AT90LS8535
;*
;***************************************************************************
;
.include "8535def.inc"

	    .org   $000 
             rjmp  RESET	        ;Reset Handle

            .org   $009                 ;Timer0 overflow Handle
             rjmp  TIM0_OVF

;****************************************************************************
;*
;* Test/Example Program
;*
;****************************************************************************
;
.def	    temp    =r19     
;

RESET:      ldi     temp,low(RAMEND)
            out     SPL,temp            ;init Stack Pointer Low     

            ldi     temp,high(RAMEND)
            out     SPL+1,temp          ;init Stack Pointer High

            sei                         ;set golbal interrupt
            ldi     temp,0b00000001     ;set timer0 interrupt
            out     TIMSK,temp  
                          
            ldi     temp,0xFF           ;set PORTD.1 output port 
            out     DDRB,temp
                      
            ldi     temp,0x00            
            out     TCNT0,temp          ;initial value of timer/counter0

            ldi     temp,0b00000101     ;set set prescale and start timer/counter0
            out     TCCR0,temp     
            
            ldi     temp,0xFF
loop:       rjmp    loop
                    

TIM0_OVF:   com     temp
            out     PORTB,temp 
            reti
                            