;***************************************************************************
;* A P P L I C A T I O N   N O T E   F O R   T H E   A V R   F A M I L Y
;* 
;* Number		:AVR
;* File Name		:"rs232.asm"
;* Title		:rs232 echo
;* Date                 :2/3/42
;* Version              :1.0
;* Support telephone	:712 1120-1 (ETT)
;* Support fax		:3917216 (ETT)
;* Support www          :www.etteam.com,www.ett.co.th
;* Target MCU		:AT90S8535/AT90LS8535
;*
;***************************************************************************
;
.include "8535def.inc"

	    .org   $000 
             rjmp  RESET	        ;Reset Handle



;****************************************************************************
;*
;* Test/Example Program
;*
;****************************************************************************
;
.def	    temp  = r19   
;

RESET:      ldi     temp,low(RAMEND)
            out     SPL,temp            ;init Stack Pointer Low     

            ldi     temp,high(RAMEND)
            out     SPL+1,temp          ;init Stack Pointer High

            sei                         ;clear golbal interrupt
            cbi     UCR,RXCIE           ;clesr rx interrupt
            cbi     UCR,TXCIE           ;clesr tx interrupt
            cbi     UCR,UDRIE           ;clesr data empty interrupt
            cbi     UCR,CHR9            ;send 8 data 

            ldi     r17,51
            out     UBRR,r17            ;baud 9600 at 8MHz Xtal 
  
            sbi     UCR,TXEN            ;set pin tx as serial TX 
            sbi     UCR,RXEN            ;set pin rx as serial RX  
       

            ldi     ZH,high(TBL1*2)     ;get high of pointer of TBL1
            ldi     ZL,low(TBL1*2)      ;get low of pointer  of TBL1          
echo:       lpm                         ;get data from program memory
            mov     r21,r0 
            ldi     r22,0x00
            eor     r21,r22 
            breq    echo0               ;wait until TBL1 send complete
            mov     r20,r0              ;put data to rs232
            rcall   TX232
            adiw    r30,0x01
            rjmp    echo  


echo0:      ldi     ZH,high(TBL2*2)     ;get high of pointer of TBL2
            ldi     ZL,low(TBL2*2)      ;get low of pointer  of TBL2          
echo1:      lpm                         ;get data from program memory
            mov     r21,r0 
            ldi     r22,0x00
            eor     r21,r22 
            breq    echo2               ;wait until TBL2 send complete 
            mov     r20,r0              ;put data to rs232
            rcall   TX232 
            adiw    r30,0x01
            rjmp    echo1  

echo2:      ldi     ZH,high(TBL3*2)     ;get high of pointer  of TBL3
            ldi     ZL,low(TBL3*2)      ;get low of pointer  of TBL3          
echo3:      lpm                         ;get data from program memory
            mov     r21,r0 
            ldi     r22,0x00
            eor     r21,r22 
            breq    echo4               ;wait until TBL3 send complete
            mov     r20,r0              ;put data to rs232
            rcall   TX232
            adiw    r30,0x01
            rjmp    echo3  

echo4:      ldi     ZH,high(TBL4*2)     ;get high of pointer of TBL4
            ldi     ZL,low(TBL4*2)      ;get low of pointer of TBL4           
echo5:      lpm                         ;get data from program memory
            mov     r21,r0 
            ldi     r22,0x00
            eor     r21,r22 
            breq    echo6               ;wait until TBL4  send complete 
            mov     r20,r0              ;put data to rs232
            rcall   TX232
            adiw    r30,0x01
            rjmp    echo5  

echo6:      ldi     ZH,high(TBL5*2)     ;get high of pointer of TBL5
            ldi     ZL,low(TBL5*2)      ;get low of pointer of TBL5           
echo7:      lpm                         ;get data from program memory
            mov     r21,r0 
            ldi     r22,0x00
            eor     r21,r22 
            breq    echo8               ;wait until TBL5 send complete 
            mov     r20,r0              ;put data to rs232
            rcall   TX232
            adiw    r30,0x01
            rjmp    echo7  
 
echo8:      rcall   RX232
            rjmp    echo8  
    
TX232:      sbis    USR,UDRE           ;wait until UDRE = 1
            rjmp    TX232 
            out     UDR,r20            ;send data to serial  
            ret 
            
RX232:      sbis    USR,RXC            ;wait until have data in buffer
            rjmp    RX232
            in      r20,UDR            ;read data from buffer
            rcall   TX232  
            ret 
        
CSEG:
TBL1:       .db     0x45,0x54,0x2D,0x41,0x56,0x52,0x20,0x56,0x31,0x2E,0x30,0x0A,0x0D,0x00  
TBL2:       .db     0x54,0x68,0x61,0x6E,0x6B,0x20,0x79,0x6F,0x75,0x20,0x76,0x65,0x72,0x79,0x20,0x6D,0x75,0x63,0x68,0x0A,0x0D,0x00   
TBL3:       .db     0x54,0x68,0x69,0x73,0x20,0x69,0x73,0x20,0x74,0x65,0x73,0x74,0x20,0x52,0x53,0x32,0x33,0x32,0x0A,0x0D,0x00
TBL4:       .db     0x50,0x6C,0x65,0x61,0x73,0x65,0x20,0x61,0x6E,0x79,0x20,0x6B,0x65,0x79,0x20,0x74,0x6F,0x20,0x65,0x00
TBL5:       .db     0x63,0x68,0x6F,0x0A,0x0D,0x00 
                   
                            