;******************************************************
;*             Program Test Serial Port               *
;*             Hardware : CP-S8252  V2.0              *
;*             Complier : SXA51                       *
;******************************************************
            ORG     0000H
            LJMP    MAIN                              ;reset vecter
            ;
DIREC       EQU     P3.2      

MAIN:       MOV     SP,#256-32                        ;define stack = 32 byte
            ;
INIT_SER:   MOV     TMOD,#00100000B                   ;time1 mode2
            MOV     SCON,#01010000B                   ;mode1 serial port
            MOV     TH1,#0FBH
            MOV     A,#00H                            
            MOV     PCON,A                            ;SMOD = 0
            CLR     ET1                               ;clear timer1 interrupt
            SETB    TR1                               ;start timer1
            CLR     ES
            CLR     EA
            ;
            SETB    DIREC

SER:        MOV     DPTR,#TEXT_TAB
            MOV     A,#0
SER1:       PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,TX1
            POP     ACC
            SJMP    TX2
TX1:        LCALL   TX_BYTE
            POP     ACC
            INC     A
            SJMP    SER1

TX2:        LCALL   RX_BYTE
            MOV     DPTR,#TX_TAB
            MOV     A,#00H
TX4:        PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,TX3
            LJMP    TX2
            POP     ACC
TX3:        LCALL   TX_BYTE
            POP     ACC
            INC     A
            SJMP    TX4  
            
;******************************************************
;*                Send 1-Byte to SERIAL               *
;*                Input   : ACC                       *
;*                Output  : Serial port               *
;******************************************************
TX_BYTE:    PUSH   IE
            CLR    TI
            CLR    DIREC
            MOV    SBUF,A
            JNB    TI,$
            CLR    TI
            SETB   DIREC
            POP    IE
            RET

;******************************************************
;*              Receive Data From SERIAL              *
;*              Input   :  Serial Port                *
;*              Output  :  ACC                        *
;******************************************************
RX_BYTE:    PUSH   IE
            JNB    RI,$             ; Wait data
            CLR    RI
            MOV    A,SBUF
            POP    IE
            RET


TEXT_TAB:   DB    0CH,'TEST SERIAL PORT (RS485)',0AH,0DH
            DB    'CP-S8252 (AT89S8252)',0AH,0DH
            DB    'PRESS ANY KEY',0AH,0DH,0AH,0DH,00H

TX_TAB:     DB    'CP-S8252 TX WORD!',0AH,0DH
            DB    '"SYSTEMS COMPLETE"',0AH,0DH
            DB    'THANK YOU VERY MUCH',0AH,0DH,0AH,0DH,00H

            END









