                  ORG    0000H
                  LJMP   MAIN

DATA              EQU    P1.4
LOAD              EQU    P1.3
CLOCK             EQU    P1.5
DSP_BUFF          EQU    22H

MAIN:             MOV    SP,#256-32

                  LCALL  INIT_MAX
LOOP:             MOV    R2,#8
                  MOV    R0,#DSP_BUFF
INIT_DSP:         MOV    A,#0
                  MOV    @R0,A
                  INC    R0
                  DJNZ   R2,INIT_DSP
DIGIT0:           LCALL  DSP_DATA
                  LCALL  DELAY
                  MOV    R0,#DSP_BUFF+0
                  INC    @R0
                  MOV    A,@R0
                  CJNE   A,#0AH,DIGIT0
                  MOV    A,#0
                  MOV    @R0,A
DIGIT1:           MOV    R0,#DSP_BUFF+1
                  INC    @R0
                  MOV    A,@R0
                  CJNE   A,#0AH,DIGIT0
                  MOV    A,#0
                  MOV    @R0,A
DIGIT2:           MOV    R0,#DSP_BUFF+2
                  INC    @R0
                  MOV    A,@R0
                  CJNE   A,#0AH,DIGIT0
                  MOV    A,#0
                  MOV    @R0,A
DIGIT3:           MOV    R0,#DSP_BUFF+3
                  INC    @R0
                  MOV    A,@R0
                  CJNE   A,#0AH,DIGIT0
                  MOV    A,#0
                  MOV    @R0,A
DIGIT4:           MOV    R0,#DSP_BUFF+4
                  INC    @R0
                  MOV    A,@R0
                  CJNE   A,#0AH,DIGIT0
                  MOV    A,#0
                  MOV    @R0,A
DIGIT5:           MOV    R0,#DSP_BUFF+5
                  INC    @R0
                  MOV    A,@R0
                  CJNE   A,#0AH,DIGIT0
                  MOV    A,#0
                  MOV    @R0,A
DIGIT6:           MOV    R0,#DSP_BUFF+6
                  INC    @R0
                  MOV    A,@R0
                  CJNE   A,#0AH,DIGIT0
                  MOV    A,#0
                  MOV    @R0,A
DIGIT7:           MOV    R0,#DSP_BUFF+7
                  INC    R0
                  MOV    A,@R0
                  CJNE   A,#0AH,DIGIT0
                  MOV    A,#0
                  MOV    @R0,A
                  LJMP   LOOP

DSP_DATA:         MOV    R5,#8
                  MOV    R1,#01H
                  MOV    R0,#DSP_BUFF
DSP1:             MOV    A,@R0
                  MOV    DPTR,#TAB_SEG
                  MOVC   A,@A+DPTR
                  MOV    DPH,R1
                  MOV    DPL,A
                  LCALL  SHIFT
                  INC    R0
                  INC    R1
                  DJNZ   R5,DSP1
                  RET

SHIFT:            MOV    R2,#8
                  MOV    A,DPH
                  CLR    C
                  CLR    CLOCK
                  CLR    LOAD
SHIFT1:           RLC    A
                  MOV    DATA,C
                  SETB   CLOCK
                  CLR    CLOCK 
                  DJNZ   R2,SHIFT1
                  MOV    R2,#8
                  MOV    A,DPL
                  CLR    C
SHIFT2:           RLC    A
                  MOV    DATA,C
                  SETB   CLOCK
                  CLR    CLOCK
                  DJNZ   R2,SHIFT2
                  SETB   LOAD
                  CLR    LOAD
                  RET

INIT_MAX:         MOV    DPTR,#0A08H
                  LCALL  SHIFT
                  MOV    DPTR,#0B07H
                  LCALL  SHIFT
                  MOV    DPTR,#0900H
                  LCALL  SHIFT
                  MOV    DPTR,#0C01H
                  LCALL  SHIFT
                  MOV    DPTR,#0F00H
                  LCALL  SHIFT
                  RET

TAB_SEG:          DB    7EH,30H,6DH,79H
                  DB    33H,5BH,5FH,70H              
                  DB    7FH,7BH

DELAY:            MOV   R6,#07H
DEL1:             MOV   R7,#00H
                  DJNZ  R7,$
                  DJNZ  R6,DEL1
                  RET

                  END
                  
