;******************************************************
;*          EXAMPLES TO WRITE EEPROM LTC1298          *
;*  CP-S8252,CP-S53     CONTROL  BOARD                *
;*  MCS-51 (MCU)                                      *
;*  SXA51  ASEMBLER                                   *
;*                                                    *
;*  ETT,.CO LTD       TEL 712 1120-1  www.etteam.com  *
;******************************************************
                         ORG    0000H
                         LJMP   RESET_VEC         ;reset vecter

DATA_BUF:                DS     2                 ;store 2 byte buffer
CHANEL:                  DS     1

CS                       EQU    P3.3              ;chip select
CLK                      EQU    P3.4              ;clock
DIO                      EQU    P3.5              ;data in & data out

RESET_VEC:               MOV    SP,#256-32        ;set stack = 32 byte
                         CLR    EA                ;not used interrupt

INIT_SER:                MOV    TMOD,#00100000B   ;time1 mode2
                         MOV    SCON,#01000000B   ;mode1 serial port
                         MOV    TH1,#0FBH         ;baud 9600 
                         MOV    A,#00H                            
                         MOV    PCON,A            ;SMOD = 0
                         CLR    ET1               ;clear timer1 interrupt
                         SETB   TR1               ;start timer1

                         MOV    A,#0CH            ;clear display (procomm)
                         LCALL  TX_BYTE

                         LCALL  SHOW 
;*******************************************************
;*                 READ DATA FROM LTC1298              *
;* DETAIL IN DATA SHEET                                *
;*******************************************************
                         MOV    CHANEL,#11111111B 
LTC:                     SETB   CS                ;init CS
                         CLR    CS                ;start CS
                         MOV    A,CHANEL          ;ch0/ch1
                         CPL    ACC.5
                         MOV    CHANEL,A
                         MOV    R2,#04H           ;4 bit input data word 
LOOP1:                   RLC    A
                         CLR    CLK               ;clock low
                         MOV    DIO,C             ;data out
                         SETB   CLK               ;clock high
                         DJNZ   R2,LOOP1          ;loop until 4 bit complete
                         SETB   DIO               ;define DIO as input
                         CLR    CLK               
                         MOV    R2,#09H
LOOP2:                   MOV    C,DIO
                         RLC    A
                         SETB   CLK
                         CLR    CLK
                         DJNZ   R2,LOOP2
                         MOV    DATA_BUF+0,A
                         CLR    A
                         MOV    R2,#04H
LOOP3:                   MOV    C,DIO
                         RLC    A
                         SETB   CLK
                         CLR    CLK
                         DJNZ   R2,LOOP3
                         MOV    R2,#04H
LOOP4:                   RRC    A
                         DJNZ   R2,LOOP4
                         MOV    DATA_BUF+1,A
                         SETB   CS

                         MOV    A,DATA_BUF+0
                         SWAP   A
                         ANL    A,#0FH
                         LCALL  HEXASC
                         LCALL  TX_BYTE
                         MOV    A,DATA_BUF+0
                         ANL    A,#0FH
                         LCALL  HEXASC
                         LCALL  TX_BYTE
                         MOV    A,DATA_BUF+1
                         SWAP   A
                         ANL    A,#0FH
                         LCALL  HEXASC
                         LCALL  TX_BYTE
                         MOV    A,CHANEL
                         JNB    ACC.5,SPACE
                         MOV    A,#0DH
                         LCALL  TX_BYTE
                         LJMP   LTC

SPACE:                   MOV    A,#20H
                         LCALL  TX_BYTE
                         MOV    A,#20H
                         LCALL  TX_BYTE
                         MOV    A,#20H
                         LCALL  TX_BYTE
                         MOV    A,#20H
                         LCALL  TX_BYTE
                         LJMP   LTC

;******************************************************
;*                Send 1-Byte to SERIAL               *
;* Input   : ACC                                      *
;* Output  : Serial port                              *
;******************************************************
TX_BYTE:                 PUSH   IE
                         CLR    TI
                         MOV    SBUF,A
                         JNB    TI,$
                         CLR    TI
                         POP    IE
                         RET

;******************************************************
;*              Receive Data From SERIAL              *
;*Input   :  Serial Port                              *
;*Output  :  ACC                                      *
;******************************************************
RX_BYTE:                 PUSH   IE
                         JNB    RI,$             ; Wait data
                         CLR    RI
                         MOV    A,SBUF
                         LCALL  TX_BYTE
                         POP    IE
                         RET

;******************************************************
;*                Convert hex to asci                 *
;* INPUT(HEX) : ACC                                   *
;* OUTPUT(ASC): ACC                                   *
;******************************************************
HEXASC:                  PUSH   DPH
                         PUSH   DPL
                         MOV    DPTR,#HEXASC_TAB
                         MOVC   A,@A+DPTR
                         POP    DPL
                         POP    DPH
                         RET

HEXASC_TAB:              DB     30H,31H,32H,33H,34H,35H,36H,37H
                         DB     38H,39H,41H,42H,43H,44H,45H,46H

;******************************************************
;*              SHOW TEXT FOR START DISPLAY           *
;******************************************************
SHOW:                    PUSH   DPH
                         PUSH   DPL
                         PUSH   ACC
                         MOV    DPTR,#TEXT
                         MOV    A,#0
SHOW2:                   PUSH   ACC
                         MOVC   A,@A+DPTR
                         CJNE   A,#00H,SHOW1
                         POP    ACC
                         LJMP   SHOW3
SHOW1:                   LCALL  TX_BYTE
                         POP    ACC
                         INC    ACC
                         LJMP   SHOW2
SHOW3:                   POP    ACC
                         POP    DPL
                         POP    DPH
                         RET

TEXT:                    DB  'CP-S8252 & CP-S53',0AH,0DH
                         DB  'TEST ADC (LTC1298)',0AH,0DH
                         DB  0AH,0DH 
                         DB  'IF YOU WANT TO TEST LTC1298',0AH,0DH
                         DB  'APPLY VOLTAGE 0-5VDC TO INPUT',0AH,0DH
                         DB  'CH0 & CH1 AND SEE ON DISPLAY',0AH,0DH
                         DB  0AH,0DH
                         DB  'CH0    CH1',0AH,0DH,00H

                         END


















