;******************************************************
;*             Program Test Serial Port               *
;*             Hardware : CP-S8252  V1.0              *
;*             Complier : SXA51                       *
;******************************************************
             ORG     0000H
             LJMP    MAIN                              ;reset vecter
             ;
SCL          EQU     P2.5
SDA          EQU     P2.6
CS_LCD       EQU     P1.3          ; E  LCD (PIN INT1)
RS_LCD       EQU     P1.2          ; RS LCD (Pin T0)

CS           EQU     P2.7           ;chip select
CLK          EQU     P2.5           ;clock
DIO          EQU     P3.7           ;data in & data out

            ;

CONT_BYTE_W  EQU     0A0H
CONT_BYTE_R  EQU     0A1H
RTC_BYTE_W   EQU     0D0H
RTC_BYTE_R   EQU     0D1H

             ORG    25H
ADD_HIGH:    DS     1      
ADD_LOW:     DS     1
DATA:        DS     1
DATA_BUF:    DS     2                 ;store 2 byte buffer
CHANEL:      DS     1

MAIN:       MOV     SP,#256-32                        ;define stack = 32 byte
            CLR     EA
            ;
INIT_PORT:  SETB    SCL
            SETB    SDA

            SETB    CS_LCD        ; initial LCD


INIT_SER:   MOV     TMOD,#00100000B                   ;time1 mode2
            MOV     SCON,#01010000B                   ;mode1 serial port
            MOV     TH1,#0FBH
            MOV     A,#00H                            
            MOV     PCON,A                            ;SMOD = 0
            CLR     ET1                               ;clear timer1 interrupt
            SETB    TR1                               ;start timer1
            CLR     ES
            CLR     EA

;********************************************************
;*                       START RTC                      *
;********************************************************
            MOV     ADD_LOW,#00H
            MOV     DATA,#00H
            LCALL   WRITE_RTC

            ;
SER:        MOV     DPTR,#TEXT_TAB
            MOV     A,#0
SER1:       PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,TX1
            POP     ACC
            SJMP    TX2
TX1:        LCALL   TX_BYTE
            POP     ACC
            INC     A
            SJMP    SER1


TX2:        MOV     DPTR,#LCD_TAB
            LCALL   SHOW 
            LCALL   LCD
            MOV     DPTR,#SEE_TAB
            LCALL   SHOW

            MOV     DPTR,#EE_TAB
            LCALL   SHOW
            LCALL   EEPROM

            MOV     DPTR,#DS_TAB
            LCALL   SHOW
XX:         LCALL   DS1307
            LCALL   LTC1298
            LCALL   RX_BYTEX
            CJNE    A,#'E',XX
            MOV     A,#0AH
            LCALL   TX_BYTE
            MOV     A,#0DH
            LCALL   TX_BYTE
            MOV     DPTR,#EXP34_TAB
            LCALL   SHOW
            LCALL   LOOPX
            SJMP    $



;****************************************************
;*                    show LCD                      *
;****************************************************
LCD:        LCALL   INIT_LCD      ; initial LCD

            MOV     A,#0
            MOV     DPTR,#LCD1_TAB
WRITE1:     PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,WRITE
            POP     ACC
            RET
WRITE:      LCALL   WR_LCD
            POP     ACC
            INC     ACC
            LJMP    WRITE1
            RET
           
;****************************************************
;*                Input  : ACC  (ASCII)             *
;*                Output : Data bus LCD             *
;****************************************************
WR_LCD:     MOV     B,A
            ANL     A,#0F0H
            ORL     A,#00001100B    ;RS/CS HI
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            ORL     A,#00001100B
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WR_INS:     MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.3           ;CS HI
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B    ;else bit
            ORL     A,R2
            MOV     P1,A            ; High byte
            LCALL   EN_LCD
            MOV     A,B             ; Low byte
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.3
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                 Goto position of LCD             *
;*                 Input : ACC (addr.)              *
;****************************************************
GOTO_LCD:   SETB    ACC.7
            LCALL   WR_INS
            RET

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H          ; Set DL = 1 3-time
            LCALL   WR_INS
            MOV     A,#32H          ; Clear DL = 0 1-time
            LCALL   WR_INS
            MOV     A,#28H          ; Function set
            LCALL   WR_INS          ; DL=0 4Bit,N=1 2Line,F=0 5X7
            MOV     A,#0CH
            LCALL   WR_INS          ; Entry display,cursor off,cursor not blink
            MOV     A,#06H          ; Entry mode set
            LCALL   WR_INS          ; I/D=1 Increment,S=0 cursor shift
            MOV     A,#01H          ; Clear display
            LCALL   WR_INS          ; Clear display,set DD RAM address=0
            RET
;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     CLR     CS_LCD          ; Enable LCD
            LCALL   BUSY            ; Busy delay time
            SETB    CS_LCD          ; Disable LCD
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#05H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET

LCD1_TAB:   DB   'CP-S8252/CP-S53',00H


EEPROM:     MOV     ADD_HIGH,#00H
            MOV     ADD_LOW,#00H
            MOV     DATA,#50H
            LCALL   WRITE_BYTE

            MOV     ADD_HIGH,#00H
            MOV     ADD_LOW,#00H
            LCALL   READ_BYTE
            CJNE    A,#50H,EEFAIL
            MOV     DPTR,#PASS_TAB
            LCALL   SHOW
            RET
            MOV     DPTR,#FAIL_TAB
EEFAIL:     LCALL   SHOW
            RET

SHOW:       MOV     A,#0
PASS1:      PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PASS2
            POP     ACC
            RET
PASS2:      LCALL   TX_BYTE
            POP     ACC
            INC     A
            SJMP    PASS1

;*****************************************************
;*            WRITE DATA TO EEPROM 1 BYTE            *
;*INPUT : ADD_HIGH                                   *
;*      : ADD_LOW                                    *
;*      : DATA                                       *
;*****************************************************
WRITE_BYTE: CLR     SDA                    ;start bit
            CLR     SCL
            MOV     A,#CONT_BYTE_W         ;send control byte
            LCALL   LOOP_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            MOV     A,ADD_HIGH              ;send address low
            LCALL   LOOP_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            MOV     A,ADD_LOW              ;send address low
            LCALL   LOOP_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy
            CLR     SCL
            MOV     A,DATA                 ;send data
            LCALL   LOOP_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,WRITE_BYTE         ;loop until busy

            CLR     SDA
            CLR     SCL
            SETB    SCL                    ;stop bit
            SETB    SDA
            LCALL   DELAY4M
            RET

;******************************************************
;*            READ DATA FROM EEPROM 1 BYTE            *
;* INPUT  : ADD_HIGH                                  *
;*        : ADD_LOW                                   *
;* OUTPUT : DATA                                      *
;******************************************************
READ_BYTE:  CLR     SDA                    ;start bit
            CLR     SCL
            MOV     A,#CONT_BYTE_W         ;send control byte
            LCALL   LOOP_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,READ_BYTE          ;loop until busy
            CLR     SCL
            MOV     A,ADD_HIGH              ;send address low
            LCALL   LOOP_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,READ_BYTE         ;loop until busy
            CLR     SCL
            MOV     A,ADD_LOW              ;send address low
            LCALL   LOOP_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,READ_BYTE         ;loop until busy
            CLR     SCL
            SETB    SCL
            SETB    SDA
            CLR     SDA                    ;start bit
            CLR     SCL
            MOV     A,#CONT_BYTE_R         ;send control byte
            LCALL   LOOP_BYTE
            SETB    SDA
            SETB    SCL
            JB      SDA,READ_BYTE          ;loop until busy
            CLR     SCL
            LCALL   LOOP_READ
            SETB    SDA
            SETB    SCL
            CLR     SCL

            SETB    SCL                   ;stop bit
            SETB    SDA
            RET

;****************************************************
;*                      WRITE                       *
;* INPUT: ACC                                       *
;****************************************************
LOOP_BYTE:  PUSH    02H
            MOV     R2,#08H
LOOP_SEND:  RLC     A
            MOV     SDA,C
            SETB    SCL
            CLR     SCL
            DJNZ    R2,LOOP_SEND
            POP     02H
            RET

;*****************************************************
;*                       READ                        *
;* OUTPUT: ACC                                       *
;*****************************************************
LOOP_READ:   PUSH   02H
             MOV    R2,#08H
LOOP_READ1:  SETB   SCL
             MOV    C,SDA
             CLR    SCL
             RLC    A
             DJNZ   R2,LOOP_READ1
             MOV    DATA,A
             POP    02H
             RET

DELAY4M:     PUSH   DPH
             PUSH   DPL
             MOV    DPTR,#0FFF0H
DEL4:        INC    DPTR
             MOV    A,DPL
             ORL    A,DPH
             JNZ    DEL4
             POP    DPL
             POP    DPH
             RET

;*******************************************************
;*                       DS1307                        *
;*******************************************************
DS1307:      MOV     ADD_LOW,#02H
             LCALL   READ_RTC
             LCALL   SHOWASC
             MOV     A,#':'
             LCALL   TX_BYTE
             MOV     ADD_LOW,#01H
             LCALL   READ_RTC
             LCALL   SHOWASC
             MOV     A,#':'
             LCALL   TX_BYTE
             MOV     ADD_LOW,#00H
             LCALL   READ_RTC
             LCALL   SHOWASC
             MOV     A,#20H
             LCALL   TX_BYTE
             MOV     A,#20H
             LCALL   TX_BYTE
             MOV     A,#20H
             LCALL   TX_BYTE
             MOV     A,#20H
             LCALL   TX_BYTE
             MOV     A,#20H
             LCALL   TX_BYTE
             MOV     A,#20H
             LCALL   TX_BYTE
             MOV    A,#20H
             LCALL  TX_BYTE
             MOV    A,#20H
             LCALL  TX_BYTE
             MOV    A,#20H
             LCALL  TX_BYTE
             MOV    A,#20H
             LCALL  TX_BYTE

             RET

SHOWASC:     PUSH    ACC
             SWAP    A
             ANL     A,#0FH
             LCALL   HEXASC
             LCALL   TX_BYTE
             POP     ACC
             ANL     A,#0FH
             LCALL   HEXASC
             LCALL   TX_BYTE
             RET


;*****************************************************
;*            WRITE DATA TO EEPROM 1 BYTE            *
;*INPUT : ADD_HIGH                                   *
;*      : ADD_LOW                                    *
;*      : DATA                                       *
;*****************************************************
WRITE_RTC:   CLR     SDA                    ;start bit
             CLR     SCL
             MOV     A,#RTC_BYTE_W         ;send control byte
             LCALL   LOOP_BYTE
             SETB    SDA
             SETB    SCL
             JB      SDA,WRITE_RTC         ;loop until busy
             CLR     SCL
             MOV     A,ADD_LOW              ;send address low
             LCALL   LOOP_BYTE
             SETB    SDA
             SETB    SCL
             JB      SDA,WRITE_RTC         ;loop until busy
             CLR     SCL
             MOV     A,DATA                 ;send data
             LCALL   LOOP_BYTE
             SETB    SDA
             SETB    SCL
             JB      SDA,WRITE_RTC         ;loop until busy
             CLR     SDA
             CLR     SCL
             SETB    SCL                    ;stop bit
             SETB    SDA
             RET

;*******************************************************
;*                 READ DATA FROM LTC1298              *
;* DETAIL IN DATA SHEET                                *
;*******************************************************
LTC1298:     MOV    CHANEL,#11111111B 
LTC:         SETB   CS                ;init CS
             CLR    CS                ;start CS
             MOV    A,CHANEL          ;ch0/ch1
             CPL    ACC.5
             MOV    CHANEL,A
             MOV    R2,#04H           ;4 bit input data word 
LOOP1:       RLC    A
             CLR    CLK               ;clock low
             MOV    DIO,C             ;data out
             SETB   CLK               ;clock high
             DJNZ   R2,LOOP1          ;loop until 4 bit complete
             SETB   DIO               ;define DIO as input
             CLR    CLK               
             MOV    R2,#09H
LOOP2:       MOV    C,DIO
             RLC    A
             SETB   CLK
             CLR    CLK
             DJNZ   R2,LOOP2
             MOV    DATA_BUF+0,A
             CLR    A
             MOV    R2,#04H
LOOP3:       MOV    C,DIO
             RLC    A
             SETB   CLK
             CLR    CLK
             DJNZ   R2,LOOP3
             MOV    R2,#04H
LOOP4:       RRC    A
             DJNZ   R2,LOOP4
             MOV    DATA_BUF+1,A
             SETB   CS

             MOV    A,DATA_BUF+0
             SWAP   A
             ANL    A,#0FH
             LCALL  HEXASC
             LCALL  TX_BYTE
             MOV    A,DATA_BUF+0
             ANL    A,#0FH
             LCALL  HEXASC
             LCALL  TX_BYTE
             MOV    A,DATA_BUF+1
             SWAP   A
             ANL    A,#0FH
             LCALL  HEXASC
             LCALL  TX_BYTE
             MOV    A,CHANEL
             JNB    ACC.5,SPACE
             MOV    A,#0DH
             LCALL  TX_BYTE
             RET
SPACE:       MOV    A,#20H
             LCALL  TX_BYTE
             MOV    A,#20H
             LCALL  TX_BYTE
             MOV    A,#20H
             LCALL  TX_BYTE
             MOV    A,#20H
             LCALL  TX_BYTE
             LJMP   LTC
             RET

;******************************************************
;*            READ DATA FROM EEPROM 1 BYTE            *
;* INPUT  : ADD_HIGH                                  *
;*        : ADD_LOW                                   *
;* OUTPUT : DATA                                      *
;******************************************************
READ_RTC:    CLR     SDA                    ;start bit
             CLR     SCL
             MOV     A,#RTC_BYTE_W         ;send control byte
             LCALL   LOOP_BYTE
             SETB    SDA
             SETB    SCL
             JB      SDA,READ_RTC          ;loop until busy
             CLR     SCL
             MOV     A,ADD_LOW              ;send address low
             LCALL   LOOP_BYTE
             SETB    SDA
             SETB    SCL
             JB      SDA,READ_RTC         ;loop until busy
             CLR     SCL

             SETB    SCL
             SETB    SDA
             CLR     SDA                    ;start bit
             CLR     SCL
             MOV     A,#RTC_BYTE_R         ;send control byte
             LCALL   LOOP_BYTE
             SETB    SDA
             SETB    SCL
             JB      SDA,READ_RTC          ;loop until busy
             CLR     SCL
             LCALL   LOOP_READ
             SETB    SDA
             SETB    SCL
             CLR     SCL

             SETB    SCL                   ;stop bit
             SETB    SDA
             RET

LOOPX:       MOV     P0,#0FFH
             MOV     P1,#0FFH
             MOV     P2,#0FFH
             MOV     P3,#0FFH
             MOV     R2,#08H
             MOV     A,#0FFH
             CLR     C
LOOPY:       RLC     A
             MOV     P0,A
             LCALL   DELAYY
             DJNZ    R2,LOOPY
             RLC     A
             MOV     P0,A
             MOV     R2,#08H
             MOV     A,#0FFH
             CLR     C
LOOPY1:      RLC     A
             MOV     P1,A
             LCALL   DELAYY
             DJNZ    R2,LOOPY1
             RLC     A
             MOV     P1,A
             MOV     R2,#08H
             MOV     A,#0FFH
             CLR     C
LOOPY2:      RLC     A
             MOV     P2,A
             LCALL   DELAYY
             DJNZ    R2,LOOPY2
             RLC     A
             MOV     P2,A
             MOV     R2,#08H
             MOV     A,#0FFH
             CLR     C
LOOPY3:      RLC     A
             MOV     P3,A
             LCALL   DELAYY
             DJNZ    R2,LOOPY3
             RLC     A
             MOV     P3,A
             SJMP    LOOPX

DELAYY:      PUSH    DPH
             PUSH    DPL
             PUSH    ACC
             MOV     DPTR,#0000H
DELY:        INC     DPTR
             MOV     A,DPL
             ORL     A,DPH
             JNZ     DELY
             POP     ACC
             POP     DPL
             POP     DPH
             RET



HEXASC:      PUSH   DPH
             PUSH   DPL
             MOV    DPTR,#HEXASC_TAB
             MOVC   A,@A+DPTR
             POP    DPL
             POP    DPH
             RET

HEXASC_TAB:  DB     30H,31H,32H,33H,34H,35H,36H,37H,38H,39H
             DB     41H,42H,43H,44H,45H,46H


INIT_TAB:    DB     'CP-S8252 & CP-S53',0AH,0DH
             DB     'TEST DS1307',0AH,0DH
             DB     'HOUSE   MIN    SEC',0AH,0DH,00H


;******************************************************
;*                Send 1-Byte to SERIAL               *
;*                Input   : ACC                       *
;*                Output  : Serial port               *
;******************************************************
TX_BYTE:    PUSH   IE
            CLR    TI
            MOV    SBUF,A
            JNB    TI,$
            CLR    TI
            POP    IE
            RET

;******************************************************
;*              Receive Data From SERIAL              *
;*              Input   :  Serial Port                *
;*              Output  :  ACC                        *
;******************************************************
RX_BYTE:    PUSH   IE
            JNB    RI,$             ; Wait data
            CLR    RI
            MOV    A,SBUF
            POP    IE
            RET

;******************************************************
;*              Receive Data From SERIAL              *
;*              Input   :  Serial Port                *
;*              Output  :  ACC                        *
;******************************************************
RX_BYTEX:   PUSH   IE
            JNB    RI,RXX             ; Wait data
            CLR    RI
            MOV    A,SBUF
RXX:        POP    IE
            RET



TEXT_TAB:   DB    0CH,'PROGRAM TEST CP-S8252',0AH,0DH
            DB    0AH,0DH,00H

LCD_TAB:    DB    'TEST LCD',0AH,0DH,00H

EE_TAB:     DB    'TEST EEPROM (24XX)',0AH,0DH,00H

DS_TAB:     DB    ' DS1307      &     LTC1298    press E test exp34 & exp20'
            DB      0AH,0DH,00H
       
EXP34_TAB:  DB    0AH,0DH,'TEST EXP 34 PIN & EXP 20 PIN',0AH,0DH,00H

RS422_TAB:  DB    'RS422 (75176 2 CHIP)',0AH,0DH,00H
            DB    'press T to test RS422 (75176 2 CHIP',0AH,0DH,00H

RS485_TAB:  DB    'RS485 (75176 1 CHIP)',0AH,0DH,00H
            DB    'prerss T to test RS785 (75176 1 CHIP)',0AH,0DH,00H
 
COMPLE:     DB    'TEST PROGRAM COMPLETE',0AH,0DH,00H

PASS_TAB:   DB    'TEST PASS',0AH,0DH
            DB     0AH,0DH,00H 

FAIL_TAB:   DB    'TEST NOT PASS',0AH,0DH
            DB     0AH,0DH,00H

SEE_TAB:    DB    'SEE OUTPUT',0AH,0DH
            DB     0AH,0DH,00H 

            END









