;****************************************************
;*          Program Test 4 Bits LCD                 *
;*          Dot Matrix TM1620 16X2                  *
;*          HardWare : CP-S8252 & CP-S53 V2.0       *
;*          Complier : SXA51                        *
;****************************************************
            ORG     0000H
            LJMP    MAIN

CS_LCD      EQU     P1.3          ; E  LCD (PIN INT1)
RS_LCD      EQU     P1.2          ; RS LCD (Pin T0)
            ;
MAIN:       MOV     SP,#256-32    ; Initial Stack 32 Byte
            CLR     EA

            SETB    CS_LCD        ; initial LCD

            LCALL   DELAY         ; initial delay

            LCALL   INIT_LCD      ; initial LCD

;****************************************************
;*                    show LCD                      *
;****************************************************
            MOV     A,#0
            MOV     DPTR,#LCD_TAB
WRITE1:     PUSH    ACC
            MOVC    A,@A+DPTR
            CJNE    A,#00H,WRITE
            POP     ACC
            LJMP    $
WRITE:      LCALL   WR_LCD
            POP     ACC
            INC     ACC
            LJMP    WRITE1
            LJMP    $
           
;****************************************************
;*                Input  : ACC  (ASCII)             *
;*                Output : Data bus LCD             *
;****************************************************
WR_LCD:     MOV     B,A
            ANL     A,#0F0H
            ORL     A,#00001100B    ;RS/CS HI
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            MOV     A,B             ;Low byte
            SWAP    A
            ANL     A,#0F0H
            ORL     A,#00001100B
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                Write Instruction LCD             *
;*                Input  : ACC (Command)            *
;*                Output : Data bus LCD             *
;****************************************************
WR_INS:     MOV     B,A
            ANL     A,#0F0H
            SETB    ACC.3           ;CS HI
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B    ;else bit
            ORL     A,R2
            MOV     P1,A            ; High byte
            LCALL   EN_LCD
            MOV     A,B             ; Low byte
            SWAP    A
            ANL     A,#0F0H
            SETB    ACC.3
            MOV     R2,A
            MOV     A,P1
            ANL     A,#00000011B
            ORL     A,R2
            MOV     P1,A
            LCALL   EN_LCD
            RET

;****************************************************
;*                 Goto position of LCD             *
;*                 Input : ACC (addr.)              *
;****************************************************
GOTO_LCD:   SETB    ACC.7
            LCALL   WR_INS
            RET

;****************************************************
;*                      Initial LCD                 *
;*                      4-Bit Interface             *
;****************************************************
INIT_LCD:   CLR     RS_LCD
            MOV     A,#33H          ; Set DL = 1 3-time
            LCALL   WR_INS
            MOV     A,#32H          ; Clear DL = 0 1-time
            LCALL   WR_INS
            MOV     A,#28H          ; Function set
            LCALL   WR_INS          ; DL=0 4Bit,N=1 2Line,F=0 5X7
            MOV     A,#0CH
            LCALL   WR_INS          ; Entry display,cursor off,cursor not blink
            MOV     A,#06H          ; Entry mode set
            LCALL   WR_INS          ; I/D=1 Increment,S=0 cursor shift
            MOV     A,#01H          ; Clear display
            LCALL   WR_INS          ; Clear display,set DD RAM address=0
            RET
;****************************************************
;*                    Enable Pin E LCD              *
;*                    Active Chip select            *
;****************************************************
EN_LCD:     CLR     CS_LCD          ; Enable LCD
            LCALL   BUSY            ; Busy delay time
            SETB    CS_LCD          ; Disable LCD
            RET

;****************************************************
;*                Delay time for Busy               * 
;*                  Wait LCD Ready                  *
;****************************************************
BUSY:       PUSH    07H
            PUSH    06H
            MOV     R6,#05H
BUSY1:      MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,BUSY1
            POP     06H
            POP     07H
            RET

;****************************************************
;*                      Delay Time                  *
;****************************************************
DELAY:      PUSH    07H
            PUSH    06H
DEL1:       MOV     R6,#0FFH
DEL2:       MOV     R7,#0FFH
            DJNZ    R7,$
            DJNZ    R6,DEL2
            POP     06H
            POP     07H
            RET

LCD_TAB:    DB   'CP-S8252/CP-S53',00H

            END

