;*****************************************************
;*          EXAMPLES TO WRITE EEPROM 24XX            *
;*  CP-S8252,CP-S53     BOARD                        *
;*  MCS-51 (MCU)                                     *
;*  SXA51  ASEMBLER                                  *
;*                                                   *
;*  ETT,.CO LTD       TEL 712 1120-1  www.etteam.com *
;*****************************************************
                       ORG    0000H
                       LJMP   RESET_VEC               ;reset vector

RESET_VEC:             MOV     SP,#256-32
                       
LOOPX:                 MOV     P1,#0FFH
                       MOV     P3,#0FFH 
                       MOV     R2,#08H
                       MOV     A,#0FFH
                       CLR     C
LOOP:                  RLC     A
                       MOV     P1,A
                       LCALL   DELAY
                       DJNZ    R2,LOOP
                       RLC     A
                       MOV     P1,A
                       MOV     R2,#06H
                       MOV     A,#0FFH
                       CLR     C
LOOP1:                 RLC     A
                       MOV     P3,A
                       LCALL   DELAY
                       DJNZ    R2,LOOP1
                       SETB    P3.5
                       CLR     P3.7
                       LCALL   DELAY
                       SJMP    LOOPX

DELAY:                 PUSH    DPH
                       PUSH    DPL
                       PUSH    ACC
                       MOV     DPTR,#0000H
DEL:                   INC     DPTR
                       MOV     A,DPL
                       ORL     A,DPH
                       JNZ     DEL
                       POP     ACC
                       POP     DPL
                       POP     DPH
                       RET
                       
                       END














