;*****************************************************
;*          EXAMPLES TO WRITE EEPROM 24XX            *
;*  CP-S8252,CP-S53     BOARD                        *
;*  MCS-51 (MCU)                                     *
;*  SXA51  ASEMBLER                                  *
;*                                                   *
;*  ETT,.CO LTD       TEL 712 1120-1  www.etteam.com *
;*****************************************************
                       ORG    0000H
                       LJMP   RESET_VEC               ;reset vector

SCL                    EQU    P2.5
SDA                    EQU    P2.6

CONT_BYTE_W            EQU    0A0H
CONT_BYTE_R            EQU    0A1H

                       ORG    25H
ADD_HIGH:              DS     1      
ADD_LOW:               DS     1
DATA:                  DS     1

RESET_VEC:             MOV     SP,#256-32

INIT_SER:              MOV     TMOD,#00100000B      ;time1 mode2
                       MOV     SCON,#01000000B      ;mode1 serial port
                       MOV     TH1,#0FBH
                       MOV     A,#00H                            
                       MOV     PCON,A               ;SMOD = 0
                       CLR     ET1                  ;clear timer1 interrupt
                       SETB    TR1                  ;start timer1
                       
INIT_PORT:             SETB    SCL
                       SETB    SDA

                       MOV     A,#0CH
                       LCALL   TX_BYTE
                       MOV     DPTR,#INIT_TAB
                       MOV     A,#00H
INIT0:                 PUSH    ACC
                       MOVC    A,@A+DPTR
                       CJNE    A,#00H,INIT1
                       LJMP    INIT2
INIT1:                 LCALL   TX_BYTE
                       POP     ACC
                       INC     A 
                       SJMP    INIT0

INIT2:                 MOV     A,#' '
                       LCALL   TX_BYTE
                       MOV     A,#35H
                       LCALL   TX_BYTE
                       MOV     A,#30H
                       LCALL   TX_BYTE
                       MOV     A,#' '
                       LCALL   TX_BYTE
                       MOV     A,#' '
                       LCALL   TX_BYTE
                       MOV     A,#' '
                       LCALL   TX_BYTE
                       MOV     A,#' '
                       LCALL   TX_BYTE
                       MOV     A,#' '
                       LCALL   TX_BYTE

                       MOV     ADD_HIGH,#00H
                       MOV     ADD_LOW,#00H
                       MOV     DATA,#50H
                       LCALL   WRITE_BYTE

                       MOV     ADD_HIGH,#00H
                       MOV     ADD_LOW,#00H
                       LCALL   READ_BYTE
                       LCALL   SHOWASC

                       MOV     A,#0DH
                       LCALL   TX_BYTE
                       LJMP    $

SHOWASC:               PUSH    ACC
                       SWAP    A
                       ANL     A,#0FH
                       LCALL   HEXASC
                       LCALL   TX_BYTE
                       POP     ACC
                       ANL     A,#0FH
                       LCALL   HEXASC
                       LCALL   TX_BYTE
                       RET


;*****************************************************
;*            WRITE DATA TO EEPROM 1 BYTE            *
;*INPUT : ADD_HIGH                                   *
;*      : ADD_LOW                                    *
;*      : DATA                                       *
;*****************************************************
WRITE_BYTE:            CLR     SDA                    ;start bit
                       CLR     SCL
                       MOV     A,#CONT_BYTE_W         ;send control byte
                       LCALL   LOOP_BYTE
                       SETB    SDA
                       SETB    SCL
                       JB      SDA,WRITE_BYTE         ;loop until busy
                       CLR     SCL
                       MOV     A,ADD_HIGH              ;send address low
                       LCALL   LOOP_BYTE
                       SETB    SDA
                       SETB    SCL
                       JB      SDA,WRITE_BYTE         ;loop until busy
                       CLR     SCL
                       MOV     A,ADD_LOW              ;send address low
                       LCALL   LOOP_BYTE
                       SETB    SDA
                       SETB    SCL
                       JB      SDA,WRITE_BYTE         ;loop until busy
                       CLR     SCL
                       MOV     A,DATA                 ;send data
                       LCALL   LOOP_BYTE
                       SETB    SDA
                       SETB    SCL
                       JB      SDA,WRITE_BYTE         ;loop until busy

                       CLR     SDA
                       CLR     SCL
                       SETB    SCL                    ;stop bit
                       SETB    SDA
                       LCALL   DELAY4M
                       RET

;******************************************************
;*            READ DATA FROM EEPROM 1 BYTE            *
;* INPUT  : ADD_HIGH                                  *
;*        : ADD_LOW                                   *
;* OUTPUT : DATA                                      *
;******************************************************
READ_BYTE:             CLR     SDA                    ;start bit
                       CLR     SCL
                       MOV     A,#CONT_BYTE_W         ;send control byte
                       LCALL   LOOP_BYTE
                       SETB    SDA
                       SETB    SCL
                       JB      SDA,READ_BYTE          ;loop until busy
                       CLR     SCL
                       MOV     A,ADD_HIGH              ;send address low
                       LCALL   LOOP_BYTE
                       SETB    SDA
                       SETB    SCL
                       JB      SDA,READ_BYTE         ;loop until busy
                       CLR     SCL
                       MOV     A,ADD_LOW              ;send address low
                       LCALL   LOOP_BYTE
                       SETB    SDA
                       SETB    SCL
                       JB      SDA,READ_BYTE         ;loop until busy
                       CLR     SCL
                       SETB    SCL
                       SETB    SDA
                       CLR     SDA                    ;start bit
                       CLR     SCL
                       MOV     A,#CONT_BYTE_R         ;send control byte
                       LCALL   LOOP_BYTE
                       SETB    SDA
                       SETB    SCL
                       JB      SDA,READ_BYTE          ;loop until busy
                       CLR     SCL
                       LCALL   LOOP_READ
                       SETB    SDA
                       SETB    SCL
                       CLR     SCL

                       SETB    SCL                   ;stop bit
                       SETB    SDA
                       RET

;****************************************************
;*                      WRITE                       *
;* INPUT: ACC                                       *
;****************************************************
LOOP_BYTE:             PUSH    02H
                       MOV     R2,#08H
LOOP_SEND:             RLC     A
                       MOV     SDA,C
                       SETB    SCL
                       CLR     SCL
                       DJNZ    R2,LOOP_SEND
                       POP     02H
                       RET

;*****************************************************
;*                       READ                        *
;* OUTPUT: ACC                                       *
;*****************************************************
LOOP_READ:             PUSH   02H
                       MOV    R2,#08H
LOOP_READ1:            SETB   SCL
                       MOV    C,SDA
                       CLR    SCL
                       RLC    A
                       DJNZ   R2,LOOP_READ1
                       MOV    DATA,A
                       POP    02H
                       RET

DELAY4M:               PUSH   DPH
                       PUSH   DPL
                       MOV    DPTR,#0FFF0H
DEL4:                  INC    DPTR
                       MOV    A,DPL
                       ORL    A,DPH
                       JNZ    DEL4
                       POP    DPL
                       POP    DPH
                       RET

;******************************************************
;*                Send 1-Byte to SERIAL               *
;*                Input   : ACC                       *
;*                Output  : Serial port               *
;******************************************************
TX_BYTE:               PUSH   IE
                       CLR    TI
                       MOV    SBUF,A
                       JNB    TI,$
                       CLR    TI
                       POP    IE
                       RET

;******************************************************
;*              Receive Data From SERIAL              *
;*              Input   :  Serial Port                *
;*              Output  :  ACC                        *
;******************************************************
RX_BYTE:               PUSH   IE
                       JNB    RI,$             ; Wait data
                       CLR    RI
                       MOV    A,SBUF
                       LCALL  TX_BYTE
                       POP    IE
                       RET


HEXASC:                PUSH   DPH
                       PUSH   DPL
                       MOV    DPTR,#HEXASC_TAB
                       MOVC   A,@A+DPTR
                       POP    DPL
                       POP    DPH
                       RET

HEXASC_TAB:            DB     30H,31H,32H,33H,34H,35H,36H,37H,38H,39H
                       DB     41H,42H,43H,44H,45H,46H


INIT_TAB:              DB     'CP-S8252 & CP-S53',0AH,0DH
                       DB     'TEST 24XX',0AH,0DH
                       DB     'WRITE & READ',0AH,0DH,00H

                       END














