;**********************************************
; test internal ADC   of PIC16F877
; Hardware  : CP-PIC877 V1.0 & V2.0
; Assembler : mpasm.exe
; Programmer: Somkiat siha
; Company   : ETT  CO.,LTD.
; Date      : 5/2/2000
;**********************************************
; PORTC = 8 bits lower
; PORTB = 2 bits upper 


     list p=16f877                 ; list directive to define processor
     #include <p16f877.inc>        ; processor specific variable definitions


COUNT1	EQU	0x70
COUNT2    EQU   0x71

;***********************************
          ORG  0x000          

          bsf          STATUS,RP0     ;
          bcf          STATUS,RP1     ; select bank 1
          clrf         ADCON1 
          bsf          ADCON1,7       ; ADFM = 1, AN0-AN7 is analog input
          clrf         TRISC          ; port c is output
          clrf         TRISB          ; port b is output
          bcf          STATUS,RP0     ; select bank 0

          movlw        10000001
          movwf        ADCON0         ; Clock=Fosc/32, ADC operate, Channel 0

;************ start conversion  ****************

bbb       bsf          ADCON0,2       ; start conversion
Loop      btfsc        ADCON0,2       
          goto         Loop           ; DONE = 1
                                      ; DONE = 0
          bsf          STATUS,RP0     ;select  bank 1
          movf         ADRESL,w       ; read lower 8 bit
          bcf          STATUS,RP0     ;select bank 0
          movwf        PORTC          ; send to Port C
          movf         ADRESH,w       ; read to
          movwf        PORTB          ; send to Port B
          goto         bbb

          END            ; directive 'end of program'

