;**********************************************
; Test write and read RTC DS1307
; Hardware  : CP-PIC877 V1.0 & V2.0
; Assembler : mpasm.exe
; Programmer: Somkiat Siha
; Company   : ETT  CO.,LTD.
; Date      : 3/3/2000
;**********************************************

     LIST P=16f877
     include <p16f877.inc>

#define        SDA  PORTC,4
#define        SCL  PORTC,3

dt1       EQU       0x20
dt2       EQU       0x21
dt3       EQU       0x22
XBUF      EQU       0x23
count     EQU       0x24
CONTROL   EQU       0x25
ADD       EQU       0x27
DAT       EQU       0x28
flag      EQU       0x29
DOUT      EQU       0x30
B1        EQU       0x31
B2        EQU       0x32


;*********************************************
          ORG       0x0000
          bsf       STATUS,RP0     ; select bank 1
          bcf       TRISC,4
          bcf       TRISC,3
          movlw     0x19           ; BAUD rate 2400
          movwf     SPBRG
          clrf      TXSTA          ; 8 bits data ,no,1 stop
          bsf       TXSTA,TXEN     ; Transmit enable
          bcf       STATUS,RP0     ; select bank 0
          clrf      RCSTA
          bsf       RCSTA,SPEN     ; Asynchronous serial port enable
          bsf       RCSTA,CREN     ; continuous receive

          movlw     0x0            ; Write SECOND to address 00
          movwf     ADD
          movlw     0x0            ;  Start second = 00
          movwf     DAT
          call      wr             ; call write sub
          call      SDel           ; delay more than 10 mS

st        movlw     0x0C           ; Clear display
          call      SEND
          movlw     "M"
          call      SEND
          movlw     "I"
          call      SEND
          movlw     "N"
          call      SEND
          movlw     " "
          call      SEND
          movlw     " "
          call      SEND
          movlw     "S"
          call      SEND
          movlw     "E"
          call      SEND
          movlw     "C"
          call      SEND
          movlw     0xA             ; new line
          call      SEND
          movlw     0xD
          call      SEND

          movlw     0x01            ; Read minute
          movwf     ADD
          call      rd              ; call read sub
          movf      DOUT,w
          call      ADJT            ; display minute

          movlw     " "
          call      SEND
          movlw     " "
          call      SEND
          movlw     " "
          call      SEND

          movlw     0x00            ; Read second
          movwf     ADD
          call      rd              ; call read sub
          movf      DOUT,w
          call      ADJT            ; display second

          call      SDel
          goto      st

;**********************************************************
; Convert time 1 byte to ASCII 2 bytes and send to display
; Input  : W
; Output : -
;**********************************************************
ADJT      movwf     B1             ; B1 = HHHH LLLL
          swapf     B1,w           ; W  = LLLL HHHH
          andlw     0x0f           ; Mask upper four bits 0000 HHHH
          addlw     0x30           ; convert to ASCII
          call      SEND           ; Send first digit
          movf      B1,w
          andlw     0x0f           ; w  = 0000 LLLL
          addlw     0x30           ; convert to ASCII
          call      SEND
          return

;********************************************************
; Send data to RS-232 2400 Buad,8 bits data, No parity, 1 stop
; Input  : W
; Output : Computer screen
;********************************************************
SEND      movwf     TXREG          ; Send recent data to TX 
wait1     movlw     TXSTA
          movwf     FSR
          btfss     INDF,1         ; check TRMT bit in TXSTA register
          goto      wait1          ; TXREG full  or TRMT = 0
          return

;************************************
; Write data
; Input   : ADD,DAT
; Output  : EEPROM
;************************************
wr        bcf       SDA
          bcf       SCL
          call      start
          movlw     0xD0      ; Control data & slave address 00H
          movwf     XBUF
          call      TB
          movlw     TRISC
          movwf     FSR
          bsf       INDF,4    ; SDA input (hi)
          bsf       SCL       ; clock hi  9th
          btfsc     SDA
          goto      wr
          bcf       SCL       ; clock lo  9th
          call      losda

          movf      ADD,w
          movwf     XBUF
          call      TB
          movlw     TRISC
          movwf     FSR
          bsf       INDF,4    ; SDA input (hi)
          bsf       SCL       ; clock hi  9th
          btfsc     SDA
          goto      wr
          bcf       SCL       ; clock lo  9th
          call      losda

          movf      DAT,w
          movwf     XBUF
          call      TB
          movlw     TRISC
          movwf     FSR
          bsf       INDF,4    ; SDA input (hi)
          bsf       SCL       ; clock hi  9th
          btfsc     SDA
          goto      wr
          bcf       SCL       ; clock lo  9th
          call      losda
          bsf       SCL
          nop
          nop
          nop
          nop
          bsf       SDA       ; stop bit
          return
;************************************
; Read data
; Input   : ADD
; Output  : DOUT
;************************************
rd        clrf      DOUT      ; DOUT = 0
          movlw     TRISC
          movwf     FSR
          bcf       INDF,3
          bcf       INDF,4
          bcf       SDA
          bcf       SCL
          call      start
          movlw     0xD0      ; Control data & slave address 00H
          movwf     XBUF
          call      TB
          movlw     TRISC
          movwf     FSR
          bsf       INDF,4    ; SDA input (hi)
          bsf       SCL       ; clock hi  9th
          btfsc     SDA
          goto      rd
          bcf       SCL       ; clock lo  9th
          call      losda

          movf      ADD,w
          movwf     XBUF
          call      TB
          movlw     TRISC
          movwf     FSR
          bsf       INDF,4    ; SDA input (hi)
          bsf       SCL       ; clock hi  9th
          btfsc     SDA
          goto      rd
          bcf       SCL       ; clock lo  9th
          call      losda

          bsf       SCL
          bsf       SDA       ; stop bit
          bcf       SDA
          bcf       SCL       ; start bit
          movlw     0xD1      ; Control read
          movwf     XBUF
          call      TB
          movlw     TRISC
          movwf     FSR
          bsf       INDF,4    ; SDA input (hi)
          bsf       SCL       ; clock hi  9th
          btfsc     SDA
          goto      rd
          bcf       SCL       ; clock lo  9th
          call      losda

          bcf       STATUS,C       ; clear carry flag
          movlw     8
          movwf     count          ; counter = 8 (bits)
          movlw     TRISC
          movwf     FSR
          bsf       INDF,4         ; SDA input
;************* Read bit *****************************
N4        bsf       SCL            ; clock hi
          btfss     TRISC,4
          goto      N5             ; Din = 0

          bsf       DOUT,0         ; Din = 1
N5        rlf       DOUT,f         ; shift left 1 bit
          bcf       SCL            ; clock lo
          decfsz    count,f
          goto      N4
          rrf       DOUT,f         ; shift data to right 1 bit

          bcf       INDF,4         ; SDA output (lo)
          bsf       INDF,4         ; SDA hi
          bsf       SCL            ; clock hi
          bcf       SCL            ; clock lo
          bsf       SCL            ; clock hi
          bsf       INDF,4         ; SDA hi
          return

;********************************
; SDA low
;********************************
losda     bcf       SDA
          movlw     TRISC
          movwf     FSR
          bcf       INDF,4    ; SDA lo
          return

;******************************
;   Send bit
;   Input  : XBUF
;   Output : EEPROM
;******************************
TB        bcf       STATUS,C       ; clear carry flag
          movlw     8
          movwf     count          ; counter = 0000 1000
N1        rlf       XBUF,f         ; Shift data to Carry flag
          btfsc     STATUS,C
          goto      N2             ; data bit = 1
          goto      N3             ; data bit = 0
N2        movlw     TRISC
          movwf     FSR
          bsf       INDF,4         ; SDA hi
N3        bsf       SCL
          bcf       SCL
          bcf       SDA            ; SDA lo
          movlw     TRISC
          movwf     FSR
          bcf       INDF,4         ; SDA output
          decfsz    count,f        ; Dec count 1, skip next instruction if count=0
          goto      N1             ; count <> 0
          return

;******************************
; Start bit
;******************************
start     bsf       STATUS,RP0     ; select bank 1
          bsf       TRISC,3        ; SDA = hi
          bsf       TRISC,4        ; SCL = hi
          bcf       STATUS,RP0     ; select bank 0
          nop
          nop
          nop
          nop
          bsf       STATUS,RP0     ; select bank 1
          bcf       TRISC,4        ; SDA lo
          nop
          nop
          nop
          nop
          bcf       TRISC,3        ; SCL lo
          bcf       STATUS,RP0     ; select bank 0
          return

;******************************
; Short delay
;******************************
SDel      movlw     0x00
          movwf     dt1
sd2       movlw     0x00
          movwf     dt2
sd1       decfsz    dt2
          goto      sd1
          decfsz    dt1
          goto      sd2
          return

          end
;****************** END OF PROGRAM ************************




