;**************************************
; Test RS485
; Hardware  : CP-PIC877 V1.0 & V2.0
; Assembler : mpasm.exe
; Programmer: Somkiat Siha
; Company   : ETT  CO.,LTD.
; Date      : 29/2/2000
;**************************************


     list p=16f877                 ; list directive to define processor
     #include <p16f877.inc>        ; processor specific variable definitions

#define   DIR  PORTC,5        ; Direction
count1    EQU  0x70
count2    EQU  0x71
temp      EQU  0x72

          ORG       0x0000
          goto      init

          ORG       0x0004
          movlw     0x0f
          movwf     PORTD
          goto      $
          retfie

;************ initial *******************
init      bcf       PORTC,5
          bsf       STATUS,RP0     ; select bank 1
          bcf       TRISC,5        ; Direction control
          movlw     0x19           ; BAUD rate 2400
          movwf     SPBRG          ;
          clrf      TRISD          ; PortD output
          bcf       STATUS,RP0     ; select bank 0

          movlw     TXSTA
          movwf     FSR
          bsf       INDF,5

          clrf      RCSTA
          bsf       RCSTA,SPEN      ; Serial port enabled
          bsf       RCSTA,CREN      ; continuous receive
          bcf       DIR
;********** start to receive ************

wait1     btfss     PIR1,RCIF       ; Check RCIF  bit in PIR1 register
          goto      wait1           ; RCREG emty or RCIF = 0
          movf      RCREG,w         ; RCREG full or RCIF = 1
          movwf     temp
          bsf       DIR             ; Dir =  TX
          movf      temp,w
          movwf     TXREG
wait4     movlw     TXSTA           ;
          movwf     FSR             ;
          btfss     INDF,1          ; TSR = empty ?
          goto      wait4           ; NO  (TRMT = 0) ,TSR full
                                    ; Yes (TRMT = 1) ,TSR empty
          call      delay
          call      delay
          bsf       DIR             ; Dir = RX                      
          goto      wait1
;***********************************************
; Delay
;***********************************************
delay     movlw     0xff
          movwf     count1
del2      movlw     0xff
          movwf     count2
del1      decfsz    count2
          goto      del1
          decfsz    count1
          goto      del2
          return

          END
