;**************************************
; Test internal EEPROM
; Hardware  : CP-PIC877 V1.0 & V2.0
; Assembler : mpasm.exe
; Programmer: Somkiat Siha
; Company   : ETT  CO.,LTD.
; Date      : 29/2/2000
;**************************************

     list p=16f877            ; list directive to define processor
     #include <p16f877.inc>        ; processor specific variable definitions

          ORG       0x0000

MAIN      bsf       STATUS,RP0       ; select bank 1
          clrf      TRISC                 ; All PORTC is output
          bcf       STATUS,RP0        ; select bank 0
;******************** Write **********************
          bsf       STATUS,RP1        ; select bank 2
          movlw     100                     ; ADDRESS to write
          movwf     EEADR
          movlw     0x55                   ; DATA    to write
          movwf     EEDATA
          bsf       STATUS,RP0        ; select bank 3
          bcf       EECON1,EEPGD   ; Point to DATA memory
          bsf       EECON1,WREN    ; Enable writes
          movlw     0x55
          movwf     EECON2                    ; Write 55H
          movlw     0xAA
          movwf     EECON2                    ; Wirte AAH
          bsf       EECON1,WR             ; Set WR bit to begin write
          bcf       EECON1,WREN       ; Disable writes
;**************** Read ************************
          bsf       STATUS,RP1
          bcf       STATUS,RP0         ; select bank 2
          movlw     100
          movwf     EEADR                ; Address to read
          bsf       STATUS,RP0         ; select bank 3
          bcf       EECON1,EEPGD    ; Point to DATA memory
          bsf       EECON1,RD          ; EEPROM read
          bcf       STATUS,RP0         ; select bank 2
          movf      EEDATA,W            ; read data to W
          bcf       STATUS,RP0
          bcf       STATUS,RP1          ; select bank 0
          movwf     PORTC                 ; out data to PORTC
LOOP      goto      LOOP
          End
