;/********************************/;
;/* Monitor For : CP89C51 V1.0   */;
;/* Files Name  : DEMO_TMP.ASM   */;
;/* CPU Control : AT89C51        */;
;/* Assembler   : SXA51          */;
;/* (Test System & I/O on Board) */;
;/********************************/;
;
;/* Digital Thermometer (DS1820)
DQ_TEMP     EQU     P3.4                    ; Data I/O of DS1820

            ORG     20H                             ; Internal RAM of CPU
CRC:        DS      1
TEMP_BUF:   DS      9
STACK:      DS      32
            ;
            ORG     0000H                   ; Reset Vector of CPU
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     TMOD,#00100001B         ; Timer1(8Bit-Auto) & Timer0(16Bit)
            MOV     SCON,#01010000B         ; Serial Port Mode 1
            SETB    PS                      ; Serial Interupt High Piority
            CLR     ES                      ; Disable Serial Interupt
            CLR     ET0                     ; Disable Timer0 Interupt
            CLR     ET1                     ; Disable Timer1 Interupt
            MOV     A,#0FDH                 ; Set Baudrate 9600
            MOV     TH1,A
            MOV     TL1,A
            SETB    TR0                     ; Start Timer0
            SETB    TR1                     ; Start Timer1
            SETB    EA                      ; Enable Global Interupt

;/***************/;
;/* Test DS1820 */;
;/***************/;
;
GET_TEMP:   MOV     A,#0DH
            LCALL   TX_BYTE
            ;
            LCALL   TOUCHRESET              ; Initial Device DS1820
            JC      GET_TMP1                ; Device Pass
            LCALL   TOUCHRESET              ; Initial Again
            JC      GET_TMP1
            SJMP    GET_TEMP                ; Device Fail
            ;
GET_TMP1:   MOV     A,#0CCH                 ; Skip Rom command
            LCALL   TOUCHBYTE
            MOV     A,#44H                  ; Conversion Tempurature
            LCALL   TOUCHBYTE               ; Send command
            ;
            MOV     B,#255                  ; Wait 500 mSec For Convert
            LCALL   DLY_MSEC
            MOV     B,#255
            LCALL   DLY_MSEC
            ;
            LCALL   TOUCHRESET              ; Initial device
            MOV     A,#0CCH                 ; Skip Rom command
            LCALL   TOUCHBYTE               ; Send command
            MOV     B,#9                    ; Read 9 Byte
            LCALL   READ_1820               ; Read Scratch Pad Memroy
            ;
            MOV     R0,#TEMP_BUF            ; Buffer CRC Check
            MOV     R1,#8                   ; 8-Byte CRC Check
            LCALL   GEN_CRC
            MOV     A,CRC
            XRL     A,TEMP_BUF+8
            JZ      GET_TMP2
            SJMP    GET_TEMP                ; CRC Error
            ;
GET_TMP2:   MOV     A,TEMP_BUF+1            ; Tempurature Buffer (MSB Temp)
            CJNE    A,#00H,GET_TMP3
            SJMP    GET_TMP4                ; 00c...+125c
            ;
GET_TMP3:   MOV     A,#'-'                  ; Temp = -0.5c...55c
            LCALL   TX_BYTE
            MOV     A,TEMP_BUF+0
            CPL     A
            INC     A
            SJMP    GET_TMP5
            ;
GET_TMP4:   MOV     A,#'+'                  ; Temp = +00c...125c
            LCALL   TX_BYTE
            MOV     A,TEMP_BUF+0            ; Temperature Buffer (LSB Temp)
GET_TMP5:   CLR     CY
            RRC     A                       ; Divide By 2
            ;
            MOV     DPTR,#TEMP_TAB
            MOVC    A,@A+DPTR               ; Get Temp Value
            ;
            PUSH    PSW
            LCALL   TX_2ASC
            MOV     A,#'.'
            LCALL   TX_BYTE
            POP     PSW
            ;
            JNC     GET_TMP6
            MOV     A,#'5'
            LCALL   TX_BYTE
            LJMP    GET_TEMP
            ;
GET_TMP6:   MOV     A,#'0'
            LCALL   TX_BYTE
            LJMP    GET_TEMP


;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial port */;
;/*************************/;
;
TX_BYTE:    MOV     SBUF,A
            JNB     TI,$                    ; Wait TX Data Ready
            CLR     TI
            RET

;/************************/;
;/* Convert ASCII to HEX */;
;/* Input  : ACC (ASCII) */;
;/* Output : ACC (HEX)   */;
;/************************/;
;
ASC_HEX:    PUSH    PSW
            CJNE    A,#41H,ASC_HEX1         ; "A"
ASC_HEX1:   JC      ASC_HEX3                ; 30H-39H Jump
ASC_HEX2:   ADD     A,#09H                  ; A-F(ASCII) ==> A-F(Hex)
ASC_HEX3:   ANL     A,#00001111B            ; Convert ASCII to HEX
            POP     PSW
            RET

;/************************/;
;/* Send 2 byte of ASCII */;
;/* Input : ACC (HEX)    */;
;/* Exam. : A = A3H      */;
;/*       : Send 41H,33H */;
;/************************/;
;
TX_2ASC:    LCALL   HEX_2ASC
            LCALL   TX_BYTE
            MOV     A,B
            LCALL   TX_BYTE
            RET

;/****************************/;
;/* Convert 1-HEX to 2-ASCII */;
;/* Input  : ACC (Hex)       */;
;/* Output : ACC (High-Byte) */;
;/*        : B   (Low-Byte)  */;
;/* Exam A = 41H => 34H,31H  */;
;/****************************/;
;
HEX_2ASC:   PUSH    ACC
            LCALL   HEX_ASC
            MOV     B,A                     ; B = Lo byte
            POP     ACC
            SWAP    A
            LCALL   HEX_ASC                 ; A = High Byte
            RET

;/*****************************/;
;/* Convert Hex(0-F) to ASCII */;
;/* Input  : ACC (HEX code)   */;
;/* Output : ACC (ASCII code) */;
;/*****************************/;
;
HEX_ASC:    PUSH    PSW
            CLR     CY
            ANL     A,#00001111B
            CJNE    A,#09H,HEX_ASC1
            SETB    CY
HEX_ASC1:   JNB     CY,HEX_ASC2             ; > 0AH
            ORL     A,#30H                  ; < 0AH
            SJMP    HEX_ASC3
HEX_ASC2:   SUBB    A,#09H                  ; > 0AH
            ORL     A,#40H
HEX_ASC3:   POP     PSW
            RET

;/*************************************/;
;/* Generate CRC for consecutive data */;
;/* Input  : R0 = Pointed to buffer   */;
;/*        : R1 = Byte count.         */;
;/*************************************/;
;
GEN_CRC:    MOV     CRC,#0
CHCRC1:     MOV     A,@R0
            LCALL   DO_CRC
            INC     R0
            DJNZ    R1,CHCRC1
            RET

;/*******************************/;
;/*     CRC check (8 bit CRC)   */;
;/* Input  : ACC = Data to cal. */;
;/* Output : CRC (internal ram) */;
;/*******************************/;
;
DO_CRC:     PUSH    ACC
            MOV     B,#8
CRC_LOOP:   XRL     A,CRC
            RRC     A
            MOV     A,CRC
            JNC     ZERO
            XRL     A,#18H
ZERO:       RRC     A
            MOV     CRC,A
            POP     ACC
            RR      A
            PUSH    ACC
            DJNZ    B,CRC_LOOP
            POP     ACC
            RET

;/*************************************/;
;/* Read Scratchpad Memory & CRC Byte */;
;/* Input  : B (Counter of Byte Read) */;
;/*        : Read From Addr 0..Reg-B  */;
;/* Output : TEMP_BUF                 */;
;/*************************************/;
;
READ_1820:  MOV     A,#0BEH                 ; Read scratchpad command
            LCALL   TOUCHBYTE               ; Send commnad
RD_SCRAT:   MOV     R2,B                    ; Prepare buffer
            MOV     R0,#TEMP_BUF
RDSCT2:     MOV     R1,#8
            CLR     A
RDSCT1:     CLR     DQ_TEMP                 ; Start
            MOV     B,#8
            DJNZ    B,$                     ; Still low
            SETB    DQ_TEMP                 ; DQ_TEMP=hi
            NOP
            NOP
            MOV     C,DQ_TEMP               ; Read data bit
            RRC     A                       ; Store in ACC
            MOV     B,#100
RDSCT4:     MOV     C,DQ_TEMP
            JC      RDSCT3
            DJNZ    B,RDSCT4
RDSCT3:     NOP
            NOP
            NOP
            DJNZ    R1,RDSCT1               ; Next bit
            MOV     @R0,A                   ; Save byte in buffer
            INC     R0                      ; Advance pointer
            DJNZ    R2,RDSCT2               ; Next address
            LCALL   TOUCHRESET
            RET

;/*********************************/;
;/* DS1820 Reset & Precence pulse */;
;/* Output : Carry flags set if   */;
;/*          found precence pulse */;
;/*********************************/;
;
TOUCHRESET: PUSH    B
            PUSH    ACC
            MOV     A,#4
            CLR     DQ_TEMP
            MOV     B,#221                  ; Delay 480-960uS
            DJNZ    B,$
            SETB    DQ_TEMP
            MOV     B,#6
            CLR     C
WAITLOW:    JB      DQ_TEMP,WH
            DJNZ    B,WAITLOW
            DJNZ    ACC,WAITLOW
            SJMP    SHORT
WH:         MOV     B,#111                  ; Delay 60-240uS
HL:         ORL     C,/DQ_TEMP
            DJNZ    B,HL
SHORT:      POP     ACC
            POP     B
            RET

;/************************/;
;/* Write Byte to DS1820 */;
;/* Input : ACC          */;
;/************************/;
;
TOUCHBYTE:  PUSH    B
            MOV     B,#8
BIT_LOOP:   RRC     A
            ACALL   TOUCHBIT
            DJNZ    B,BIT_LOOP
            RRC     A
            POP     B
            RET
            ;
TOUCHBIT:   CLR     DQ_TEMP
            NOP
            NOP
            NOP
            NOP
            MOV     DQ_TEMP,C
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            MOV     C,DQ_TEMP
            PUSH    B
            MOV     B,#12
            DJNZ    B,$
            POP     B
            SETB    DQ_TEMP
            RET

;/***************************/;
;/* Table Result Temp 00-99 */;
;/***************************/;
;
TEMP_TAB:   DB      00H,01H,02H,03H,04H
            DB      05H,06H,07H,08H,09H
            DB      10H,11H,12H,13H,14H
            DB      15H,16H,17H,18H,19H
            DB      20H,21H,22H,23H,24H
            DB      25H,26H,27H,28H,29H
            DB      30H,31H,32H,33H,34H
            DB      35H,36H,37H,38H,39H
            DB      40H,41H,42H,43H,44H
            DB      45H,46H,47H,48H,49H
            DB      50H,51H,52H,53H,54H
            DB      55H,56H,57H,58H,59H
            DB      60H,61H,62H,63H,64H
            DB      65H,66H,67H,68H,69H
            DB      70H,71H,72H,73H,74H
            DB      75H,76H,77H,78H,79H
            DB      80H,81H,82H,83H,84H
            DB      85H,86H,87H,88H,89H
            DB      90H,91H,92H,93H,94H
            DB      95H,96H,97H,98H,99H

;/*************************/;
;/*  Delay Time : 1 mSec  */;
;/* Input : B=Time (mSec) */;
;/*************************/;
;
DLY_MSEC:   MOV     DPTR,#65536-152     ; 1 Milli Second Count
DLY_MSEC1:  INC     DPTR
            MOV     A,DPH
            ORL     A,DPL
            JNZ     DLY_MSEC1
            RET

            END





            


