;/******************************/;
;/* Monitor For : CP89C51 V1.0 */;
;/* Files Name  : DEMO_RTC.ASM */;
;/* CPU Control : AT89C51      */;
;/* Assembler   : SXA51        */;
;/* Function    : Test DS1202  */;
;/******************************/;
;
RTC_CLOCK   EQU     P2.4                    ; RTC Serial Clock
RTC_DATA    EQU     P2.5                    ; RTC Serial Data
RTC_RESET   EQU     P2.6                    ; RTC Reset (Chips Select)
ADC_CS      EQU     P2.7                    ; ADC Chips Select
;
ORG         20H                             ; Internal RAM of CPU
FLAG_BUF:   DS      1                       ; Flag Status
SEC_CNT:    DS      1                       ; Time (1-Second) Buffer Count
STACK:      DS      32
;
STAS_DSP    EQU     FLAG_BUF.0              ; Status Display
UPDATE      EQU     FLAG_BUF.1
;
;/* Constant Value */;
SECOND      EQU     00H                     ; Second 00-59
MINUTE      EQU     01H                     ; Minute 00-59
HOUR        EQU     02H                     ; Hour 01-12 or 00-23
DATE        EQU     03H                     ; Data 01-28/29 or 01-30 or 01-31
MONTH       EQU     04H                     ; Month 01-12
DAY         EQU     05H                     ; Day 01-07
YEAR        EQU     06H                     ; Year 00-99
CTRL_RTC    EQU     07H                     ; Write Protect Enable/Disable
;
            ORG     0000H                   ; Reset Vector of CPU
            LJMP    MAIN
            ;
            ORG     000BH                   ; Timer0 Vector Interupt
            LJMP    TIMER_INT
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     FLAG_BUF,#0
            ;
INIT_SER:   MOV     TMOD,#00100001B         ; Timer1(8Bit-Auto) & Timer0(16Bit)
            MOV     SCON,#01010000B         ; Serial Port Mode 1
            SETB    PS                      ; Serial Interupt High Piority
            CLR     ES                      ; Disable Serial Interupt
            SETB    ET0                     ; Enable Timer0 Interupt
            CLR     ET1                     ; Disable Timer1 Interupt
            MOV     A,#0FDH                 ; Set Baudrate 9600
            MOV     TH1,A
            MOV     TL1,A
            SETB    TR0                     ; Start Timer0
            SETB    TR1                     ; Start Timer1
            SETB    EA                      ; Enable Global Interupt
            ;
;/***************/;
;/* Test DS1202 */;
;/***************/;
;
TEST_RTC:   LCALL   PRINT_SER
            DB      0DH,0AH,0AH
            DB      'Test DS1202',0DH,0AH,00
            ;
            LCALL   DISABLE                 ; Write Protect OFF
            MOV     A,#SECOND
            LCALL   READ_RTC
            CLR     ACC.7                   ; Disable Clock Halt Flag
            MOV     B,A
            MOV     A,#SECOND
            LCALL   WRITE_RTC
            LCALL   ENABLE                  ; Write Protect ON
            ;
            MOV     SEC_CNT,#50             ; 0.5-Second Counter (10mS x 50)
            MOV     TH0,#0DBH               ; 10 mSec Period
            MOV     TL0,#0FFH
            CLR     UPDATE
            SETB    ET0                     ; Enable Timer0 Interupt
            SETB    TR0
            ;
LOOP_RTC:   JB      UPDATE,DSP_TIME
            SJMP    LOOP_RTC
            ;
DSP_TIME:   MOV     A,#0DH
            LCALL   TX_BYTE
            LCALL   PRINT_SER
            DB      'TIME : ',00H
            MOV     A,#HOUR                 ; Get Hour Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            ADD     A,#30H
            LCALL   TX_BYTE
            POP     ACC
            ANL     A,#0FH
            ADD     A,#30H
            LCALL   TX_BYTE
            ;
            JNB     STAS_DSP,DSP_TIM1
            MOV     A,#':'
            LCALL   TX_BYTE
            SJMP    DSP_TIM2
DSP_TIM1:   MOV     A,#20H                  ; Blank
            LCALL   TX_BYTE
            ;
DSP_TIM2:   MOV     A,#MINUTE               ; Get Minute Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            ADD     A,#30H
            LCALL   TX_BYTE
            POP     ACC
            ANL     A,#0FH
            ADD     A,#30H
            LCALL   TX_BYTE
            ;
            JNB     STAS_DSP,DSP_TIM3
            MOV     A,#':'
            LCALL   TX_BYTE
            SJMP    DSP_TIM4
DSP_TIM3:   MOV     A,#20H                  ; Blank
            LCALL   TX_BYTE
            ;
DSP_TIM4:   MOV     A,#SECOND               ; Get Second Time
            LCALL   READ_RTC
            PUSH    ACC
            SWAP    A
            ANL     A,#0FH
            ADD     A,#30H
            LCALL   TX_BYTE
            POP     ACC
            ANL     A,#0FH
            ADD     A,#30H
            LCALL   TX_BYTE
            CLR     UPDATE
            LJMP    LOOP_RTC

;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial port */;
;/*************************/;
;
TX_BYTE:    MOV     SBUF,A
            JNB     TI,$                    ; Wait TX Data Ready
            CLR     TI
            RET

;/************************/;
;/* Convert ASCII to HEX */;
;/* Input  : ACC (ASCII) */;
;/* Output : ACC (HEX)   */;
;/************************/;
;
ASC_HEX:    PUSH    PSW
            CJNE    A,#41H,ASC_HEX1         ; "A"
ASC_HEX1:   JC      ASC_HEX3                ; 30H-39H Jump
ASC_HEX2:   ADD     A,#09H                  ; A-F(ASCII) ==> A-F(Hex)
ASC_HEX3:   ANL     A,#00001111B            ; Convert ASCII to HEX
            POP     PSW
            RET

;/************************/;
;/* Send 2 byte of ASCII */;
;/* Input : ACC (HEX)    */;
;/* Exam. : A = A3H      */;
;/*       : Send 41H,33H */;
;/************************/;
;
TX_2ASC:    LCALL   HEX_2ASC
            LCALL   TX_BYTE
            MOV     A,B
            LCALL   TX_BYTE
            RET

;/****************************/;
;/* Convert 1-HEX to 2-ASCII */;
;/* Input  : ACC (Hex)       */;
;/* Output : ACC (High-Byte) */;
;/*        : B   (Low-Byte)  */;
;/* Exam A = 41H => 34H,31H  */;
;/****************************/;
;
HEX_2ASC:   PUSH    ACC
            LCALL   HEX_ASC
            MOV     B,A                     ; B = Lo byte
            POP     ACC
            SWAP    A
            LCALL   HEX_ASC                 ; A = High Byte
            RET

;/*****************************/;
;/* Convert Hex(0-F) to ASCII */;
;/* Input  : ACC (HEX code)   */;
;/* Output : ACC (ASCII code) */;
;/*****************************/;
;
HEX_ASC:    PUSH    PSW
            CLR     CY
            ANL     A,#00001111B
            CJNE    A,#09H,HEX_ASC1
            SETB    CY
HEX_ASC1:   JNB     CY,HEX_ASC2             ; > 0AH
            ORL     A,#30H                  ; < 0AH
            SJMP    HEX_ASC3
HEX_ASC2:   SUBB    A,#09H                  ; > 0AH
            ORL     A,#40H
HEX_ASC3:   POP     PSW
            RET

;/****************************/;
;/* Read Ram From RTC-DS1202 */;
;/* Input    : ACC = Address */;
;/* Output   : ACC = Data    */;
;/* Reg.     : ACC,B,R2      */;
;/****************************/;
;
READ_RAM:   LCALL   START_RST               ; Start Communication
            MOV     R2,#8
            RL      A                       ; Shift A0 to A1
            SETB    ACC.7                   ; Command Status
            SETB    ACC.6                   ; Ram Accress
            SETB    ACC.0                   ; Read Command
            CLR     CY
READ_RAM1:  LCALL   CLOCK_LO                ; Falling Clock
            RRC     A                       ; Send D0..D7 (Read-Command)
            MOV     RTC_DATA,C              ; Prepare Port
            LCALL   CLOCK_HI                ; Rising Clock
            DJNZ    R2,READ_RAM1            ; Repeat Send Read-Command
            ;
            MOV     B,#0
            MOV     R2,#8
READ_RAM2:  SETB    RTC_DATA                ; Initial for Input
            LCALL   CLOCK_LO                ; Read data D0..D7 (Data)
            MOV     C,RTC_DATA              ; Read data out bit
            MOV     A,B
            RRC     A                       ; Read D0..D7
            MOV     B,A                     ; Backup Data
            LCALL   CLOCK_HI                ; Rising Clock
            DJNZ    R2,READ_RAM2
            MOV     A,B                     ; Data Output 1-Byte
            LCALL   STOP_RST                ; Disable Communication
            RET

;/***************************/;
;/* Write Ram to RTC-DS1202 */;
;/* Input   : ACC = Address */;
;/*         : B = Data      */;
;/* Reg.    : ACC,B,R2      */;
;/***************************/;
;
WRITE_RAM:  LCALL   START_RST               ; Enable Communication
            MOV     R2,#8
            RL      A                       ; Shift A0 to A1
            SETB    ACC.7                   ; Command Status
            SETB    ACC.6                   ; Ram Accress
            CLR     ACC.0                   ; Write Command
            CLR     CY
WRITE_RAM1: LCALL   CLOCK_LO                ; Falling Clock
            RRC     A                       ; Send D0..D7 (Write-Command)
            MOV     RTC_DATA,C
            LCALL   CLOCK_HI                ; Rising Clock
            DJNZ    R2,WRITE_RAM1           ; Repeat write Command
            ;
            MOV     A,B                     ; Get Data For Send
            MOV     R2,#8
            CLR     CY
WRITE_RAM2: LCALL   CLOCK_LO                ; Falling Clock
            RRC     A                       ; Write D0..D7
            MOV     RTC_DATA,C
            LCALL   CLOCK_HI
            DJNZ    R2,WRITE_RAM2           ; Repeat write Data
            LCALL   STOP_RST                ; Disable Communication
            RET

;/****************************/;
;/* Read RTC From RTC-DS1202 */;
;/* Input    : ACC = Address */;
;/* Output   : ACC = Data    */;
;/* Reg.     : ACC,B,R2      */;
;/****************************/;
;
READ_RTC:   LCALL   START_RST               ; Start Communication
            MOV     R2,#8
            RL      A                       ; Shift A0 to A1
            SETB    ACC.7                   ; Command Status
            CLR     ACC.6                   ; Ram Accress
            SETB    ACC.0                   ; Read Command
            CLR     CY
READ_RTC1:  LCALL   CLOCK_LO                ; Falling Clock
            RRC     A                       ; Send D0..D7 (Read-Command)
            MOV     RTC_DATA,C              ; Prepare Port
            LCALL   CLOCK_HI                ; Clock
            DJNZ    R2,READ_RTC1            ; Repeat write Command
            ;
            MOV     B,#0
            MOV     R2,#8
READ_RTC2:  SETB    RTC_DATA                ; Initial for Input
            SETB    RTC_DATA                ; Initial for Input
            LCALL   CLOCK_LO                ; Read data D0..D7 (Data)
            MOV     C,RTC_DATA              ; Read data out bit
            MOV     A,B
            RRC     A                       ; Read D0..D7
            MOV     B,A                     ; Backup Data
            LCALL   CLOCK_HI                ; Rising Clock
            DJNZ    R2,READ_RTC2
            MOV     A,B                     ; Data Output 1-Byte
            LCALL   STOP_RST                ; Disable Communication
            RET

;/***************************/;
;/* Write RTC to RTC-DS1202 */;
;/* Input   : ACC = Address */;
;/*         : B = Data      */;
;/* Reg.    : ACC,B,R2      */;
;/***************************/;
;
WRITE_RTC:  LCALL   START_RST               ; Enable Communication
            MOV     R2,#8
            RL      A                       ; Shift A0 to A1
            SETB    ACC.7                   ; Command Status
            CLR     ACC.6                   ; Ram Accress
            CLR     ACC.0                   ; Write Command
            CLR     CY
WRITE_RTC1: LCALL   CLOCK_LO                ; Falling Clock
            RRC     A                       ; Write D0..D7 (Command)
            MOV     RTC_DATA,C
            LCALL   CLOCK_HI                ; Rising Clock
            DJNZ    R2,WRITE_RTC1           ; Repeat write Command
            ;
            MOV     A,B                     ; Get Data
            MOV     R2,#8
            CLR     CY
WRITE_RTC2: LCALL   CLOCK_LO
            RRC     A                       ; Write D0..D7
            MOV     RTC_DATA,C
            LCALL   CLOCK_HI                ; Rising Clock
            DJNZ    R2,WRITE_RTC2           ; Repeat write Data
            LCALL   STOP_RST                ; Disable Communication
            RET

;/*************************/;
;/* Write Protect Disable */;
;/* Now You Can Write RTC */;
;/* Reg.    : ACC,B,R2    */;
;/*************************/;
;
DISABLE:    MOV     A,#CTRL_RTC
            MOV     B,#00H                  ; Disable Write-Protect
            LCALL   WRITE_RTC
            RET

;/************************/;
;/* Write Protect Enable */;
;/* You Can't Write RTC  */;
;/* Reg.    : ACC,B,R2   */;
;/************************/;
;
ENABLE:     MOV     A,#CTRL_RTC
            MOV     B,#80H                  ; Enable Write-Protect
            LCALL   WRITE_RTC
            RET

;/*****************/;
;/*  RTC Clock    */;
;/*  Falling Edge */;
;/*****************/;
;
CLOCK_LO:   CLR     RTC_CLOCK               ; Falling Clock
            NOP
            NOP
            NOP
            NOP
            RET

;/***************/;
;/* RTC Clock   */;
;/* Rising Edge */;
;/***************/;
;
CLOCK_HI:   SETB    RTC_CLOCK               ; Rising Clock
            NOP
            NOP
            NOP
            NOP
            RET

;/*************************/;
;/* Initial Reset & Clock */;
;/* For Start Communicate */;
;/*************************/;
;
START_RST:  SETB    ADC_CS                  ; Disable LTC1298 Bus
            CLR     RTC_RESET
            NOP
            NOP
            NOP
            NOP
            CLR     RTC_CLOCK
            NOP
            NOP
            NOP
            NOP
            SETB    RTC_RESET               ; Enable Communication
            NOP
            NOP
            NOP
            NOP
            RET

;/*************************/;
;/* Initial Reset & Clock */;
;/*  For Stop Communicate */;
;/*************************/;
;
STOP_RST:   SETB    RTC_CLOCK
            NOP
            NOP
            NOP
            NOP
            CLR     RTC_RESET               ; Disable Communication
            NOP
            NOP
            NOP
            NOP
            RET

;/************************************/;
;/*  Print Data data to Serial Port  */;
;/*  to display buffer.              */;
;/*  Usage    : LCALL PRINT_SER      */;
;/*           : DB   'xxxx',00       */;
;/*  Register : ACC                  */;
;/*  Note     : last byte must be 00 */;
;/************************************/;
;
PRINT_SER:  POP     DPH
            POP     DPL
PRINT1:     CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRINT2
            LJMP    PRINT3
PRINT2:     LCALL   TX_BYTE
            INC     DPTR
            LJMP    PRINT1
PRINT3:     PUSH    DPL
            PUSH    DPH
            RET

;/******************************/;
;/* Timer 0 0.5 Second Service */;
;/*    Interupt Every 10 mSec  */;
;/* Auto Reload Every0.5Second */;
;/******************************/;
;
TIMER_INT:  MOV     TH0,#0DBH               ; 10 mSec Period Auto Reload
            MOV     TL0,#0FFH
            DJNZ    SEC_CNT+0,END_TIME      ; Check Time = 0.5 Second?
            MOV     SEC_CNT+0,#50           ; 10mSec x 50 = 0.5 Second
            CPL     STAS_DSP                ; Toggle Status Display
            SETB    UPDATE                  ; Update Time
END_TIME:   RETI

            END




