;/********************************/;
;/* Monitor For : CP89C51 V1.0   */;
;/* Files Name  : DEMO_OUT.ASM   */;
;/* CPU Control : AT89C51        */;
;/* Assembler   : SXA51          */;
;/* Function    : Test Output    */;
;/********************************/;
;
DATA_OUT    EQU     P0.0                    ; Data Shift-out Serial Output
GATE_OUT    EQU     P0.1                    ; Enable/Disable All Output Port
LATCH_OUT   EQU     P0.2                    ; Latch Clock Serial Output
SHIFT_OUT   EQU     P0.3                    ; Shift Clock Serial Output
;
ORG         20H                             ; Internal RAM of CPU
OUT_BUFF:   DS      3                       ; Output 00..23 Buffer
CNT_BUFF:   DS      1
ACC_BUFF:   DS      1
STACK:      DS      32
;
ORG         0000H                           ; Reset Vector of CPU
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            SETB    GATE_OUT                ; Disable Output Control
            ;
            MOV     OUT_BUFF+0,#0           ; Clear All Output
            MOV     OUT_BUFF+1,#0
            MOV     OUT_BUFF+2,#0
            CLR     GATE_OUT                ; Enable Output Control
            LCALL   SEND_OUT
            ;
TEST_OUT:   MOV     CNT_BUFF,#24
            MOV     ACC_BUFF,#00
LOOP1:      MOV     DPTR,#TAB_OUT
            MOV     A,ACC_BUFF              ; "ON" 01..24
            MOV     B,#3
            MUL     AB
            MOV     B,A
            MOVC    A,@A+DPTR
            MOV     OUT_BUFF+0,A
            INC     DPTR
            MOV     A,B
            MOVC    A,@A+DPTR
            MOV     OUT_BUFF+1,A
            INC     DPTR
            MOV     A,B
            MOVC    A,@A+DPTR
            MOV     OUT_BUFF+2,A
            LCALL   SEND_OUT
            LCALL   DELAY
            INC     ACC_BUFF
            DJNZ    CNT_BUFF,LOOP1
            LJMP    TEST_OUT                ; Loop Continue

;/**************************/;
;/* Delay Time For Display */;
;/**************************/;
;
DELAY:      MOV     R5,#4                   ; Delay Display
DLY0:       MOV     R6,#0
DLY1:       MOV     R7,#0
            DJNZ    R7,$
            DJNZ    R6,DLY1
            DJNZ    R5,DLY0
            RET

;/**************************/;
;/* Table Data Test Output */;
;/**************************/;
;
TAB_OUT:    DB      00H,00H,01H
            DB      00H,00H,02H
            DB      00H,00H,04H
            DB      00H,00H,08H
            DB      00H,00H,10H
            DB      00H,00H,20H
            DB      00H,00H,40H
            DB      00H,00H,80H
            DB      00H,01H,00H
            DB      00H,02H,00H
            DB      00H,04H,00H
            DB      00H,08H,00H
            DB      00H,10H,00H
            DB      00H,20H,00H
            DB      00H,40H,00H
            DB      00H,80H,00H
            DB      01H,00H,00H
            DB      02H,00H,00H
            DB      04H,00H,00H
            DB      08H,00H,00H
            DB      10H,00H,00H
            DB      20H,00H,00H
            DB      40H,00H,00H
            DB      80H,00H,00H

;/****************************/;
;/* Shift-out 24 Serial Data */;
;/* Input = OUT_BUFF (0..2)  */;
;/****************************/;
;
SEND_OUT:   PUSH    ACC                     ; Save Register
            PUSH    00H                     ; R0
            PUSH    01H                     ; R1
            PUSH    02H                     ; R2
            ;
            MOV     R0,#OUT_BUFF
            MOV     R1,#3                   ; 3-Serial Output Cascade
SHF_OUT0:   MOV     R2,#8                   ; Shift-out Counter
            MOV     A,@R0                   ; Get Data For Shift-out
SHF_OUT1:   RLC     A                       ; Shift Out data MSB..LSB
            MOV     DATA_OUT,C
            CLR     SHIFT_OUT               ; Shift Clock (Active __/-- Rising Edge)
            SETB    SHIFT_OUT
            DJNZ    R2,SHF_OUT1
            ;
            INC     R0                      ; Next Buffer to Shift-out
            DJNZ    R1,SHF_OUT0
            ;
            CLR     LATCH_OUT               ; Latch Clock (Active __/-- Rising Edge)
            SETB    LATCH_OUT
            ;
            POP     02H                     ; Restore Register
            POP     01H
            POP     00H
            POP     ACC
            RET

            END




