;/********************************/;
;/* Example For : CP89C51 V1.0   */;
;/* Files Name  : DEMO_LCD.ASM   */;
;/* CPU Control : AT89C51        */;
;/* Assembler   : SXA51          */;
;/* Function    : Test Char LCD  */;
;/********************************/;
;
RS_LCD      EQU     P1.1                    ; RS LCD
RW_LCD      EQU     P1.2                    ; Read/Write LCD
EN_LCD      EQU     P1.3                    ; Enable LCD
;
ORG         20H                             ; Internal RAM of CPU
LCD_BUFF:   DS      16                      ; LCD Display Buffer
STACK:      DS      32
;
ORG         0000H                           ; Reset Vector of CPU
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     R2,#0                   ; Power-on Delay
PWR_DLY1:   MOV     R3,#0
            DJNZ    R3,$
            DJNZ    R2,PWR_DLY1
            ;
            LCALL   INIT_LCD
            ;
LOOP:       MOV     A,#00H
            LCALL   GOTO_LCD
            LCALL   PRINT_LCD
            DB      'TEST LCD CP89C51',00H
            MOV     A,#40H
            LCALL   GOTO_LCD
            LCALL   PRINT_LCD
            DB      'BY...ETT CO.,LTD',00H
            LCALL   DELAY
            ;
            MOV     A,#00H
            LCALL   GOTO_LCD
            LCALL   PRINT_LCD
            DB      'Interface 4-Bits',00H
            MOV     A,#40H
            LCALL   GOTO_LCD
            LCALL   PRINT_LCD
            DB      'Control By Port1',00H
            LCALL   DELAY
            LJMP    LOOP

;/********************/;
;/* Initial Char-LCD */;
;/* 4-Bit Interfaces */;
;/********************/;
;
INIT_LCD:   SETB    EN_LCD                  ; Start-up Signal Control
            MOV     A,#33H                  ; Set DL=1 3-Time
            LCALL   WR_INS
            MOV     A,#32H                  ; Clear DL=0 1-Time
            LCALL   WR_INS
            MOV     A,#28H                  ; Function Set
            LCALL   WR_INS                  ; DL=0 4Bit,N=1 2Line,F=0 5X7
            MOV     A,#0CH                  ; Display on/off Control
            LCALL   WR_INS                  ; Entry Display,Cursor off,Cursor not blink
            MOV     A,#06H                  ; Entry Mode Set
            LCALL   WR_INS                  ; I/D=1 Increment,S=0 Cursor Shift
            MOV     A,#01H                  ; Clear Display
            LCALL   WR_INS                  ; Clear Display,Set DD RAM addr=0
            RET

;/******************************/;
;/* WR_INS : Write Instruction */;
;/* WR_LCD : Write Data to LCD */;
;/* Input  : ACC(Command/Data) */;
;/******************************/;
;
WR_INS:     CLR     RW_LCD                  ; Write LCD
            CLR     RS_LCD                  ; Instruction select
            SJMP    WR_LCD1
            ;
WR_LCD:     CLR     RW_LCD                  ; Write LCD
            SETB    RS_LCD                  ; Write Data Select
            ;
WR_LCD1:    PUSH    ACC                     ; Save Data
            ANL     A,#11110000B            ; High byte
            ANL     P1,#00001111B           ; Clear old Data
            ORL     P1,A
            LCALL   EN_WRLCD
            POP     ACC                     ; Restore Data
            SWAP    A                       ; Low byte
            ANL     A,#11110000B
            ANL     P1,#00001111B           ; Clear old Data
            ORL     P1,A
            LCALL   EN_WRLCD
            RET

;/************************/;
;/* Goto position of LCD */;
;/* Input : ACC(address) */;
;/************************/;
;
GOTO_LCD:   SETB    ACC.7                   ; Set DD-RAM Address
            LCALL   WR_INS
            RET

;/**********************/;
;/*   Mov LCD cursor   */;
;/* to Left 1 position */;
;/**********************/;
;
SHF_LFT:    MOV     A,#10H                  ; Shift Left Cursor
            LCALL   WR_INS
            RET

;/***********************/;
;/*    Mov LCD cursor   */;
;/* to Right 1 position */;
;/***********************/;
;
SHF_RGT:    MOV     A,#14H                  ; Shift Right Cursor
            LCALL   WR_INS
            RET

;/**********************/;
;/*  Enable Pin E LCD  */;
;/* Active Chip select */;
;/* Write : --\_____   */;
;/* Read  : __/--\__   */;
;/**********************/;
;
EN_WRLCD:   CLR     EN_LCD                  ; Enable CS of LCD
            LCALL   BUSY_LCD                ; Wait Busy
            SETB    EN_LCD                  ; Disable LCD
            RET

;/***********************/;
;/* Delay time for Busy */;
;/*    Wait LCD Ready   */;
;/* -Busy "0" = Ready   */;
;/* -Busy "1" = Busy    */;
;/***********************/;
;
BUSY_LCD:   MOV     R7,#0
            DJNZ    R7,$
            RET

;/********************************/;
;/*  Print Data to Dotmatrix LCD */;
;/*  Usage   : LCALL   PRINT_LCD */;
;/*          : DB      'xxxx',00 */;
;/*  Data last byte must be = 00 */;
;/********************************/;
;
PRINT_LCD:  POP     DPH                     ; Restore PC to Stack
            POP     DPL
PRN_LCD1:   CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRN_LCD2
            LJMP    PRN_LCD3
PRN_LCD2:   LCALL   WR_LCD                  ; Write LCD
            INC     DPTR
            LJMP    PRN_LCD1
PRN_LCD3:   PUSH    DPL                     ; Restore DPTR to PC
            PUSH    DPH
            RET

;/**************************/;
;/* Delay Time For Display */;
;/**************************/;
;
DELAY:      MOV     R5,#15                   ; Delay Display
DLY0:       MOV     R6,#0
DLY1:       MOV     R7,#0
            DJNZ    R7,$
            DJNZ    R6,DLY1
            DJNZ    R5,DLY0
            RET

            END





