;/******************************/;
;/* Monitor For : CP89C51 V1.0 */;
;/* Files Name  : DEMO_IN.ASM  */;
;/* CPU Control : AT89C51      */;
;/* Assembler   : SXA51        */;
;/* Function    : Test Input   */;
;/******************************/;
;
DATA_IN     EQU     P0.4                    ; Data Shift-in Serial Input
GATE_IN     EQU     P0.5                    ; "1" = Ser Shf,"0" = Parallel Load
LATCH_IN    EQU     P0.6                    ; Latch Clock Serial Input
SHIFT_IN    EQU     P0.7                    ; Shift Clock Serial Input
;
ORG         20H                             ; Internal RAM of CPU
IN_BUFF:    DS      3                       ; Input  00..23 Buffer
ACC_BUFF:   DS      1
STACK:      DS      32
;
ORG         0000H                           ; Reset Vector of CPU
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            MOV     TMOD,#00100001B         ; Timer1(8Bit-Auto) & Timer0(16Bit)
            MOV     SCON,#01010000B         ; Serial Port Mode 1
            CLR     ES                      ; Disable Serial Interupt
            CLR     ET1                     ; Disable Timer1 Interupt
            CLR     EA                      ; Disable Global Interupt
            MOV     A,#0FDH                 ; Set Baudrate 9600
            MOV     TH1,A
            MOV     TL1,A
            SETB    TR1                     ; Start Timer1
            ;
GET_INPUT:  LCALL   READ_IN                 ; Read Serial Input
            MOV     A,#0DH
            LCALL   TX_BYTE
            MOV     A,#'I'                  ; Display "IN : "
            LCALL   TX_BYTE
            MOV     A,#'N'
            LCALL   TX_BYTE
            MOV     A,#20H
            LCALL   TX_BYTE
            MOV     A,#':'
            LCALL   TX_BYTE
            MOV     A,#20H
            LCALL   TX_BYTE
            ;
            MOV     R2,#8
            MOV     A,IN_BUFF+0
            CPL     A
DSP_BIT1:   RLC     A
            PUSH    ACC
            CLR     A
            ADDC    A,#30H
            LCALL   TX_BYTE
            POP     ACC
            DJNZ    R2,DSP_BIT1
            ;
            MOV     A,#20H                  ; Space
            LCALL   TX_BYTE
            ;
            MOV     R2,#8
            MOV     A,IN_BUFF+1
            CPL     A
DSP_BIT2:   RLC     A
            PUSH    ACC
            CLR     A
            ADDC    A,#30H
            LCALL   TX_BYTE
            POP     ACC
            DJNZ    R2,DSP_BIT2
            ;
            MOV     A,#20H                  ; Space
            LCALL   TX_BYTE
            ;
            MOV     R2,#8
            MOV     A,IN_BUFF+2
            CPL     A
DSP_BIT3:   RLC     A
            PUSH    ACC
            CLR     A
            ADDC    A,#30H
            LCALL   TX_BYTE
            POP     ACC
            DJNZ    R2,DSP_BIT3
            ;
            LJMP    GET_INPUT

;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial port */;
;/*************************/;
;
TX_BYTE:    MOV     SBUF,A
            JNB     TI,$                    ; Wait TX Data Ready
            CLR     TI
            RET

;/***************************/;
;/* Shift-in 24 Serial Data */;
;/* Output : IN_BUFF (0..2) */;
;/***************************/;
;
READ_IN:    PUSH    ACC                     ; Save Register
            PUSH    00H                     ; R0
            PUSH    01H                     ; R1
            PUSH    02H                     ; R2
            ;
            CLR     GATE_IN                 ; "0" = Parallel Load
            CLR     LATCH_IN                ; Latch Clock (Active __/-- Rising Edge)
            SETB    LATCH_IN                ; Latch Logic Input & Load to Register
            SETB    GATE_IN                 ; "1" = Serial Shift
            ;
            MOV     R0,#IN_BUFF             ; Buffer Input (MSB First)
            MOV     R1,#3                   ; 3-Serial Input Cascade
SHF_DIN0:   MOV     R2,#8                   ; Shift-in Counter
SHF_DIN1:   MOV     C,DATA_IN               ; Shift-in Data
            CLR     SHIFT_IN                ; Shift Clock (Active __/-- Rising Edge)
            SETB    SHIFT_IN                ; Shift Next Bit Data
            RLC     A                       ; Save Data
            DJNZ    R2,SHF_DIN1
            ;
            MOV     @R0,A                   ; Save Buffer
            INC     R0                      ; Next Buffer
            DJNZ    R1,SHF_DIN0             ; Loop Until 3-Serial Input
            ;
            POP     02H                     ; Restore Register
            POP     01H
            POP     00H
            POP     ACC
            RET

            END





