;/********************************/;
;/* Monitor For : CP89C51 V1.0   */;
;/* Files Name  : TEST_MON.ASM   */;
;/* CPU Control : AT89C51        */;
;/* Assembler   : SXA51          */;
;/* (Test System & I/O on Board) */;
;/********************************/;
;
;/* Serial EEPROM (I2C-Bus 24LC256)
I2C_WPT     EQU     P1.0                    ; I2C-Bus Write Protect
I2C_SCL     EQU     P3.2                    ; I2C-Bus Clock
I2C_SDA     EQU     P3.5                    ; I2C-Bus Data
;
ORG         20H                             ; Internal RAM of CPU
ADDR_BUF:   DS      2
DATA_BUF:   DS      1
EEP_BUFF:   DS      2
STACK:      DS      32
            ;
            ORG     0000H                   ; Reset Vector of CPU
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            ;
            SETB    I2C_WPT                 ; Enable I2C Write Protect
            CLR     I2C_SCL                 ; Initial Bus For Stop
            CLR     I2C_SDA
            SETB    I2C_SCL
            SETB    I2C_SDA                 ; Stop Condition (SCL=1,SDA=1)
INIT_SER:   MOV     TMOD,#00100001B         ; Timer1(8Bit-Auto) & Timer0(16Bit)
            MOV     SCON,#01010000B         ; Serial Port Mode 1
            SETB    PS                      ; Serial Interupt High Piority
            CLR     ES                      ; Disable Serial Interupt
            CLR     ET0                     ; Disable Timer0 Interupt
            CLR     ET1                     ; Disable Timer1 Interupt
            MOV     A,#0FDH                 ; Set Baudrate 9600
            MOV     TH1,A
            MOV     TL1,A
            SETB    TR0                     ; Start Timer0
            SETB    TR1                     ; Start Timer1
            SETB    EA                      ; Enable Global Interupt


;/***************/;
;/* Test EEPROM */;
;/***************/;
;
TEST_EEP:   LCALL   PRINT_SER
            DB      0DH,0AH,0AH
            DB      'Test EEPROM 24C256',0DH,0AH,00
            ;
            MOV     EEP_BUFF+0,TH0
            MOV     EEP_BUFF+1,TL0
            ;
            LCALL   PRINT_SER
            DB      'Write Address 0000H = ',00H
            MOV     A,EEP_BUFF+0
            LCALL   TX_2ASC
            MOV     DPTR,#0000H             ; Address
            MOV     A,EEP_BUFF+0            ; Data
            LCALL   I2C_WRITE               ; Write Data to eeprom
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Read Address 0000H = ',00H
            MOV     DPTR,#0000H             ; Address
            LCALL   I2C_READ1
            LCALL   TX_2ASC
            ;
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Write Address 7FFFH = ',00H
            MOV     A,EEP_BUFF+1
            LCALL   TX_2ASC
            MOV     DPTR,#7FFFH            ; Address EEprom
            MOV     A,EEP_BUFF+1           ; Data
            LCALL   I2C_WRITE
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Read Address 7FFFH = ',00H
            MOV     DPTR,#7FFFH              ; Address
            LCALL   I2C_READ1
            LCALL   TX_2ASC
            ;
            MOV     EEP_BUFF+0,TH0
            MOV     EEP_BUFF+1,TL0
            ;
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Write Address 1000H = ',00H
            MOV     A,EEP_BUFF+0
            LCALL   TX_2ASC
            MOV     DPTR,#1000H             ; Address EEprom
            MOV     A,EEP_BUFF+0            ; Data
            LCALL   I2C_WRITE
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Read Address 1000H = ',00H
            MOV     DPTR,#1000H             ; Address
            LCALL   I2C_READ1
            LCALL   TX_2ASC
            ;
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Write Address 2000H = ',00H
            MOV     A,EEP_BUFF+1
            LCALL   TX_2ASC
            MOV     DPTR,#2000H             ; Address EEprom
            MOV     A,EEP_BUFF+1            ; Data
            LCALL   I2C_WRITE
            LCALL   PRINT_SER
            DB      0DH,0AH
            DB      'Read Address 2000H = ',00H
            MOV     DPTR,#2000H             ; Address
            LCALL   I2C_READ1
            LCALL   TX_2ASC
            CLR     RI
            ;
LOOP_EEP:   JNB     RI,$
            CLR     RI
            MOV     A,#00H
            PUSH    ACC
            PUSH    ACC
            RET

;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial port */;
;/*************************/;
;
TX_BYTE:    MOV     SBUF,A
            JNB     TI,$                    ; Wait TX Data Ready
            CLR     TI
            RET

;/****************************/;
;/* Receive Data From RS-232 */;
;/* Input   :  Serial Port   */;
;/* Output  :  ACC           */;
;/****************************/;
;
RX_BYTE:    JNB     RI,RX_BYTE              ; Wait RX Data Ready
            CLR     RI
            MOV     A,SBUF                  ; Get RX Data
            RET

;/************************/;
;/* Convert ASCII to HEX */;
;/* Input  : ACC (ASCII) */;
;/* Output : ACC (HEX)   */;
;/************************/;
;
ASC_HEX:    PUSH    PSW
            CJNE    A,#41H,ASC_HEX1         ; "A"
ASC_HEX1:   JC      ASC_HEX3                ; 30H-39H Jump
ASC_HEX2:   ADD     A,#09H                  ; A-F(ASCII) ==> A-F(Hex)
ASC_HEX3:   ANL     A,#00001111B            ; Convert ASCII to HEX
            POP     PSW
            RET

;/************************/;
;/* Send 2 byte of ASCII */;
;/* Input : ACC (HEX)    */;
;/* Exam. : A = A3H      */;
;/*       : Send 41H,33H */;
;/************************/;
;
TX_2ASC:    LCALL   HEX_2ASC
            LCALL   TX_BYTE
            MOV     A,B
            LCALL   TX_BYTE
            RET

;/****************************/;
;/* Convert 1-HEX to 2-ASCII */;
;/* Input  : ACC (Hex)       */;
;/* Output : ACC (High-Byte) */;
;/*        : B   (Low-Byte)  */;
;/* Exam A = 41H => 34H,31H  */;
;/****************************/;
;
HEX_2ASC:   PUSH    ACC
            LCALL   HEX_ASC
            MOV     B,A                     ; B = Lo byte
            POP     ACC
            SWAP    A
            LCALL   HEX_ASC                 ; A = High Byte
            RET

;/*****************************/;
;/* Convert Hex(0-F) to ASCII */;
;/* Input  : ACC (HEX code)   */;
;/* Output : ACC (ASCII code) */;
;/*****************************/;
;
HEX_ASC:    PUSH    PSW
            CLR     CY
            ANL     A,#00001111B
            CJNE    A,#09H,HEX_ASC1
            SETB    CY
HEX_ASC1:   JNB     CY,HEX_ASC2             ; > 0AH
            ORL     A,#30H                  ; < 0AH
            SJMP    HEX_ASC3
HEX_ASC2:   SUBB    A,#09H                  ; > 0AH
            ORL     A,#40H
HEX_ASC3:   POP     PSW
            RET

;/*****************************/;
;/* I2C-BUS 24LC256 Interface */;
;/* Write Data to I2C-EEPROM  */;
;/* Input  : DPTR (Address)   */;
;/*        : ACC (Data)       */;
;/*****************************/;
;
I2C_WRITE:  PUSH    B                       ; Save Register
            PUSH    ACC                     ; Save Data to Write
            CLR     I2C_WPT                 ; Disable Write Protect
            ;
            CLR     I2C_SCL                 ; Initial Bus For Start
            SETB    I2C_SDA                 
            SETB    I2C_SCL
            NOP                             ; TSU:STA Delay (5us)
            NOP
            NOP
            NOP
            NOP
            CLR     I2C_SDA                 ; Start Condition
            NOP                             ; THD:STA Delay (4us)
            NOP
            NOP
            NOP
            ;/* Ready to Start 1st Byte Send */;
            MOV     B,#8                    ; Write Control Byte 8-Bit Count
            MOV     A,#10100000B            ; 1010-Slave000,Write
            ;
I2C_WR1:    CLR     I2C_SCL                 ;/* Change Data to SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Line
            RLC     A                       ; Write MSB First
            MOV     I2C_SDA,C               ; Write Bit Data to SDA Signal
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Stobe Data to I2C-EEPROM
            NOP                             ; T-High Delay (4uS)
            NOP
            NOP
            NOP
            DJNZ    B,I2C_WR1               ; Loop to Write Control Byte
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Get ACK */;
            NOP
            CLR     CY
            JNB     I2C_SDA,I2C_WR2         ; If ACK Jump
            SETB    CY                      ; Not ACK From EEPROM
            POP     ACC
            LJMP    I2C_WR8
            ;
I2C_WR2:    MOV     B,#8                    ; Write Addr High-Byte Count
            MOV     A,DPH                   ; Address High Byte
            ;
I2C_WR3:    CLR     I2C_SCL                 ;/* Change Data to SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Line
            RLC     A                       ; Write MSB First
            MOV     I2C_SDA,C               ; Write Bit Data to SDA Signal
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Stobe Data to I2C-EEPROM
            NOP                             ; T-High Delay (4uS)
            NOP
            NOP
            NOP
            DJNZ    B,I2C_WR3               ; Loop to Write Addr High-Byte
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Get ACK */;
            NOP
            CLR     CY
            JNB     I2C_SDA,I2C_WR4         ; If ACK Jump
            SETB    CY                      ; Not ACK From EEPROM
            POP     ACC
            LJMP    I2C_WR8
            ;
I2C_WR4:    MOV     B,#8                    ; Write Addr Low-Byte Count
            MOV     A,DPL                   ; Address Low Byte
            ;
I2C_WR5:    CLR     I2C_SCL                 ;/* Change Data to SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Line
            RLC     A                       ; Write MSB First
            MOV     I2C_SDA,C               ; Write Bit Data to SDA Signal
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Stobe Data to I2C-EEPROM
            NOP                             ; T-High Delay (4uS)
            NOP
            NOP
            NOP
            DJNZ    B,I2C_WR5               ; Loop to Write Addr Low-Byte
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Get ACK */;
            NOP
            CLR     CY
            JNB     I2C_SDA,I2C_WR6         ; If ACK Jump
            SETB    CY                      ; Not ACK From EEPROM
            POP     ACC
            LJMP    I2C_WR8
            ;
I2C_WR6:    MOV     B,#8                    ; Write Data 8-Bit Count
            POP     ACC                     ; Restore Data For Write
            ;
I2C_WR7:    CLR     I2C_SCL                 ;/* Change Data to SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Line
            RLC     A                       ; Write MSB First
            MOV     I2C_SDA,C               ; Write Bit Data to SDA Signal
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Stobe Data to I2C-EEPROM
            NOP                             ; T-High Delay (4uS)
            NOP
            NOP
            NOP
            DJNZ    B,I2C_WR7               ; Loop to Write Data
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Get ACK */;
            NOP
            CLR     CY
            JNB     I2C_SDA,I2C_WR8         ; If ACK Jump
            SETB    CY                      ; Not ACK From EEPROM
            ;
I2C_WR8:    CLR     I2C_SCL                 ; Falling Stop Clock
            CLR     I2C_SDA
            NOP
            NOP
            SETB    I2C_SCL
            NOP                             ; TSU:STO (4us)
            NOP
            NOP
            NOP
I2C_WR9:    SETB    I2C_SDA                 ; Stop Condition (SCL=1,SDA=1)
            JNB     I2C_SDA,I2C_WR9         ; Wait Until Stop
            SETB    I2C_WPT                 ; Enable Write Protect
            POP     B                       ; Restore Register
            RET

;/*****************************/;
;/* I2C-BUS 24LC256 Interface */;
;/* Read Data From I2C-EEPROM */;
;/* -I2C_READ1 = Random Read  */;
;/*  Input  : DPTR (Address)  */;
;/*  Output : ACC (Data)      */;
;/* -I2C_READ2 = Current Read */;
;/*  Input  : None (Continue) */;
;/*  Output : ACC (Data)      */;
;/*****************************/;
;
I2C_READ1:  PUSH    B                       ; Save Register
            CLR     I2C_SCL                 ; Initial Bus For Start
            SETB    I2C_SDA                 
            SETB    I2C_SCL
            NOP                             ; TSU:STA Delay (5us)
            NOP
            NOP
            NOP
            NOP
            CLR     I2C_SDA                 ; Start Condition
            NOP                             ; THD:STA Delay (4us)
            NOP
            NOP
            NOP
            ;/* Ready to Start 1st Byte Send */;
            MOV     B,#8                    ; Write Control Byte 8-Bit Count
            MOV     A,#10100000B            ; 1010-Slave000,Write
            ;
I2C_RD1:    CLR     I2C_SCL                 ;/* Change Data to SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Line
            RLC     A                       ; Write MSB First
            MOV     I2C_SDA,C               ; Write Bit Data to SDA Signal
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Stobe Data to I2C-EEPROM
            NOP                             ; T-High Delay (4uS)
            NOP
            NOP
            NOP
            DJNZ    B,I2C_RD1               ; Loop to Write Control Byte
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Get ACK */;
            NOP
            CLR     CY
            JNB     I2C_SDA,I2C_RD2         ; If ACK Jump
            SETB    CY                      ; Not ACK From EEPROM
            LJMP    I2C_RD10
            ;
I2C_RD2:    MOV     B,#8                    ; Write Addr High-Byte Count
            MOV     A,DPH                   ; Address High Byte
            ;
I2C_RD3:    CLR     I2C_SCL                 ;/* Change Data to SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Line
            RLC     A                       ; Write MSB First
            MOV     I2C_SDA,C               ; Write Bit Data to SDA Signal
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Stobe Data to I2C-EEPROM
            NOP                             ; T-High Delay (4uS)
            NOP
            NOP
            NOP
            DJNZ    B,I2C_RD3               ; Loop to Write Addr High-Byte
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Get ACK */;
            NOP
            CLR     CY
            JNB     I2C_SDA,I2C_RD4         ; If ACK Jump
            SETB    CY                      ; Not ACK From EEPROM
            LJMP    I2C_RD10
            ;
I2C_RD4:    MOV     B,#8                    ; Write Addr Low-Byte Count
            MOV     A,DPL                   ; Address Low Byte
            ;
I2C_RD5:    CLR     I2C_SCL                 ;/* Change Data to SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Line
            RLC     A                       ; Write MSB First
            MOV     I2C_SDA,C               ; Write Bit Data to SDA Signal
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Stobe Data to I2C-EEPROM
            NOP                             ; T-High Delay (4uS)
            NOP
            NOP
            NOP
            DJNZ    B,I2C_RD5               ; Loop to Write Addr Low-Byte
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Get ACK */;
            NOP
            CLR     CY
            JNB     I2C_SDA,I2C_RD6         ; If ACK Jump
            SETB    CY                      ; Not ACK From EEPROM
            LJMP    I2C_RD10
            ;
            ;/* Current Address Read Operation */;
I2C_READ2:  PUSH    B                       ; Save Register
I2C_RD6:    CLR     I2C_SCL                 ; Falling New Start Clock
            SETB    I2C_SDA                 ; Initial Bus For Start
            SETB    I2C_SCL
            NOP                             ; TSU:STA Delay (5us)
            NOP
            NOP
            NOP
            NOP
            CLR     I2C_SDA                 ; Start Condition
            NOP                             ; THD:STA Delay (4us)
            NOP
            NOP
            NOP
            ;
            MOV     B,#8                    ; Write Control Byte 8-Bit Count
            MOV     A,#10100001B            ; 1010-Slave000,Read
            ;
I2C_RD7:    CLR     I2C_SCL                 ;/* Change Data to SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Line
            RLC     A                       ; Write MSB First
            MOV     I2C_SDA,C               ; Write Bit Data to SDA Signal
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Stobe Data to I2C-EEPROM
            NOP                             ; T-High Delay (4uS)
            NOP
            NOP
            NOP
            DJNZ    B,I2C_RD7               ; Loop to Write Control Byte
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Get ACK */;
            NOP
            CLR     CY
            JNB     I2C_SDA,I2C_RD8         ; If ACK Jump
            SETB    CY                      ; Not ACK From EEPROM
            LJMP    I2C_RD10
            ;
I2C_RD8:    MOV     B,#8                    ; Read Data 8-Bit Count
            CLR     CY
            CLR     A                       ; Clera Buffer For Read
            ;
I2C_RD9:    CLR     I2C_SCL                 ;/* Wait to Receive SDA Signal */;
            SETB    I2C_SDA                 ; Release Data Signal
            NOP
            NOP
            NOP
            NOP
            ;
            SETB    I2C_SCL                 ; Read Data From I2C-EEPROM
            NOP
            MOV     C,I2C_SDA               ; Get Data From SDA Signal
            RLC     A
            NOP
            DJNZ    B,I2C_RD9               ; Loop to Read Data 8-Bit
            ;
            CLR     I2C_SCL                 ;*/ Falling 9'th Clock For ACK */;
            SETB    I2C_SDA                 ; Release Data Line
            NOP
            NOP
            NOP
            NOP
            SETB    I2C_SCL                 ;*/ Rising 9'th Clock for Send ACK */;
            NOP
            NOP
            NOP
            NOP
            ;
I2C_RD10:   CLR     I2C_SCL                 ; Falling Stop Clock
            CLR     I2C_SDA
            NOP
            NOP
            NOP
            SETB    I2C_SCL
            NOP                             ; TSU:STO (4us)
            NOP
            NOP
            NOP
I2C_RD11:   SETB    I2C_SDA                 ; Stop Condition (SCL=1,SDA=1)
            JNB     I2C_SDA,I2C_RD11        ; Wait Until Stop
            POP     B                       ; Restore Register
            RET

;/****************************/;
;/* Generate Start Condition */;
;/****************************/;
;
I2C_START:  CLR     I2C_SCL                 ; Initial Bus For Start
            SETB    I2C_SDA                 
            SETB    I2C_SCL
            NOP                             ; TSU:STA Delay (5us)
            NOP
            NOP
            NOP
            NOP
            CLR     I2C_SDA                 ; Start Condition
            NOP                             ; THD:STA Delay (4us)
            NOP
            NOP
            NOP
            RET

;/***************************/;
;/* Generate Stop Condition */;
;/***************************/;
;
I2C_STOP:   CLR     I2C_SCL                 ; Falling Stop Clock
            CLR     I2C_SDA
            NOP
            NOP
            SETB    I2C_SCL
            NOP                             ; TSU:STO (4us)
            NOP
            NOP
            NOP
            SETB    I2C_SDA                 ; Stop Condition (SCL=1,SDA=1)
            RET

;/************************************/;
;/*  Print Data data to Serial Port  */;
;/*  to display buffer.              */;
;/*  Usage    : LCALL PRINT_SER      */;
;/*           : DB   'xxxx',00       */;
;/*  Register : ACC                  */;
;/*  Note     : last byte must be 00 */;
;/************************************/;
;
PRINT_SER:  POP     DPH
            POP     DPL
PRINT1:     CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRINT2
            LJMP    PRINT3
PRINT2:     LCALL   TX_BYTE
            INC     DPTR
            LJMP    PRINT1
PRINT3:     PUSH    DPL
            PUSH    DPH
            RET

            END





            

