;/*******************************/;
;/* Monitor For : CP89C51 V1.0  */;
;/* Files Name  : DEMO_ADC.ASM  */;
;/* CPU Control : AT89C51       */;
;/* Assembler   : SXA51         */;
;/* Function    : Test LTC1298  */;
;/*******************************/;
;
;/* Serial ADC (LTC1298)
ADC_INA     EQU     P2.0                    ; Analog Multiplex 1:8
ADC_INB     EQU     P2.1
ADC_INC     EQU     P2.2
ADC_INH     EQU     P2.3                    ; Analog Multiplex Enable/Disable
ADC_CLOCK   EQU     P2.4                    ; ADC Serial Clock
ADC_DATA    EQU     P3.7                    ; ADC Serial Data
ADC_CS      EQU     P2.7                    ; ADC Chips Select
RTC_RESET   EQU     P2.6                    ; RTC Reset (Chips Select)
;
ORG         20H                             ; Internal RAM of CPU
STACK:      DS      32
;
ORG         0000H                           ; Reset Vector of CPU
            ;
MAIN:       MOV     SP,#STACK               ; Initial Stack 32 Byte
            SETB    RTC_RESET               ; Disable RTC
            ;
            MOV     TMOD,#00100001B         ; Timer1(8Bit-Auto) & Timer0(16Bit)
            MOV     SCON,#01010000B         ; Serial Port Mode 1
            CLR     ES                      ; Disable Serial Interupt
            CLR     ET1                     ; Disable Timer1 Interupt
            MOV     A,#0FDH                 ; Set Baudrate 9600
            MOV     TH1,A
            MOV     TL1,A
            SETB    TR1                     ; Start Timer1
            CLR     EA                      ; Disable Global Interupt

;/****************/;
;/* Test LTC1298 */;
;/****************/;
;
LOOP_ADC:   MOV     A,#0DH
            LCALL   TX_BYTE
            MOV     A,#'A'
            LCALL   TX_BYTE
            MOV     A,#'D'
            LCALL   TX_BYTE
            MOV     A,#'C'
            LCALL   TX_BYTE
            MOV     A,#' '
            LCALL   TX_BYTE
            MOV     A,#'['
            LCALL   TX_BYTE
            MOV     A,#'1'
            LCALL   TX_BYTE
            MOV     A,#'.'
            LCALL   TX_BYTE
            MOV     A,#'.'
            LCALL   TX_BYTE
            MOV     A,#'8'
            LCALL   TX_BYTE
            MOV     A,#']'
            LCALL   TX_BYTE
            MOV     A,#' '
            LCALL   TX_BYTE
            MOV     A,#'='
            LCALL   TX_BYTE
            MOV     A,#' '
            LCALL   TX_BYTE
            ;
            MOV     A,#01H                  ; CH1
            LCALL   READ_ADN
            MOV     A,DPH
            LCALL   TX_2ASC
            MOV     A,DPL
            LCALL   TX_2ASC
            MOV     A,#20H
            LCALL   TX_BYTE
            ;
            MOV     A,#02                   ; CH2
            LCALL   READ_ADN
            MOV     A,DPH
            LCALL   TX_2ASC
            MOV     A,DPL
            LCALL   TX_2ASC
            MOV     A,#20H
            LCALL   TX_BYTE
            ;
            MOV     A,#03                   ; CH3
            LCALL   READ_ADN
            MOV     A,DPH
            LCALL   TX_2ASC
            MOV     A,DPL
            LCALL   TX_2ASC
            MOV     A,#20H
            LCALL   TX_BYTE
            ;
            MOV     A,#04                   ; CH4
            LCALL   READ_ADN
            MOV     A,DPH
            LCALL   TX_2ASC
            MOV     A,DPL
            LCALL   TX_2ASC
            MOV     A,#20H
            LCALL   TX_BYTE
            ;
            MOV     A,#05                   ; CH5
            LCALL   READ_ADN
            MOV     A,DPH
            LCALL   TX_2ASC
            MOV     A,DPL
            LCALL   TX_2ASC
            MOV     A,#20H
            LCALL   TX_BYTE
            ;
            MOV     A,#06                   ; CH6
            LCALL   READ_ADN
            MOV     A,DPH
            LCALL   TX_2ASC
            MOV     A,DPL
            LCALL   TX_2ASC
            MOV     A,#20H
            LCALL   TX_BYTE
            ;
            MOV     A,#07                   ; CH7
            LCALL   READ_ADN
            MOV     A,DPH
            LCALL   TX_2ASC
            MOV     A,DPL
            LCALL   TX_2ASC
            MOV     A,#20H
            LCALL   TX_BYTE
            ;
            MOV     A,#08                   ; CH8
            LCALL   READ_ADN
            MOV     A,DPH
            LCALL   TX_2ASC
            MOV     A,DPL
            LCALL   TX_2ASC
            MOV     A,#20H
            LCALL   TX_BYTE
            LJMP    LOOP_ADC

;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial port */;
;/*************************/;
;
TX_BYTE:    MOV     SBUF,A
            JNB     TI,$                    ; Wait TX Data Ready
            CLR     TI
            RET

;/************************/;
;/* Convert ASCII to HEX */;
;/* Input  : ACC (ASCII) */;
;/* Output : ACC (HEX)   */;
;/************************/;
;
ASC_HEX:    PUSH    PSW
            CJNE    A,#41H,ASC_HEX1         ; "A"
ASC_HEX1:   JC      ASC_HEX3                ; 30H-39H Jump
ASC_HEX2:   ADD     A,#09H                  ; A-F(ASCII) ==> A-F(Hex)
ASC_HEX3:   ANL     A,#00001111B            ; Convert ASCII to HEX
            POP     PSW
            RET

;/************************/;
;/* Send 2 byte of ASCII */;
;/* Input : ACC (HEX)    */;
;/* Exam. : A = A3H      */;
;/*       : Send 41H,33H */;
;/************************/;
;
TX_2ASC:    LCALL   HEX_2ASC
            LCALL   TX_BYTE
            MOV     A,B
            LCALL   TX_BYTE
            RET

;/****************************/;
;/* Convert 1-HEX to 2-ASCII */;
;/* Input  : ACC (Hex)       */;
;/* Output : ACC (High-Byte) */;
;/*        : B   (Low-Byte)  */;
;/* Exam A = 41H => 34H,31H  */;
;/****************************/;
;
HEX_2ASC:   PUSH    ACC
            LCALL   HEX_ASC
            MOV     B,A                     ; B = Lo byte
            POP     ACC
            SWAP    A
            LCALL   HEX_ASC                 ; A = High Byte
            RET

;/*****************************/;
;/* Convert Hex(0-F) to ASCII */;
;/* Input  : ACC (HEX code)   */;
;/* Output : ACC (ASCII code) */;
;/*****************************/;
;
HEX_ASC:    PUSH    PSW
            CLR     CY
            ANL     A,#00001111B
            CJNE    A,#09H,HEX_ASC1
            SETB    CY
HEX_ASC1:   JNB     CY,HEX_ASC2             ; > 0AH
            ORL     A,#30H                  ; < 0AH
            SJMP    HEX_ASC3
HEX_ASC2:   SUBB    A,#09H                  ; > 0AH
            ORL     A,#40H
HEX_ASC3:   POP     PSW
            RET

;/**************************/;
;/* Read Data From LTC1298 */;
;/* Input  : ACC (Chxx)    */;
;/* Output : DPTR          */;
;/**************************/;
; START,SGL,ODD,MSBF = ADC
;   1    1   0   X   = Ch0
;   1    1   1   X   = Ch1
; MSBF = 1 = MSB First
; MSBF = 0 = LSB First
; A = 1101 XXXX = Ch0(DF)
; A = 1111 XXXX = Ch1(FF)
;
READ_ADN:   MOV     DPTR,#0000H             ; Clear Output
            CJNE    A,#0,READ_AD0
            SJMP    READ_AD6                ; Lower Channel (1-8)
            ;
READ_AD0:   CJNE    A,#9,READ_AD1
READ_AD1:   JNC     READ_AD6                ; Upper Channel (1-8)
            DEC     A                       ; Adjust to 0-7
            ANL     P2,#11110000B           ; Clear old Channel
            ORL     P2,A                    ; Update New Channel
            ;
            ;/* Start Read LTC1298 CH0
            ;/*          Ref=GND   Ref=CH1
            ;/* ACC.7 =     1         1     Start Bit
            ;/* ACC.6 =     1         0     SGL/DIFF
            ;/* ACC.5 =     0         0     ODD/SIGN
            ;/* ACC.4 = 1   1         1     MSB First
            ;
READ_AD2:   PUSH    B
            MOV     A,#00H                  ; Din Word For Ch0 Read
            SWAP    A                       ; Swap Data
            RL      A                       ; Shift User Channel to ODD
            SETB    ACC.7                   ; Start Bit
            SETB    ACC.6                   ; SGL/DIFF = 1 (Ref:GND)
            ;CLR     ACC.6                   ; SGL/DIFF = 0 (Ref:CH1)
            CLR     ACC.5                   ; ODD/SIGN = 0
            SETB    ACC.4                   ; MSBF = 1 (MSB Read First)
            SETB    ADC_CLOCK               ; Makesure Start Clock
            LCALL   DLY_50US                ; Delay 11KHz Clock
            SETB    ADC_DATA                ; Start Bit
            SETB    ADC_CS                  ; Makesure CS=High
            CLR     ADC_CS                  ; Start Operation
            ;
            MOV     B,#4                    ; Counter (START/SGL/ODD/MSBF)
READ_AD3:   RLC     A                       ; Rotate Din to Carry
            CLR     ADC_CLOCK               ; Clock Low
            LCALL   DLY_50US                ; Delay 11KHz Clock
            MOV     ADC_DATA,C              ; Get Data
            SETB    ADC_CLOCK               ; Clock High (ADC Receive Data)
            LCALL   DLY_50US                ; Delay 11KHz Clock
            DJNZ    B,READ_AD3              ; Loop Send Data Word 4 Bit
            ;
            SETB    ADC_DATA                ; Start for Input Read
            CLR     ADC_CLOCK               ; Clock Low
            LCALL   DLY_50US                ; Delay 11KHz Clock
            MOV     B,#5                    ; Counter MSB 4-Bit & Null
READ_AD4:   SETB    ADC_DATA                ; Initial Port For Read
            MOV     C,ADC_DATA              ; Read Data
            RLC     A                       ; Rotate Carry to Data
            SETB    ADC_CLOCK               ; Clock High
            LCALL   DLY_50US                ; Delay 11KHz Clock
            CLR     ADC_CLOCK               ; Clock Low
            LCALL   DLY_50US                ; Delay 11KHz Clock
            DJNZ    B,READ_AD4              ; Next bit
            ANL     A,#0FH                  ; Only 4bit Data  (D11..D8)
            MOV     DPH,A                   ; Save Result MSB Data
            ;
            CLR     A
            MOV     B,#8                    ; Counter LSB 8-bit Data
READ_AD5:   SETB    ADC_DATA                ; Initial Port For Read
            MOV     C,ADC_DATA              ; Read Data
            RLC     A                       ; Rotate Carry to Data
            SETB    ADC_CLOCK               ; Clock High
            LCALL   DLY_50US                ; Delay 11KHz Clock
            CLR     ADC_CLOCK               ; Clock Low
            LCALL   DLY_50US                ; Delay 11KHz Clock
            DJNZ    B,READ_AD5              ; Next Bit
            MOV     DPL,A                   ; Save Result LSB (D7..D0)
            SETB    ADC_CS                  ; Stop Operation
            POP     B
            ;
READ_AD6:   SETB    ADC_INH                 ; Disable Multiplex
            RET

;/*********************/;
;/* Delay Clock 10KHz */;
;/*********************/;
;
DLY_50US:   PUSH    B                       ; Save B
            MOV     R2,#25
            DJNZ    R2,$
            POP     B                       ; Restore B
            RET

            END

