;/********************************/;
;/* Monitor For : CP89C51 V1.0   */;
;/* Files Name  : TEST_MON.ASM   */;
;/* CPU Control : AT89C51        */;
;/* Assembler   : SXA51          */;
;/* (Test System & I/O on Board) */;
;/********************************/;
;
;/* Serial Output Logic
DATA_OUT    EQU     P0.0                    ; Data Shift-out Serial Output
GATE_OUT    EQU     P0.1                    ; Enable/Disable All Output Port
LATCH_OUT   EQU     P0.2                    ; Latch Clock Serial Output
SHIFT_OUT   EQU     P0.3                    ; Shift Clock Serial Output
;
;/* Serial Input Logic
DATA_IN     EQU     P0.4                    ; Data Shift-in Serial Input
GATE_IN     EQU     P0.5                    ; "1" = Ser Shf,"0" = Parallel Load
LATCH_IN    EQU     P0.6                    ; Latch Clock Serial Input
SHIFT_IN    EQU     P0.7                    ; Shift Clock Serial Input
;
;/* LCD Dot-Matrix (Data = P1.4-7)
RS_LCD      EQU     P1.1                    ; RS LCD
RW_LCD      EQU     P1.2                    ; Read/Write LCD
EN_LCD      EQU     P1.3                    ; Enable LCD
;
;/* Serial ADC (LTC1298)
ADC_INA     EQU     P2.0                    ; Analog Multiplex 1:8
ADC_INB     EQU     P2.1
ADC_INC     EQU     P2.2
ADC_INH     EQU     P2.3                    ; Analog Multiplex Enable/Disable
ADC_CLOCK   EQU     P2.4                    ; ADC Serial Clock
ADC_DATA    EQU     P3.7                    ; ADC Serial Data
ADC_CS      EQU     P2.7                    ; ADC Chips Select
;
;/* Serial RTC (DS1202)
RTC_CLOCK   EQU     P2.4                    ; RTC Serial Clock
RTC_DATA    EQU     P2.5                    ; RTC Serial Data
RTC_RESET   EQU     P2.6                    ; RTC Reset (Chips Select)
;
;/* Serial EEPROM (I2C-Bus 24LC256)
I2C_WPT     EQU     P1.0                    ; I2C-Bus Write Protect
I2C_SCL     EQU     P3.2                    ; I2C-Bus Clock
I2C_SDA     EQU     P3.5                    ; I2C-Bus Data
;
;/* Digital Thermometer (DS1820)
DQ_TEMP     EQU     P3.4                    ; Data I/O of DS1820
;
;/* Watch-Dog (DS1232)
RST_WATCH   EQU     P3.3                    ; Reset Watch Dog
;
;/* RS485 Direction Control
DIR_485     EQU     P3.6                    ; Direction RS485
BUF_SIZE    EQU     20                      ; 20 Byte (Maximum RS-232 Command)
ACK         EQU     06H
;
;/* Constant Value */;
SECOND      EQU     00H                     ; Second 00-59
MINUTE      EQU     01H                     ; Minute 00-59
HOUR        EQU     02H                     ; Hour 01-12 or 00-23
DATE        EQU     03H                     ; Data 01-28/29 or 01-30 or 01-31
MONTH       EQU     04H                     ; Month 01-12
DAY         EQU     05H                     ; Day 01-07
YEAR        EQU     06H                     ; Year 00-99
CTRL_RTC    EQU     07H                     ; Write Protect Enable/Disable
;
            ORG     0000H                   ; Reset Vector of CPU
            ;
MAIN:       MOV     TMOD,#00100001B         ; Timer1(8Bit-Auto) & Timer0(16Bit)
            MOV     SCON,#01010000B         ; Serial Port Mode 1
            SETB    PS                      ; Serial Interupt High Piority
            CLR     ES                      ; Disable Serial Interupt
            CLR     ET0                     ; Disable Timer0 Interupt
            CLR     ET1                     ; Disable Timer1 Interupt
            MOV     A,#0FDH                 ; Set Baudrate 9600
            MOV     TH1,A
            MOV     TL1,A
            SETB    TR0                     ; Start Timer0
            SETB    TR1                     ; Start Timer1
            SETB    EA                      ; Enable Global Interupt
            ;
;/**********************/;
;/* Test RS232/422/485 */;
;/**********************/;
;
TEST_232:   LCALL   PRINT_SER
            DB      0DH,0AH,0AH
            DB      'Press Any Key For Test Serial Port',0DH,0AH,00
            CLR     RI
            ;
LOOP_232:   LCALL   RX_BYTE
ECHO_232:   LCALL   TX_BYTE
            SJMP    LOOP_232

;/*************************/;
;/* Send 1-Byte to RS-232 */;
;/* Input   : ACC         */;
;/* Output  : Serial port */;
;/*************************/;
;
TX_BYTE:    MOV     SBUF,A
            JNB     TI,$                    ; Wait TX Data Ready
            CLR     TI
            RET

;/****************************/;
;/* Receive Data From RS-232 */;
;/* Input   :  Serial Port   */;
;/* Output  :  ACC           */;
;/****************************/;
;
RX_BYTE:    JNB     RI,RX_BYTE              ; Wait RX Data Ready
            CLR     RI
            MOV     A,SBUF                  ; Get RX Data
            RET

;/************************************/;
;/*  Print Data data to Serial Port  */;
;/*  to display buffer.              */;
;/*  Usage    : LCALL PRINT_SER      */;
;/*           : DB   'xxxx',00       */;
;/*  Register : ACC                  */;
;/*  Note     : last byte must be 00 */;
;/************************************/;
;
PRINT_SER:  POP     DPH
            POP     DPL
PRINT1:     CLR     A
            MOVC    A,@A+DPTR
            CJNE    A,#00H,PRINT2
            LJMP    PRINT3
PRINT2:     LCALL   TX_BYTE
            INC     DPTR
            LJMP    PRINT1
PRINT3:     PUSH    DPL
            PUSH    DPH
            RET

            END





            



