/* Test ADC Convert & Floating Point
   By Complier ICC11 for Windows
   if Run by Debugger 68HC11 V2.0
    1. not include "vectors.c"
    2. set Options->Complier->Linker
       Text section = 0x2200	
       Stack = 0x9fff
    3. set Floating point printf = enable
*/
    
#include <stdio.h>
#include <hc11.h>
#include <float.h>
#include <math.h>

void convert1();
void convert2();
void main(void)
{
  float result;
  
  setbaud(BAUD9600);
  puts("Test ADC Ch1-8 & Floating Point Math Display By ICC11\n");
  puts("ADC1   ADC2   ADC3   ADC4   ADC5   ADC6   ADC7   ADC8\n");
  OPTION = 0x93;
        
  do
  { convert1();
    result = ADR1; 
    printf("%3.1fV   ",(float)0.019*result);
    result = ADR2; 
    printf("%3.1fV   ",(float)0.019*result);
    result = ADR3; 
    printf("%3.1fV   ",(float)0.019*result);
    result = ADR4; 
    printf("%3.1fV   ",(float)0.019*result);
  
    convert2();
    result = ADR1; 
    printf("%3.1fV   ",(float)0.019*result);
    result = ADR2; 
    printf("%3.1fV   ",(float)0.019*result);
    result = ADR3; 
    printf("%3.1fV   ",(float)0.019*result);
    result = ADR4; 
    printf("%3.1fV \r",(float)0.019*result);
  } while(1);  /* Loop Continue */
}
  
	
void convert1()
{
  ADCTL = 0x10;  /* convert AD0-3 */
  while ((ADCTL & 0x80) == 0);  
  /* Wait for the conversion to complete */
}

void convert2()
{
  ADCTL = 0x14; /* convert AD4-7 */
  while ((ADCTL & 0x80) == 0);  
  /* Wait for the conversion to complete */
}


/* 
#ifdef _HC16
#include "vectrs16.c"
#else
#include "vectors.c"
#endif
*/

