'
' Example Program Basic Language
' Test RTC6242 and Character lcd 16x2
' Hardware = CP68HC11 V2.0
' display time RTC6242 on LCD by interrupt 
'
include  "regs11.lib"

const    write_ins  = $1400    ' Write instruction lcd
const    read_ins   = $1401    ' Read instruction lcd
const    write_data = $1402    ' Write data lcd
const    rtc_sec1   = $1600    ' Second-1
const    rtc_sec10  = $1601    ' Second-10
const    rtc_min1   = $1602    ' Minute-1
const    rtc_min10  = $1603    ' Minute-10
const    rtc_hr1    = $1604    ' Hour-1
const    rtc_hr10   = $1605    ' Hour-10
const    rtc_day1   = $1606    ' Day-1
const    rtc_day10  = $1607    ' Day-10
const    rtc_mont1  = $1608    ' Month-1
const    rtc_mont10 = $1609    ' Month-10
const    rtc_year1  = $160A    ' Year-1
const    rtc_year10 = $160B    ' Year-10
const    rtc_week   = $160C    ' Day of Week
const    rtc_ctld   = $160D    ' Control Register-D
const    rtc_ctle   = $160E    ' Control Register-E
const    rtc_ctlf   = $160F    ' Control Register-F

declare  i
declare  j
declare  lcd_data
declare  lcd_addr
declare  rtc_status
declare  rtc_data1
declare  rtc_data2

cursor_16x2:
datab   $00,$01,$02,$03,$04,$05,$06,$07
datab   $08,$09,$0a,$0b,$0c,$0d,$0e,$0f
datab   $40,$41,$42,$43,$44,$45,$46,$47
datab   $48,$49,$4a,$4b,$4c,$4d,$4e,$4f

data_font:
datab   'T','e','s','t',' ','R','T','C'
datab   '6','2','4','2','&','L','C','D'
datab   'C','l','o','c','k',' ','=',' '
datab   ' ',' ',':',' ',' ',':',' ',' '

busy_lcd:
do
i = peekb(read_ins)
i = i and $80
loop while i <> 0
return

init_lcd:
gosub busy_lcd
pokeb write_ins,$38
gosub busy_lcd
pokeb write_ins,$0c
gosub busy_lcd
pokeb write_ins,$06
gosub busy_lcd
pokeb write_ins,$01
return

'clear_lcd:
'gosub busy_lcd
'pokeb write_ins,$01
'return

'home_lcd:
'gosub busy_lcd
'pokeb write_ins,$02
'return

'shift_left:
'gosub busy_lcd
'pokeb write_ins,$10
'return

'shift_right:
'gosub busy_lcd
'pokeb write_ins,$14
'return

'insert_left:
'gosub busy_lcd
'pokeb write_ins,$18
'return

'insert_right:
'gosub busy_lcd
'pokeb write_ins,$1c
'return

' input = address cursor in lcd_addr
set_cursor:
gosub busy_lcd
pokeb write_ins,lcd_addr+$80
return

' input = ascii in lcd_data
write_lcd:
gosub busy_lcd
pokeb write_data,lcd_data
return

' IRQ service routine
interrupt  $fff2
lcd_addr = peekb(addr(cursor_16x2)+ 24)
gosub set_cursor
lcd_data = peekb(rtc_hr10) and $0f + $30
gosub write_lcd
lcd_data = peekb(rtc_hr1) and $0f + $30
gosub write_lcd
lcd_data = ':'
gosub write_lcd
lcd_data = peekb(rtc_min10) and $0f + $30
gosub write_lcd
lcd_data = peekb(rtc_min1) and $0f + $30
gosub write_lcd
lcd_data = ':'
gosub write_lcd
lcd_data = peekb(rtc_sec10) and $0f + $30
gosub write_lcd
lcd_data = peekb(rtc_sec1) and $0f + $30
gosub write_lcd
end


main:
gosub init_lcd

for j = 0 to 31
lcd_addr = peekb(addr(cursor_16x2) + j)    ' get cursor address
gosub set_cursor
lcd_data = peekb(addr(data_font) + j)      ' get character
gosub write_lcd
next

pokeb rtc_ctlf,$01   ' Set 12/24 Hr
pokeb rtc_ctlf,$04   ' Set 24Hr
pokeb rtc_ctle,$04   ' Set STND Mode 1 Sec
pokeb rtc_ctld,$00   ' Set Hold Bit = 0
interrupts on        ' enable interrupts

do
loop while 1         ' loop continue
end




