'
' Example Program Basic Language
' Generate Music Note on OC5
' Used OC5 on interrupt Mode
' OC5 = Generate Frequency Note
' RTI = duration of Note
'
include  "regs11.lib"

declare  sound_timer
declare  freq
declare  ptr
declare  t

song:
datab   0, 3
datab   1, 3
datab   2, 3
datab   3, 3
datab   4, 3
datab   5, 3
datab   6, 3
datab   7, 3
datab   8, 3
datab   9, 3
datab   10, 3
datab   11, 3
datab   12, 3
datab   13, 3
datab   $ff

note_table:
data    0         ' no sound
data    2272      ' 440 Hz
data    2145      ' 466.2 Hz
data    2025      ' 493.9 Hz
data    1911      ' 523.3 Hz
data    1804      ' 554.4 Hz
data    1702      ' 587.4 Hz
data    1607      ' 622.4 Hz
data    1517      ' 659.4 Hz
data    1431      ' 698.6 Hz
data    1351      ' 740.2 Hz
data    1275      ' 784.2 Hz
data    1204      ' 830.9 Hz
data    1136      ' 880.0 Hz

delay_table:
data    0, 255, 190, 127, 94, 63, 47, 31, 23, 16

interrupt  $fff0                ' RTI ISR
if sound_timer >* 0
	sound_timer = sound_timer - 1
endif
pokeb tflg2, %01000000          ' clear RTI flag
end

interrupt  $ffe0                ' TOC5 ISR
poke toc5, peek(toc5) + freq
pokeb tflg1, %00001000
end


main:
pokeb baud, $30                 ' baud = 9600
pokeb sccr2, $0c                ' turn on xmtr and rcvr
print "Examples Program Timer/Counter Output Compare"
print "This Demo Used OC5 Generate Frequency of Note"
print "          Used RTI Control Duration of Note  "
print "Active Output OC5 & RTI Function on Interrupt"
print "Conncet Speaker on PA3 of Timer Port for test"
print

sound_timer = 0
pokeb tmsk2, peekb(tmsk2) or %01000000          ' enable RTI interrupts
pokeb tflg2, %01000000                          ' clear RTI flag
interrupts on                                   ' allow interrupts

pokeb tmsk1, peekb(tmsk1) or %00001000          ' start with toc5 intr on
pokeb tflg1, %00001000                          ' clear toc5 intr flag

do
	ptr = 0
	do
    t = peekb(addr(song) + ptr) * 2             ' get next note
    freq = peek(addr(note_table) + t)           ' convert to frequency

    ptr = ptr + 1                               ' point to duration
    t = peekb(addr(song) + ptr) * 2             ' get duration
		sound_timer = peek(addr(delay_table) + t)

    ptr = ptr + 1                               ' point to next note
    if freq <> 0                                ' if not a rest...
			poke toc5, peek(tcnt) + freq
      pokeb tctl1, peekb(tctl1) or %00000001    ' toggle oc5 on intr
		else
      pokeb tctl1, peekb(tctl1) and %11111100   ' no change on intr
		endif
		do  while sound_timer <> 0
		loop
	loop while peekb(addr(song) + ptr) <> $ff
loop
end

